/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.util;

import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.FileFinder;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.remote.RemoteError;
import com.iscobol.rts.Config;
import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VcobolNatureExt;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.license.LicenseController;
import com.vcobol.plugins.editor.license.MissingLicenseException;
import com.vcobol.plugins.editor.util.ErrorObj;
import com.vcobol.plugins.editor.util.ErrorsExt;
import com.vcobol.plugins.editor.util.InternalErrorException;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.vcobol.plugins.editor.util.ProjectFileFinder;
import com.vcobol.plugins.editor.util.ProjectSettingList;
import com.vcobol.plugins.editor.util.SettingList;
import com.vcobol.plugins.editor.util.SettingMode;
import com.vcobol.plugins.editor.views.VcobolNavigator;
import com.veryant.commons.editor.util.CopyFileName;
import com.veryant.commons.editor.util.operations.CreateFileOperation;
import com.veryant.commons.editor.util.operations.CreateFolderOperation;
import com.veryant.commons.editor.util.operations.CreateLinkFileOperation;
import com.veryant.commons.editor.util.operations.DeleteFileOperation;
import com.veryant.commons.editor.util.operations.DeleteFolderOperation;
import com.veryant.commons.editor.util.operations.ModifyFileOperation;
import com.veryant.vcobol.compiler.CompilerSettings;
import com.veryant.vcobol.compiler.CompilerSettingsException;
import com.veryant.vcobol.compiler.VCobolProduct;
import com.veryant.vcobol.compiler.lookup.ConcreteItem;
import com.veryant.vcobol.compiler.lookup.Lookup;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.ide.IDE;

/*
 * Exception performing whole class analysis ignored.
 */
public class PluginUtilities {
    private static final String oneAlpha = "(.)*((\\p{Alpha})|[-])(.)*";
    private static final String domainIdentifier = "((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})";
    private static final String domainNameRule = "(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum}))((\\.)(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})))*";
    public static final String TAIL_DELIM_STRING = " =():\".,";
    public static final String HEAD_DELIM_STRING = " =(:\",";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final int UNKNOWN_FORMAT = 0;
    public static final int ANSI_FORMAT = 1;
    public static final int TERMINAL_FORMAT = 2;
    public static final int FREE_FORMAT = 3;
    public static final int MIXED_FORMAT = 4;
    public static final String VCOBOL_NATURE_ID = "com.vcobol.plugins.editor.VcobolEditor.VcobolNature";
    public static final String VCOBOL_NATURE_EXT_ID = "com.vcobol.plugins.editor.VcobolEditor.VcobolNatureExt";
    public static final String[] SOURCE_FORMAT_OPTIONS = new String[]{"-sa", "-st", "-sf", "-smat"};
    private static Hashtable resourceListeners = new Hashtable();
    private static Hashtable projectDataTable = new Hashtable();

    private static void checkFilename(String filename, OptionList ol) throws InternalErrorException {
        if (filename.endsWith(".err") && (ol.getOption("-eo=") != null || ol.getOption("-ef") != null)) {
            throw new InternalErrorException(String.valueOf(filename) + ": " + VresourceBundle.getString((String)"incomp_opt_msg") + " " + "-ef");
        }
        if (filename.endsWith(".list") && (ol.getOption("-lo=") != null || ol.getOption("-lf") != null)) {
            throw new InternalErrorException(String.valueOf(filename) + ": " + VresourceBundle.getString((String)"incomp_opt_msg") + " " + "-lf");
        }
    }

    public static boolean isSourceFormat(String opt) {
        int i = 0;
        while (i < SOURCE_FORMAT_OPTIONS.length) {
            if (opt.equals(SOURCE_FORMAT_OPTIONS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static OptionList getCopy(OptionList ol) {
        ArrayList<String> opts = new ArrayList<String>();
        Enumeration en = ol.getAllKeys();
        while (en.hasMoreElements()) {
            String k = en.nextElement().toString();
            opts.add(String.valueOf(k) + ol.getOption(k));
        }
        return new OptionList(opts.toArray(new String[opts.size()]));
    }

    public static Pcc pccRun(String filename, String outDir, String propertyFile, OptionList ol, String spOpt, String javac, Reader reader, boolean wu, boolean generateCode, IResource resource) throws InternalErrorException {
        try {
            LicenseController.licinfo2();
        }
        catch (MissingLicenseException e) {
            throw new InternalErrorException(e.getMessage());
        }
        File f = new File(filename);
        if (!f.exists() || !f.canRead()) {
            throw new InternalErrorException(VresourceBundle.getString((String)"cannot_read_msg"));
        }
        if (outDir != null && outDir.length() > 0 && !outDir.endsWith(File.separator)) {
            outDir = String.valueOf(outDir) + File.separator;
        }
        PluginUtilities.checkFilename((String)filename, (OptionList)ol);
        ProjectFileFinder fileFinder = null;
        if (resource != null) {
            fileFinder = new ProjectFileFinder(resource, spOpt, ol.getOption("-ce="));
        }
        Pcc.resetAllCounters();
        VCobolProduct.configure();
        ol = PluginUtilities.getCopy((OptionList)ol);
        Lookup lookup = Lookup.getDefault();
        CompilerSettings cd = null;
        try {
            cd = new CompilerSettings(ol);
            lookup.addItem((Lookup.Item)ConcreteItem.create(CompilerSettings.class, (Object)cd));
        }
        catch (CompilerSettingsException cse) {
            throw new InternalErrorException(cse.getMessage());
        }
        Enumeration propertyNames = null;
        if (propertyFile != null) {
            propertyNames = PluginUtilities.setProperties((String)propertyFile);
        }
        Pcc Return = null;
        try {
            Return = Pcc.run((String)filename, (String)outDir, (OptionList)ol, (String)javac, (Errors)new ErrorsExt(wu), (Reader)reader, (boolean)generateCode, (FileFinder)fileFinder);
        }
        catch (ErrorInCompilationException e) {
            Return = e.pcc;
        }
        if (propertyNames != null) {
            PluginUtilities.unsetProperties((Enumeration)propertyNames);
        }
        return Return;
    }

    public static Pcc pccAnalyze(String filename, OptionList ol, String spOpt, Class errorClass, Reader reader, IResource resource, FileFinder fileFinder) {
        try {
            LicenseController.licinfo2();
        }
        catch (MissingLicenseException e) {
            throw new InternalErrorException(e.getMessage());
        }
        PluginUtilities.checkFilename((String)filename, (OptionList)ol);
        if (resource != null && fileFinder == null) {
            fileFinder = new ProjectFileFinder(resource, spOpt, ol.getOption("-ce="));
        }
        Pcc.resetAllCounters();
        VCobolProduct.configure();
        Lookup lookup = Lookup.getDefault();
        CompilerSettings cd = null;
        try {
            cd = new CompilerSettings(ol);
            lookup.addItem((Lookup.Item)ConcreteItem.create(CompilerSettings.class, (Object)cd));
        }
        catch (CompilerSettingsException cse) {
            throw new InternalErrorException(cse.getMessage());
        }
        return Pcc.analyze((String)filename, (OptionList)ol, (Class)errorClass, (Reader)reader, (FileFinder)fileFinder);
    }

    public static CopyFileName[] getCopyFileNames(Vector copyFileNames) {
        try {
            CopyFileName[] Return = new CopyFileName[copyFileNames.size()];
            int sz = copyFileNames.size();
            int i = 0;
            while (i < sz) {
                String[] ss = (String[])copyFileNames.elementAt(i);
                Return[i] = new CopyFileName(ss[0], Integer.parseInt(ss[1]), ss[2]);
                ++i;
            }
            return Return;
        }
        catch (Exception ex) {
            return new CopyFileName[0];
        }
    }

    public static ErrorObj convertToErrorObj(Object error) {
        if (error instanceof ErrorObj) {
            return (ErrorObj)error;
        }
        if (error instanceof String) {
            return new ErrorObj(0, 0, 0, 0, null, (String)error, null);
        }
        if (error instanceof RemoteError) {
            RemoteError re = (RemoteError)error;
            return new ErrorObj(re.getErrorNumber(), re.getErrorType(), re.getLineNumber(), re.getOffset(), re.getFilename(), re.getMessage(), re.getOther());
        }
        return null;
    }

    public static void resetClassLoader(IProject project) {
        PluginUtilities.getProjectData((IProject)project).urls = null;
    }

    public static void resetSourcePath(IProject project) {
        PluginUtilities.getProjectData((IProject)project).sourcePath = null;
        PluginUtilities.getProjectData((IProject)project).absoluteSourcePath = null;
    }

    public static String getPluginInstallLocation(String pluginId) throws IOException, URISyntaxException {
        URL url = FileLocator.toFileURL((URL)Platform.getBundle((String)pluginId).getEntry("/"));
        String Return = url.getPath();
        if (Platform.getOS().equals("win32")) {
            Return = Return.substring(1);
        }
        return Return;
    }

    public static boolean loadAndCheckClass(String className, String location) {
        try {
            URL[] urls = new URL[]{new File(location).toURI().toURL()};
            URLClassLoader urlcl = new URLClassLoader(urls, PluginUtilities.class.getClassLoader());
            Class<?> cls = urlcl.loadClass(className);
            return cls.getMethod("main", String[].class) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getVcobolLibraryPath() {
        try {
            String path;
            StringBuffer Return = new StringBuffer();
            String piloc = PluginUtilities.getPluginInstallLocation((String)"com.vcobol.plugins.libraries");
            StringTokenizer stn = new StringTokenizer(VresourceBundle.getString((String)"vcobol.libraries"), ",");
            if (stn.hasMoreTokens() && new File(path = String.valueOf(piloc) + "/" + stn.nextToken()).exists()) {
                Return.append(path);
            }
            while (stn.hasMoreTokens()) {
                path = String.valueOf(piloc) + "/" + stn.nextToken();
                if (!new File(path).exists()) continue;
                Return.append(File.pathSeparator).append(path);
            }
            return Return.toString();
        }
        catch (Exception ex) {
            PluginUtilities.log((Throwable)ex);
            return "";
        }
    }

    public static String getVcobolNativePath() {
        try {
            return String.valueOf(PluginUtilities.getPluginInstallLocation((String)"com.vcobol.plugins.libraries")) + "/native";
        }
        catch (Exception ex) {
            PluginUtilities.log((Throwable)ex);
            return "";
        }
    }

    public static void addPropertyChangeListener(IResource resource, PropertyChangeListener listener) {
        PropertyChangeSupport list = (PropertyChangeSupport)resourceListeners.get(resource);
        if (list == null) {
            list = new PropertyChangeSupport(resource);
            resourceListeners.put(resource, list);
        }
        list.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(IResource resource) {
        PropertyChangeSupport list = (PropertyChangeSupport)resourceListeners.get(resource);
        if (list != null) {
            PropertyChangeListener[] ll = list.getPropertyChangeListeners();
            int i = 0;
            while (i < ll.length) {
                list.removePropertyChangeListener(ll[i]);
                ++i;
            }
            resourceListeners.remove(resource);
        }
    }

    public static void removePropertyChangeListener(IResource resource, PropertyChangeListener listener) {
        PropertyChangeSupport list = (PropertyChangeSupport)resourceListeners.get(resource);
        if (list != null) {
            list.removePropertyChangeListener(listener);
            if (list.getPropertyChangeListeners().length == 0) {
                resourceListeners.remove(resource);
            }
        }
    }

    private static VcobolNatureExt checkNature(IProject project) throws InternalErrorException {
        try {
            if (project == null || project.getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") == null) {
                throw new InternalErrorException();
            }
            VcobolNatureExt inx = (VcobolNatureExt)project.getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNatureExt");
            return inx;
        }
        catch (CoreException ex) {
            PluginUtilities.log((Throwable)ex);
            throw new InternalErrorException((Throwable)ex);
        }
    }

    public static void removePersistentProperties(IFile file) {
        VcobolNatureExt inx = null;
        try {
            inx = PluginUtilities.checkNature((IProject)file.getProject());
        }
        catch (InternalErrorException ex) {
            return;
        }
        String path = file.getFullPath().toPortableString();
        inx.getProjectSettings().removeFileSettingList(path);
    }

    public static void copyPersistentProperties(IResource from, IResource to) {
        if (from.getProject() != to.getProject() || from.getType() != 1 || to.getType() != 1) {
            return;
        }
        VcobolNatureExt inx = null;
        try {
            inx = PluginUtilities.checkNature((IProject)from.getProject());
        }
        catch (InternalErrorException ex) {
            return;
        }
        String path = from.getFullPath().toPortableString();
        SettingList fromSl = inx.getProjectSettings().getFileSettingList(path);
        if (fromSl == null) {
            return;
        }
        path = to.getFullPath().toPortableString();
        SettingList toSl = inx.getProjectSettings().getFileSettingList(path);
        if (toSl == null) {
            toSl = new SettingList(path);
            inx.getProjectSettings().putFileSettingList(toSl);
        }
        Hashtable fromModes = fromSl.getModes();
        for (String m : fromModes.keySet()) {
            SettingMode fromMode = (SettingMode)fromModes.get(m);
            SettingMode toMode = toSl.getMode(m);
            if (toMode == null) {
                toMode = new SettingMode(m);
                toSl.addMode(toMode);
            }
            toMode.setProperties(fromMode.getProperties());
        }
    }

    public static void setPersistentProperty(IResource resource, String mode, String propName, String propValue) {
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)true);
        if (sl != null) {
            if (mode == null) {
                mode = "Default";
            }
            if (sl.hasMode(mode)) {
                String oldValue = sl.getProperty(mode, propName);
                if (resource.getType() != 4) {
                    if (propValue == null) {
                        sl.putProperty(mode, propName, "___vcobol.option.false");
                    } else {
                        sl.putProperty(mode, propName, propValue);
                    }
                } else if (propValue == null || propValue.equals("___vcobol.option.false")) {
                    sl.removeProperty(mode, propName);
                } else {
                    sl.putProperty(mode, propName, propValue);
                }
                PropertyChangeSupport list = (PropertyChangeSupport)resourceListeners.get(resource);
                if (list != null) {
                    list.firePropertyChange(propName, oldValue, propValue);
                }
            }
        }
    }

    public static String getPersistentProperty(IResource resource, String mode, String propName) {
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)false);
        if (sl != null) {
            if (mode == null) {
                mode = "Default";
            }
            if (sl.hasMode(mode)) {
                return sl.getProperty(mode, propName);
            }
        }
        return null;
    }

    public static void removePersistentProperty(IResource resource, String mode, String propName) {
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)false);
        if (sl != null) {
            if (mode == null) {
                mode = "Default";
            }
            if (sl.hasMode(mode)) {
                sl.removeProperty(mode, propName);
            }
        }
    }

    public static void putSettingList(SettingList sl, IProject project) {
        VcobolNatureExt inx = null;
        try {
            inx = PluginUtilities.checkNature((IProject)project);
        }
        catch (InternalErrorException ex) {
            return;
        }
        inx.getProjectSettings().putFileSettingList(sl);
    }

    public static SettingList getSettingList(IResource resource, boolean createNew) {
        VcobolNatureExt inx = null;
        try {
            inx = PluginUtilities.checkNature((IProject)resource.getProject());
        }
        catch (InternalErrorException ex) {
            return null;
        }
        ProjectSettingList sl = null;
        if (resource.getType() == 1) {
            String path = resource.getFullPath().toPortableString();
            sl = inx.getProjectSettings().getFileSettingList(path);
            if (sl == null && createNew) {
                sl = new SettingList(path);
                inx.getProjectSettings().putFileSettingList((SettingList)sl);
                Hashtable projectModes = inx.getProjectSettings().getModes();
                for (SettingMode sm : projectModes.values()) {
                    if (SettingMode.isFixedMode((String)sm.getName())) continue;
                    SettingMode newMode = new SettingMode(sm.getName());
                    sl.addMode(newMode);
                }
            }
        } else if (resource.getType() == 4) {
            sl = inx.getProjectSettings();
        }
        return sl;
    }

    public static String getCurrentSettingMode(IResource resource) {
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)false);
        if (sl != null) {
            if (resource.getType() == 4) {
                return sl.getCurrentMode();
            }
            String mode = sl.getCurrentMode();
            if (mode == null) {
                try {
                    ProjectSettingList psl = ((VcobolNatureExt)resource.getProject().getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNatureExt")).getProjectSettings();
                    return psl.getCurrentMode();
                }
                catch (CoreException coreException) {}
            } else {
                return mode;
            }
        }
        return null;
    }

    public static void setCurrentSettingMode(String mode, IResource resource) {
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)true);
        if (sl != null) {
            sl.setCurrentMode(mode);
        }
    }

    public static boolean hasSpecificSettings(IResource resource) {
        if (!(resource instanceof IFile) || !PluginUtilities.isSourceFile((IFile)((IFile)resource))) {
            return false;
        }
        String s = PluginUtilities.getPersistentProperty((IResource)resource.getProject(), (String)"Default", (String)"vcobol.checkfileopt");
        if (s == null || !s.equals("___vcobol.option.true")) {
            return false;
        }
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)false);
        if (sl == null) {
            return false;
        }
        if (sl.getCurrentMode() != null) {
            return true;
        }
        Hashtable modes = sl.getModes();
        for (SettingMode mode : modes.values()) {
            if (mode.getName().equals("Default") || mode.getPropertyCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public static void addSettingMode(String mode, IResource resource) {
        if (SettingMode.isFixedMode((String)mode)) {
            return;
        }
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)true);
        if (sl != null) {
            sl.addMode(new SettingMode(mode));
        }
        if (sl instanceof ProjectSettingList) {
            ProjectSettingList psl = (ProjectSettingList)sl;
            for (SettingList sl0 : psl.getFileSettings().values()) {
                if (sl0.hasMode(mode)) continue;
                sl0.addMode(new SettingMode(mode));
            }
        }
    }

    public static void removeSettingMode(String mode, IResource resource) {
        if (SettingMode.isFixedMode((String)mode)) {
            return;
        }
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)false);
        if (sl != null) {
            sl.removeMode(mode);
        }
        if (sl instanceof ProjectSettingList) {
            ProjectSettingList psl = (ProjectSettingList)sl;
            Iterator it = psl.getFileSettings().values().iterator();
            while (it.hasNext()) {
                ((SettingList)it.next()).removeMode(mode);
            }
        }
    }

    public static void copySettingMode(String sourceMode, String destMode, IResource resource) {
        if (SettingMode.isFixedMode((String)destMode)) {
            return;
        }
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)false);
        if (sl != null) {
            SettingMode src = sl.getMode(sourceMode);
            SettingMode dest = sl.getMode(destMode);
            if (src != null && dest != null) {
                dest.setProperties(src.getProperties());
            }
        }
    }

    public static String[] getSettingModes(IResource resource) {
        SettingList sl = PluginUtilities.getSettingList((IResource)resource, (boolean)false);
        if (sl != null) {
            Hashtable modes = sl.getModes();
            Object[] Return = new String[modes.size()];
            int i = 0;
            Iterator it = modes.keySet().iterator();
            while (it.hasNext()) {
                Return[i++] = (String)it.next();
            }
            Arrays.sort(Return);
            return Return;
        }
        return null;
    }

    public static void setResourcePersistentProperty(IResource resource, String propName, String propValue) {
        try {
            QualifiedName qn = new QualifiedName("vcobol", propName);
            resource.setPersistentProperty(qn, propValue);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static String getResourcePersistentProperty(IResource resource, String propName) {
        try {
            return resource.getPersistentProperty(new QualifiedName("vcobol", propName));
        }
        catch (CoreException ex) {
            PluginUtilities.log((Throwable)ex);
            return null;
        }
    }

    public static void saveProjectOptions(IProject project) {
        VcobolNatureExt inx = null;
        try {
            inx = PluginUtilities.checkNature((IProject)project);
        }
        catch (InternalErrorException internalErrorException) {
            // empty catch block
        }
        inx.saveOptions();
    }

    public static IFile getFile(String filename, IProject prj, String sp) {
        IFile Return = prj.getFile(filename);
        if (Return.exists()) {
            return Return;
        }
        StringTokenizer st = new StringTokenizer(sp, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            Return = prj.getFile(String.valueOf(tk) + "/" + filename);
            if (!Return.exists()) continue;
            return Return;
        }
        return null;
    }

    public static String getAbsoluteSourcePath(VcobolEditor editor, String mode) {
        IProject project = editor.getProject();
        if (project == null) {
            return "";
        }
        PluginUtilities.getSourcePath((IProject)project, (String)mode);
        ProjectData data = PluginUtilities.getProjectData((IProject)project);
        if (data.absoluteSourcePath != null) {
            String Return = (String)data.absoluteSourcePath.get(mode);
            if (Return == null) {
                Return = "";
            }
            if (editor.getFileEditorInput() != null) {
                if (Return.length() > 0) {
                    Return = String.valueOf(Return) + File.pathSeparator;
                }
                Return = String.valueOf(Return) + editor.getFileEditorInput().getPath().removeLastSegments(1);
            }
            return Return;
        }
        return "";
    }

    public static String getAbsoluteSourcePath(IFile file, String mode) {
        IProject project = file.getProject();
        if (project == null) {
            return "";
        }
        PluginUtilities.getSourcePath((IProject)project, (String)mode);
        ProjectData data = PluginUtilities.getProjectData((IProject)project);
        if (data.absoluteSourcePath != null) {
            String Return = (String)data.absoluteSourcePath.get(mode);
            if (Return == null) {
                Return = "";
            }
            if (Return.length() > 0) {
                Return = String.valueOf(Return) + File.pathSeparator;
            }
            Return = String.valueOf(Return) + File.pathSeparator + file.getLocation().removeLastSegments(1);
            return Return;
        }
        return "";
    }

    public static ClassLoader getClassLoader(IProject project, String mode) {
        if (project == null) {
            return null;
        }
        ProjectData data = PluginUtilities.getProjectData((IProject)project);
        if (data.urls == null) {
            String cp = PluginUtilities.getPersistentProperty((IResource)project, (String)"Default", (String)"vcobol.classpath");
            URL outputUrl = null;
            try {
                IContainer outFld = PluginUtilities.getOutputFolder((IProject)project, (String)mode);
                if (outFld != null) {
                    outputUrl = outFld.getLocation().toFile().toURI().toURL();
                }
            }
            catch (Exception outFld) {
                // empty catch block
            }
            if (cp != null) {
                StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
                Vector<URL> v = new Vector<URL>();
                while (st.hasMoreTokens()) {
                    File f = new File(st.nextToken());
                    if (!f.exists()) continue;
                    try {
                        v.addElement(f.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (outputUrl != null) {
                    data.urls = new URL[v.size() + 1];
                    data.urls[v.size()] = outputUrl;
                } else {
                    data.urls = new URL[v.size()];
                }
                int i = 0;
                while (i < v.size()) {
                    data.urls[i] = (URL)v.elementAt(i);
                    ++i;
                }
            } else {
                data.urls = outputUrl != null ? new URL[]{outputUrl} : new URL[0];
            }
        }
        if (data.urls != null) {
            return new URLClassLoader(data.urls, PluginUtilities.class.getClassLoader());
        }
        return null;
    }

    public static String getSourcePath(IProject project, String mode) {
        if (project == null) {
            return null;
        }
        ProjectData data = PluginUtilities.getProjectData((IProject)project);
        if (data.sourcePath == null || !data.sourcePath.containsKey(mode)) {
            StringBuffer val = new StringBuffer();
            String s = PluginUtilities.getPersistentProperty((IResource)project, (String)mode, (String)"-sp=");
            if (s == null) {
                s = "";
            }
            if (data.sourcePath == null) {
                data.sourcePath = new HashMap();
            }
            data.sourcePath.put(mode, s);
            val.append(PluginUtilities.buildAbsolutePathList((String)s, (IProject)project, null));
            if (data.absoluteSourcePath == null) {
                data.absoluteSourcePath = new HashMap();
            }
            data.absoluteSourcePath.put(mode, val.toString());
        }
        return (String)data.sourcePath.get(mode);
    }

    private static ProjectData getProjectData(IProject project) {
        ProjectData data = (ProjectData)projectDataTable.get(project);
        if (data == null) {
            data = new ProjectData(null);
            projectDataTable.put(project, data);
        }
        return data;
    }

    public static VcobolEditor getActiveVcobolEditor() {
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w == null) {
            return null;
        }
        IWorkbenchPage p = w.getActivePage();
        if (p == null) {
            return null;
        }
        IEditorPart ep = p.getActiveEditor();
        if (!(ep instanceof VcobolEditor)) {
            return null;
        }
        return (VcobolEditor)ep;
    }

    public static String getVcobolClassName(String fn) {
        if (fn == null) {
            return null;
        }
        String className = fn;
        className = fn.toUpperCase();
        int idx = className.lastIndexOf(46);
        if (idx >= 0) {
            className = className.substring(0, idx);
        }
        className = className.replace('-', '_');
        return className;
    }

    public static File getProjectLocation(IProject p) throws CoreException {
        File path = null;
        URI uri = p.getDescription().getLocationURI();
        path = uri != null ? new File(uri.getPath()) : p.getWorkspace().getRoot().getLocation().append("/" + p.getDescription().getName()).toFile();
        return path;
    }

    public static IContainer[] getCopyFolders(IProject project, String mode) throws CoreException {
        String spOpt = PluginUtilities.getPersistentProperty((IResource)project, (String)mode, (String)"-sp=");
        if (spOpt == null) {
            return new IContainer[0];
        }
        StringTokenizer st = new StringTokenizer(spOpt, File.pathSeparator);
        Vector<IContainer> result = new Vector<IContainer>();
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            File f = new File(tk);
            if (f.isAbsolute()) continue;
            result.addElement(PluginUtilities.getFolder((IProject)project, (String)tk));
        }
        IContainer[] Return = new IContainer[result.size()];
        result.toArray(Return);
        return Return;
    }

    public static IContainer getOutputFolder(IProject project, String mode) throws CoreException {
        String odOpt = PluginUtilities.getPersistentProperty((IResource)project, (String)mode, (String)"-od=");
        if (odOpt == null || odOpt.equals("___vcobol.option.false")) {
            return null;
        }
        return PluginUtilities.getFolder((IProject)project, (String)odOpt);
    }

    public static String getAbsolutePath(IProject project, String relPath) {
        if (relPath != null && new File(relPath).isAbsolute()) {
            return relPath;
        }
        if (relPath == null || relPath.length() == 0 || relPath.equals("/")) {
            try {
                return PluginUtilities.getProjectRootDir((IProject)project);
            }
            catch (CoreException e) {
                return relPath;
            }
        }
        IFolder fld = project.getFolder((IPath)new Path(relPath));
        IPath location = fld.getLocation();
        if (location != null) {
            return location.toOSString();
        }
        try {
            return String.valueOf(PluginUtilities.getProjectRootDir((IProject)project)) + "/" + relPath;
        }
        catch (CoreException e) {
            return relPath;
        }
    }

    public static IFolder getResourcesFolder(IProject project) throws CoreException {
        String scr = PluginUtilities.getPersistentProperty((IResource)project, (String)"Default", (String)"resourcesdir");
        if (scr == null) {
            return null;
        }
        IContainer Return = PluginUtilities.getFolder((IProject)project, (String)scr);
        if (Return == null || Return.getType() != 2) {
            return null;
        }
        return (IFolder)Return;
    }

    public static IContainer getSourceFolder(IProject project) throws CoreException {
        return PluginUtilities.getSourceFolder((IProject)project, (String)PluginUtilities.getPersistentProperty((IResource)project, (String)"Default", (String)"sourcedir"));
    }

    public static IFolder getTranslatedFolder(IProject project) throws CoreException {
        Path p = new Path("translated");
        IFolder fld = project.getFolder((IPath)p);
        if (!project.exists((IPath)p)) {
            PluginUtilities.createFolder((IFolder)fld);
        }
        return fld;
    }

    public static IContainer getSourceFolder(IProject project, String srcDir) throws CoreException {
        if (srcDir == null) {
            srcDir = "source";
        }
        return PluginUtilities.getFolder((IProject)project, (String)srcDir);
    }

    public static IContainer getFolder(IProject project, String dir) throws CoreException {
        Object sf = null;
        sf = dir.length() == 0 || dir.equals("/") ? project : project.getFolder(dir);
        return sf;
    }

    public static String getProjectRootDir(IProject p) throws CoreException {
        return PluginUtilities.getProjectLocation((IProject)p).getAbsolutePath();
    }

    public static StringBuffer buildAbsolutePathList(String path, IProject project, String projDir) {
        StringBuffer Return = new StringBuffer();
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        int i = 0;
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            if (i > 0) {
                Return.append(File.pathSeparator);
            }
            Return.append(PluginUtilities.getAbsolutePath((IProject)project, (String)tk));
            ++i;
        }
        return Return;
    }

    public static String makeRelative(String absolutePath, String dir) {
        dir = dir.replace('\\', '/');
        if ((absolutePath = absolutePath.replace('\\', '/')).startsWith(dir)) {
            return absolutePath.substring(dir.length());
        }
        return absolutePath;
    }

    public static String makeRelative(String absolutePath, IProject project) {
        File projectDir = project.getLocation().toFile();
        File file = new File(absolutePath);
        StringBuffer relativePath = new StringBuffer(file.getName());
        File parent = file.getParentFile();
        while (parent != null && !parent.equals(projectDir)) {
            relativePath.insert(0, String.valueOf(parent.getName()) + File.separator);
            parent = parent.getParentFile();
        }
        if (parent != null) {
            return relativePath.toString();
        }
        return absolutePath;
    }

    public static boolean isAnsiFormat(IResource resource, String mode) {
        return PluginUtilities.getFormat((IResource)resource, (String)mode) == 1;
    }

    public static boolean isTerminalFormat(IResource resource, String mode) {
        return PluginUtilities.getFormat((IResource)resource, (String)mode) == 2;
    }

    public static boolean isFreeFormat(IResource resource, String mode) {
        return PluginUtilities.getFormat((IResource)resource, (String)mode) == 3;
    }

    public static int getFormat(IResource resource, String mode) {
        int Return = 0;
        int i = 0;
        while (i < SOURCE_FORMAT_OPTIONS.length) {
            if (PluginUtilities.isFormat((IResource)resource, (String)mode, (String)SOURCE_FORMAT_OPTIONS[i])) {
                Return = i + 1;
                break;
            }
            ++i;
        }
        if (Return == 0 && !(resource instanceof IProject) && resource.getProject() != null) {
            Return = PluginUtilities.getFormat((IResource)resource.getProject(), (String)mode);
        }
        return Return;
    }

    public static String getFormatOption(int format) {
        if (format > 0 && format <= SOURCE_FORMAT_OPTIONS.length) {
            return SOURCE_FORMAT_OPTIONS[format - 1];
        }
        return null;
    }

    public static String getFormatOption(IResource resource, String mode) {
        String Return = null;
        int i = 0;
        while (i < SOURCE_FORMAT_OPTIONS.length) {
            if (PluginUtilities.isFormat((IResource)resource, (String)mode, (String)SOURCE_FORMAT_OPTIONS[i])) {
                Return = SOURCE_FORMAT_OPTIONS[i];
                break;
            }
            ++i;
        }
        if (Return == null && !(resource instanceof IProject) && resource.getProject() != null) {
            Return = PluginUtilities.getFormatOption((IResource)resource.getProject(), (String)mode);
        }
        return Return;
    }

    private static boolean isFormat(IResource resource, String mode, String key) {
        String v = PluginUtilities.getPersistentProperty((IResource)resource, (String)mode, (String)key);
        return v != null && v.equals("___vcobol.option.true");
    }

    public static String toString(Method m, StringBuffer declClass, StringBuffer pattern) {
        StringBuffer Return = new StringBuffer();
        if (pattern != null) {
            pattern.append(m.getName());
        }
        Return.append(String.valueOf(m.getName()) + "( ");
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (parameterTypes.length > 0 && pattern != null) {
            pattern.append(" ( ");
        }
        int j = 0;
        while (j < parameterTypes.length) {
            pattern.append("${");
            Return.append(PluginUtilities.toString(parameterTypes[j], (StringBuffer)pattern));
            pattern.append("_").append(j).append("}");
            if (j < parameterTypes.length - 1) {
                Return.append(", ");
                if (pattern != null) {
                    pattern.append(" ");
                }
            }
            ++j;
        }
        Return.append(" ) ");
        if (parameterTypes.length > 0 && pattern != null) {
            pattern.append(" )");
        }
        Return.append(PluginUtilities.toString(m.getReturnType(), null));
        if (declClass != null) {
            declClass.append(PluginUtilities.toString(m.getDeclaringClass(), null));
        }
        return Return.toString();
    }

    public static String toString(Constructor c, StringBuffer declClass, StringBuffer pattern) {
        StringBuffer Return = new StringBuffer();
        if (pattern != null) {
            pattern.append("new");
        }
        Return.append("new( ");
        Class<?>[] parameterTypes = c.getParameterTypes();
        if (parameterTypes.length > 0 && pattern != null) {
            pattern.append(" ( ");
        }
        int j = 0;
        while (j < parameterTypes.length) {
            pattern.append("${");
            Return.append(PluginUtilities.toString(parameterTypes[j], (StringBuffer)pattern));
            pattern.append("_").append(j).append("}");
            if (j < parameterTypes.length - 1) {
                Return.append(", ");
                if (pattern != null) {
                    pattern.append(" ");
                }
            }
            ++j;
        }
        Return.append(" ) ");
        if (parameterTypes.length > 0 && pattern != null) {
            pattern.append(" )");
        }
        if (declClass != null) {
            declClass.append(PluginUtilities.toString(c.getDeclaringClass(), null));
        }
        return Return.toString();
    }

    public static String toString(Field f, StringBuffer declClass) {
        StringBuffer Return = new StringBuffer();
        Return.append(f.getName()).append(" ");
        Return.append(PluginUtilities.toString(f.getType(), null));
        if (declClass != null) {
            declClass.append(PluginUtilities.toString(f.getDeclaringClass(), null));
        }
        return Return.toString();
    }

    public static String toString(Class type, StringBuffer cobolCode) {
        StringBuffer Return = new StringBuffer();
        int dimensions = 0;
        while (type.isArray()) {
            type = type.getComponentType();
            ++dimensions;
        }
        if (type == Void.TYPE) {
            Return.append("void");
        } else if (type == Boolean.TYPE) {
            Return.append("boolean");
        } else if (type == Byte.TYPE) {
            Return.append("byte");
        } else if (type == Short.TYPE) {
            Return.append("short");
        } else if (type == Integer.TYPE) {
            Return.append("int");
        } else if (type == Long.TYPE) {
            Return.append("long");
        } else if (type == Float.TYPE) {
            Return.append("float");
        } else if (type == Double.TYPE) {
            Return.append("double");
        } else if (type == Character.TYPE) {
            Return.append("char");
        } else {
            Return.append(type.getName().replace('$', '.'));
        }
        if (cobolCode != null) {
            int idx = Return.lastIndexOf(".");
            if (idx >= 0) {
                cobolCode.append("J" + Return.substring(idx + 1, Return.length()));
            } else {
                cobolCode.append("J" + Return);
            }
        }
        if (dimensions > 0) {
            int i = 0;
            while (i < dimensions) {
                Return.append("[]");
                if (cobolCode != null) {
                    cobolCode.append("_a");
                }
                ++i;
            }
        }
        return Return.toString();
    }

    public static void log(String message, Throwable exception) {
        ConsolePlugin.log((IStatus)ConsolePlugin.newErrorStatus((String)message, (Throwable)exception));
    }

    public static void log(Throwable exception) {
        PluginUtilities.log((String)exception.toString(), (Throwable)exception);
    }

    public static void log(String message) {
        PluginUtilities.log((String)message, null);
    }

    public static void logError(String message) {
        PluginUtilities.logMessage((String)message, (int)1);
    }

    public static void logMessage(String message, int iconType) {
        if (message == null) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public static VcobolNavigator findVcobolNavigator() {
        VcobolNavigator[] result = new VcobolNavigator[1];
        new /* Unavailable Anonymous Inner Class!! */.start();
        return result[0];
    }

    public static boolean isCopyFolder(IContainer fld) {
        if (fld.getProject() == null) {
            return false;
        }
        String spOpt = PluginUtilities.getPersistentProperty((IResource)fld.getProject(), (String)PluginUtilities.getCurrentSettingMode((IResource)fld.getProject()), (String)"-sp=");
        if (spOpt == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(spOpt, File.pathSeparator);
        while (st.hasMoreTokens()) {
            try {
                if (!PluginUtilities.getFolder((IProject)fld.getProject(), (String)st.nextToken()).equals((Object)fld)) continue;
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isOutputFolder(IContainer fld) {
        return PluginUtilities.isFolder((IContainer)fld, (String)PluginUtilities.getCurrentSettingMode((IResource)fld.getProject()), (String)"-od=");
    }

    public static boolean isListFolder(IContainer fld) {
        return PluginUtilities.isFolder((IContainer)fld, (String)PluginUtilities.getCurrentSettingMode((IResource)fld.getProject()), (String)"-lo=");
    }

    public static boolean isErrFolder(IContainer fld) {
        return PluginUtilities.isFolder((IContainer)fld, (String)PluginUtilities.getCurrentSettingMode((IResource)fld.getProject()), (String)"-eo=");
    }

    public static boolean isEfdFolder(IContainer fld) {
        return PluginUtilities.isFolder((IContainer)fld, (String)PluginUtilities.getCurrentSettingMode((IResource)fld.getProject()), (String)"-efo=");
    }

    private static boolean isFolder(IContainer fld, String mode, String optName) {
        if (fld.getProject() == null) {
            return false;
        }
        String opt = PluginUtilities.getPersistentProperty((IResource)fld.getProject(), (String)mode, (String)optName);
        if (opt == null) {
            return false;
        }
        try {
            return PluginUtilities.getFolder((IProject)fld.getProject(), (String)opt).equals((Object)fld);
        }
        catch (CoreException ex) {
            return false;
        }
    }

    public static boolean isSourceFolder(IContainer fld) {
        block3: {
            try {
                if (fld.getProject() != null) break block3;
                return false;
            }
            catch (CoreException ex) {
                return false;
            }
        }
        return PluginUtilities.getSourceFolder((IProject)fld.getProject()).equals((Object)fld);
    }

    public static boolean isInSourceFolder(IFile file) {
        return PluginUtilities.isInSourceFolder((IContainer)file.getParent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInSourceFolder(IContainer fld) {
        try {
            IProject prj = fld.getProject();
            if (prj == null || prj.getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") == null) {
                return false;
            }
            IContainer sf = PluginUtilities.getSourceFolder((IProject)prj);
            IContainer c = fld;
            while (true) {
                if (c instanceof IWorkspaceRoot) {
                    return false;
                }
                if (c.equals((Object)sf)) {
                    return true;
                }
                c = c.getParent();
            }
        }
        catch (CoreException ex) {
            return false;
        }
    }

    public static boolean isTextFile(IFile file) {
        try {
            IEditorDescriptor eDesc = IDE.getEditorDescriptor((IFile)file);
            return eDesc == null || eDesc.getId().equals(VcobolEditor.ID) || eDesc.getId().equals("org.eclipse.ui.DefaultTextEditor");
        }
        catch (CoreException ex) {
            return false;
        }
    }

    public static boolean isSourceFile(IFile file) {
        return PluginUtilities.isInSourceFolder((IFile)file) && PluginUtilities.isTextFile((IFile)file);
    }

    public static boolean isCopyFile(IFile file, String ext) {
        block10: {
            IProject prj;
            block9: {
                block8: {
                    if (ext == null || !ext.equals("def") && !ext.equals("cpy") && !ext.equals("evt") && !ext.equals("prd")) break block8;
                    return true;
                }
                prj = file.getProject();
                if (prj != null && prj.getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") != null) break block9;
                return false;
            }
            try {
                IContainer[] cpf = PluginUtilities.getCopyFolders((IProject)prj, (String)PluginUtilities.getCurrentSettingMode((IResource)prj));
                boolean ok = false;
                int i = 0;
                while (!ok && i < cpf.length) {
                    IContainer c = file.getParent();
                    while (!ok && !(c instanceof IWorkspaceRoot)) {
                        if (c.equals((Object)cpf[i])) {
                            ok = true;
                        }
                        c = c.getParent();
                    }
                    ++i;
                }
                if (ok) break block10;
                return false;
            }
            catch (CoreException ex) {
                return false;
            }
        }
        IEditorDescriptor eDesc = IDE.getEditorDescriptor((IFile)file);
        return eDesc == null || eDesc.getId().equals(VcobolEditor.ID) || eDesc.getId().equals("org.eclipse.ui.DefaultTextEditor");
    }

    private static void handleExecutionException(ExecutionException eex) {
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static boolean createFile(IFile file, InputStream contents) {
        ByteArrayInputStream bais = null;
        try {
            CreateFileOperation op;
            if (contents == null) {
                bais = new ByteArrayInputStream(new byte[0]);
                op = new CreateFileOperation(file, (InputStream)bais);
            } else {
                op = new CreateFileOperation(file, contents);
            }
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, null, null);
            return true;
        }
        catch (ExecutionException ex) {
            PluginUtilities.handleExecutionException((ExecutionException)ex);
            return false;
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean createLinkFile(IFile file, URI location) {
        ByteArrayInputStream bais = null;
        try {
            CreateLinkFileOperation op = new CreateLinkFileOperation(file, location, "com.vcobol.plugins.editor.VcobolEditor");
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, null, null);
            return true;
        }
        catch (ExecutionException ex) {
            PluginUtilities.handleExecutionException((ExecutionException)ex);
            return false;
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean modifyFile(IFile file, InputStream contents, boolean keepHistory) {
        ByteArrayInputStream bais = null;
        try {
            ModifyFileOperation op;
            if (contents == null) {
                bais = new ByteArrayInputStream(new byte[0]);
                op = new ModifyFileOperation(file, (InputStream)bais, keepHistory);
            } else {
                op = new ModifyFileOperation(file, contents, keepHistory);
            }
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, null, null);
            return true;
        }
        catch (ExecutionException ex) {
            PluginUtilities.handleExecutionException((ExecutionException)ex);
            return false;
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean deleteFile(IFile file, boolean keepHistory) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)new DeleteFileOperation(file, keepHistory), null, null);
            return true;
        }
        catch (ExecutionException ex) {
            PluginUtilities.handleExecutionException((ExecutionException)ex);
            return false;
        }
    }

    public static boolean deleteFolder(IFolder folder) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)new DeleteFolderOperation(folder), null, null);
            return true;
        }
        catch (ExecutionException ex) {
            PluginUtilities.handleExecutionException((ExecutionException)ex);
            return false;
        }
    }

    public static boolean createFolder(IFolder folder) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)new CreateFolderOperation(folder), null, null);
            return true;
        }
        catch (ExecutionException ex) {
            PluginUtilities.handleExecutionException((ExecutionException)ex);
            return false;
        }
    }

    public static IFile findCopyFile(String name, String mode, IProject project) {
        String spOpt = PluginUtilities.getPersistentProperty((IResource)project, (String)mode, (String)"-sp=");
        if (spOpt != null) {
            StringTokenizer stn = new StringTokenizer(spOpt, File.pathSeparator);
            while (stn.hasMoreTokens()) {
                IResource res = PluginUtilities.findMember((IContainer)project, (IPath)new Path(stn.nextToken().replace('\\', '/')));
                if (!(res instanceof IContainer)) continue;
                return PluginUtilities.findRecur((IContainer)((IContainer)res), (Path)new Path(name));
            }
        }
        return null;
    }

    private static IFile findRecur(IContainer cnt, Path name) {
        IResource Return = PluginUtilities.findMember((IContainer)cnt, (IPath)name);
        if (Return instanceof IFile) {
            return (IFile)Return;
        }
        try {
            IResource[] members = cnt.members();
            int i = 0;
            while (i < members.length) {
                if (members[i] instanceof IFolder && (Return = PluginUtilities.findRecur((IContainer)((IFolder)members[i]), (Path)name)) != null) {
                    return (IFile)Return;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static IResource findMember(IContainer cnt, IPath path) {
        return PluginUtilities.findMember((IContainer)cnt, (IPath)path, (boolean)Platform.getOS().equals("win32"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IResource findMember(IContainer cnt, IPath path, boolean ignoreCase) {
        try {
            String[] segments = path.segments();
            int i = 0;
            while (true) {
                if (i >= segments.length) {
                    return null;
                }
                IResource[] members = cnt.members();
                boolean found = false;
                int j = 0;
                while (true) {
                    if (j >= members.length || found) {
                        if (found) break;
                        return null;
                    }
                    String s1 = segments[i];
                    if (ignoreCase) {
                        s1 = s1.toLowerCase();
                    }
                    String s2 = members[j].getName();
                    if (ignoreCase) {
                        s2 = s2.toLowerCase();
                    }
                    if (s1.equals(s2)) {
                        found = true;
                        if (i == segments.length - 1) {
                            return members[j];
                        }
                        cnt = (IContainer)members[j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static String findVariableName(String str, int cp, boolean getHead) {
        if (cp < 0 || cp >= str.length()) {
            return null;
        }
        String head = "";
        String tail = "";
        String delimString = " =():\".,";
        char[] delims = delimString.toCharArray();
        StringTokenizer st = new StringTokenizer(str.substring(cp), delimString, true);
        if (st.hasMoreTokens()) {
            String tk = st.nextToken();
            boolean ok = true;
            int i = 0;
            while (i < delims.length && ok) {
                ok &= delims[i] != tk.charAt(0);
                ++i;
            }
            if (ok) {
                tail = tk;
            }
            while (st.hasMoreTokens() && (tk = st.nextToken()).equals(" ")) {
                tail = String.valueOf(tail) + tk;
            }
            if (tk.equalsIgnoreCase("of") || tk.equalsIgnoreCase("in")) {
                tail = String.valueOf(tail) + tk;
                while (st.hasMoreTokens() && (tk = st.nextToken()).equals(" ")) {
                    tail = String.valueOf(tail) + tk;
                }
                String of = PluginUtilities.findVariableName((String)str, (int)(cp + tail.length()), (boolean)false);
                if (of != null) {
                    tail = String.valueOf(tail) + of;
                }
            } else if (tk.equals("(")) {
                int openPar = 1;
                tail = String.valueOf(tail) + tk;
                while (st.hasMoreTokens()) {
                    tk = st.nextToken();
                    tail = String.valueOf(tail) + tk;
                    if (tk.equals("(")) {
                        ++openPar;
                    }
                    if (!tk.equals(")")) continue;
                    if (openPar <= 1) break;
                    --openPar;
                }
            }
        }
        if (getHead) {
            delimString = " =(:\",";
            delims = delimString.toCharArray();
            st = new StringTokenizer(str.substring(0, cp), delimString, true);
            int ct = st.countTokens();
            if (ct > 0) {
                int i = 0;
                while (i < ct - 1) {
                    st.nextToken();
                    ++i;
                }
                String tk = st.nextToken();
                boolean ok = true;
                int i2 = 0;
                while (i2 < delims.length && ok) {
                    ok &= delims[i2] != tk.charAt(0);
                    ++i2;
                }
                if (ok) {
                    head = tk;
                }
            }
        }
        return String.valueOf(head) + tail;
    }

    public static String getSuggestedFileName(IContainer parent, String prefix, String suffix) {
        String Return;
        if (parent == null) {
            return String.valueOf(prefix) + "1" + suffix;
        }
        int idx = 1;
        while (parent.getFile((IPath)new Path(Return = String.valueOf(prefix) + Integer.toString(idx) + suffix)).exists()) {
            ++idx;
        }
        return Return;
    }

    public static boolean getBooleanValue(String key, String mode, IPreferenceStore store) {
        return PluginUtilities.getBooleanValue((String)("vcobol.newproject." + mode + "." + key), (IPreferenceStore)store);
    }

    public static boolean getBooleanValue(String key, IPreferenceStore store) {
        if (store.contains(key)) {
            return store.getBoolean(key);
        }
        return store.getDefaultBoolean(key);
    }

    public static String getDefaultString(String key, String mode, IPreferenceStore store) {
        return store.getDefaultString("vcobol.newproject." + mode + "." + key);
    }

    public static boolean getDefaultBoolean(String key, String mode, IPreferenceStore store) {
        return store.getDefaultBoolean("vcobol.newproject." + mode + "." + key);
    }

    public static String getStringValue(String key, IPreferenceStore store) {
        if (store.contains(key)) {
            return store.getString(key);
        }
        return store.getDefaultString(key);
    }

    public static String getStringValue(String key, String mode, IPreferenceStore store) {
        return PluginUtilities.getStringValue((String)("vcobol.newproject." + mode + "." + key), (IPreferenceStore)store);
    }

    public static void setStringValue(String key, String mode, String value, IPreferenceStore store) {
        store.setValue("vcobol.newproject." + mode + "." + key, value);
    }

    public static boolean validatePortNumber(String portNumber) {
        boolean ok = false;
        if (portNumber != null) {
            try {
                int p = Integer.parseInt(portNumber);
                ok = p >= 1 && p <= 65535;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ok;
    }

    public static boolean validateHostName(String hostName) {
        if (hostName == null || hostName.length() > 63) {
            return false;
        }
        return hostName.matches("(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum}))((\\.)(((\\p{Alnum})([-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})))*") && hostName.matches("(.)*((\\p{Alpha})|[-])(.)*") || PluginUtilities.validateIPAddress((String)hostName);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean validateIPAddress(String ipAddress) {
        stn = new StringTokenizer(ipAddress, ".");
        if (stn.countTokens() == 4) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                i = Integer.parseInt(stn.nextToken());
                if (i >= 0 && i <= 255) continue;
                return false;
            }
            catch (NumberFormatException ex) {
                return false;
            }
lbl10:
            // 2 sources

            ** while (stn.hasMoreTokens())
        }
lbl11:
        // 1 sources

        return true;
    }

    private static Enumeration setProperties(String propertyFile) {
        Properties props;
        block15: {
            props = new Properties();
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(propertyFile);
                    props.load(in);
                }
                catch (IOException iOException) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String k = (String)en.nextElement();
            Config.setProperty((String)(k.startsWith("vcobol") ? k.substring(6) : k), (String)props.getProperty(k));
        }
        return props.propertyNames();
    }

    private static void unsetProperties(Enumeration propertyNames) {
        while (propertyNames.hasMoreElements()) {
            Config.unsetProperty((String)((String)propertyNames.nextElement()));
        }
    }

    public static String hexToAscii(byte[] b) {
        StringBuffer Return = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i]).toUpperCase();
            if (hex.length() == 1) {
                hex = "0" + hex;
            } else if (hex.length() > 2) {
                hex = hex.substring(hex.length() - 2);
            }
            Return.append(hex);
            ++i;
        }
        return Return.toString();
    }

    public static byte[] asciiToHex(String s) {
        if (s.length() % 2 == 1) {
            s = "0" + s;
        }
        byte[] Return = new byte[s.length() / 2];
        int i = 0;
        int j = 0;
        while (i < s.length()) {
            Return[j] = (byte)Integer.parseInt(s.substring(i, i + 2), 16);
            i += 2;
            ++j;
        }
        return Return;
    }

    public static VcobolEditor findVcobolEditorForInput(IFile file) {
        if (file == null) {
            return null;
        }
        VcobolEditor[] Return = new VcobolEditor[1];
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return Return[0];
    }
}

