/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.util;

import com.iscobol.compiler.FileFinder;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFileFinder
implements FileFinder {
    private IResource resource;
    private String spOption;
    private String ceOption;
    private Map<File, IFile> fileMap = new HashMap();

    public ProjectFileFinder(IResource res, String spOpt, String ceOpt) {
        this.resource = res;
        this.spOption = spOpt;
        this.ceOption = ceOpt;
    }

    public File findFile(String name) {
        String[] extList;
        if (this.resource.getProject() == null) {
            return null;
        }
        if (this.spOption == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(this.spOption, File.pathSeparator);
        String[] pthList = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            pthList[i++] = st.nextToken();
        }
        if (this.ceOption == null) {
            extList = new String[]{""};
        } else {
            st = new StringTokenizer(this.ceOption, File.pathSeparator);
            extList = new String[st.countTokens() + 1];
            extList[0] = "";
            i = 1;
            while (st.hasMoreTokens()) {
                extList[i++] = "." + st.nextToken();
            }
        }
        i = 0;
        while (i < pthList.length) {
            File tmp = new File(pthList[i]);
            if (!tmp.isAbsolute()) {
                int j = 0;
                while (j < extList.length) {
                    Path path = new Path(String.valueOf(pthList[i]) + "/" + name + extList[j]);
                    IResource res = PluginUtilities.findMember((IContainer)this.resource.getProject(), (IPath)path);
                    if (res instanceof IFile) {
                        File Return = res.getLocation().toFile();
                        this.fileMap.put(Return, (IFile)res);
                        return Return;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String getSpOption() {
        return this.spOption;
    }

    public String getCeOption() {
        return this.ceOption;
    }

    public Map<File, IFile> getFileMap() {
        return this.fileMap;
    }
}

