/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.util;

import com.vcobol.plugins.editor.util.SettingList;
import com.vcobol.plugins.editor.util.SettingMode;
import java.beans.DefaultPersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class ProjectSettingList
extends SettingList {
    private Hashtable fileSettingList = new Hashtable();

    public ProjectSettingList(String name) {
        super(name);
        this.setCurrentMode("Debug");
    }

    public ProjectSettingList() {
        super(null);
    }

    public void setCurrentMode(String currentMode) {
        this.currentMode = currentMode;
        if (this.currentMode == null) {
            this.currentMode = "Debug";
        }
    }

    public void setFileSettings(Hashtable fsl) {
        this.fileSettingList = fsl;
    }

    public Hashtable getFileSettings() {
        return this.fileSettingList;
    }

    public SettingList getFileSettingList(String n) {
        return (SettingList)this.fileSettingList.get(n);
    }

    public void putFileSettingList(SettingList fsl) {
        this.fileSettingList.put(fsl.getName(), fsl);
    }

    public void removeFileSettingList(String n) {
        this.fileSettingList.remove(n);
    }

    public void removeMode(String mode) {
        this.modes.remove(mode);
        if (mode.equals(this.currentMode)) {
            this.currentMode = "Debug";
        }
    }

    public void save(OutputStream out) {
        XMLEncoder enc = new XMLEncoder(out);
        DefaultPersistenceDelegate settingdel = new DefaultPersistenceDelegate(new String[]{"name"});
        enc.setPersistenceDelegate(ProjectSettingList.class, settingdel);
        enc.setPersistenceDelegate(SettingList.class, settingdel);
        enc.setPersistenceDelegate(SettingMode.class, settingdel);
        enc.writeObject(this);
        enc.close();
    }

    public void load(InputStream in) {
        XMLDecoder dec = new XMLDecoder(in);
        ProjectSettingList psl = (ProjectSettingList)dec.readObject();
        this.setName(psl.getName());
        this.setCurrentMode(psl.getCurrentMode());
        this.setModes(psl.getModes());
        this.setFileSettings(psl.getFileSettings());
        dec.close();
    }
}

