/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.util;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;

public class VcobolResourceDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "com.vcobol.plugins.editor.resourcedecorator";

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        IResource resource = this.getResource(element);
        if (resource != null) {
            try {
                IMarker[] problemMarkers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                if (problemMarkers.length > 0) {
                    int maxSeverity = problemMarkers[0].getAttribute("severity", 0);
                    int i = 1;
                    while (i < problemMarkers.length) {
                        int severity = problemMarkers[i].getAttribute("severity", 0);
                        if (severity > maxSeverity) {
                            maxSeverity = severity;
                        }
                        ++i;
                    }
                    if (maxSeverity > 0) {
                        switch (maxSeverity) {
                            case 1: {
                                decoration.addOverlay(VcobolEditorPlugin.getDefault().getImageProvider().getDescriptor("/warning_overlay.gif"), 2);
                                break;
                            }
                            case 2: {
                                decoration.addOverlay(VcobolEditorPlugin.getDefault().getImageProvider().getDescriptor("/error_overlay.gif"), 2);
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (PluginUtilities.hasSpecificSettings((IResource)resource)) {
                decoration.addPrefix("*");
            }
        }
    }

    protected IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            IResource Return = (IResource)((IAdaptable)object).getAdapter(IProject.class);
            if (Return != null) {
                return Return;
            }
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }
}

