/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.wizards;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class ClasspathPage
extends PropertyPage
implements IWizardPage {
    public static final String rcsid = "$Id: ClasspathPage.java,v 1.6 2008/12/12 11:16:04 gianni Exp $";
    private IWizard wizard;
    private IWizardPage prevPage;
    private IWizardPage nextPage;
    private Tree tree;

    public ClasspathPage() {
        this.setTitle(VresourceBundle.getString((String)"class_path_title"));
        this.noDefaultAndApplyButton();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public String getName() {
        return "";
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(IWizard w) {
        this.wizard = w;
    }

    public void setNextPage(IWizardPage page) {
        this.nextPage = page;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setPreviousPage(IWizardPage page) {
        this.prevPage = page;
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public boolean isPageComplete() {
        return true;
    }

    private boolean isJar(String path) {
        return path.endsWith(".jar") || path.endsWith(".zip");
    }

    public Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        comp.setLayout((Layout)gl);
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        lbl.setText(VresourceBundle.getString((String)"jar_class_lbl"));
        lbl.setLayoutData((Object)gd);
        this.tree = new Tree(comp, 2048);
        gd = new GridData(1808);
        gd.verticalSpan = 3;
        this.tree.setLayoutData((Object)gd);
        String cp = null;
        if (this.getElement() != null) {
            cp = PluginUtilities.getPersistentProperty((IResource)((IResource)this.getElement()), (String)"Default", (String)"vcobol.classpath");
        }
        if (cp != null) {
            StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                TreeItem item = new TreeItem(this.tree, 0);
                item.setText(tk);
                if (this.isJar(tk)) {
                    item.setImage(VcobolEditorPlugin.getDefault().getImageProvider().getImage("/jar.gif"));
                    continue;
                }
                item.setImage(VcobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
            }
        }
        Button addJars = new Button(comp, 8);
        addJars.setText(VresourceBundle.getString((String)"add_jar_lbl"));
        gd = new GridData(2);
        addJars.setLayoutData((Object)gd);
        addJars.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button addCf = new Button(comp, 8);
        addCf.setText(VresourceBundle.getString((String)"add_class_fld_lbl"));
        gd = new GridData(2);
        addCf.setLayoutData((Object)gd);
        addCf.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button remove = new Button(comp, 8);
        remove.setText(VresourceBundle.getString((String)"remove_lbl"));
        gd = new GridData(2);
        remove.setLayoutData((Object)gd);
        remove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return comp;
    }

    public boolean isValid() {
        return true;
    }

    public boolean performOk() {
        return this.performOk((IProject)this.getElement());
    }

    public boolean performOk(IProject project) {
        String cp = this.getClasspath();
        if (cp != null && project != null) {
            PluginUtilities.setPersistentProperty((IResource)project, (String)"Default", (String)"vcobol.classpath", (String)cp);
            PluginUtilities.saveProjectOptions((IProject)project);
        }
        return true;
    }

    private String getClasspath() {
        if (this.tree.isDisposed()) {
            return null;
        }
        TreeItem[] items = this.tree.getItems();
        if (items != null && items.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(items[0].getText());
            int i = 1;
            while (i < items.length) {
                buf.append(File.pathSeparator).append(items[i].getText());
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    static /* synthetic */ Tree access$0(ClasspathPage classpathPage) {
        return classpathPage.tree;
    }
}

