/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.wizards;

import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.vcobol.plugins.editor.util.SettingList;
import com.vcobol.plugins.editor.views.VcobolNavigator;
import com.vcobol.plugins.editor.wizards.ResourceSettingsPanel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class FileSettingsPage
extends PropertyPage
implements IWizardPage {
    private ResourceSettingsPanel panel;
    private boolean valid = true;
    private IWizard wizard;
    private IWizardPage prevPage;
    private IWizardPage nextPage;
    private SettingList fileSettings;
    private boolean useFileOpts;

    public boolean canFlipToNextPage() {
        return false;
    }

    public String getName() {
        return "";
    }

    public boolean isPageComplete() {
        return this.valid;
    }

    public Control createContents(Composite parent) {
        String s;
        this.setTitle("File Settings");
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        composite.setLayout((Layout)gl);
        IFile file = (IFile)this.getElement();
        this.panel = new ResourceSettingsPanel(composite, 0, (IResource)file, false);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.panel.setLayoutData((Object)gd);
        this.panel.setPreferencePage((PreferencePage)this);
        this.useFileOpts = file != null ? (s = PluginUtilities.getPersistentProperty((IResource)file.getProject(), (String)"Default", (String)"vcobol.checkfileopt")) != null && !s.equals("___vcobol.option.false") : true;
        if (!this.useFileOpts) {
            this.panel.disableAll();
            this.setMessage(VresourceBundle.getString((String)"specific_file_opts_ignored"), 2);
        }
        return composite;
    }

    public void setValid(boolean v) {
        super.setValid(v);
        this.valid = v;
    }

    public boolean isValid() {
        if (this.panel == null) {
            return true;
        }
        String errorMessage = null;
        if (errorMessage == null) {
            errorMessage = this.panel.validate();
        }
        this.setErrorMessage(errorMessage);
        return errorMessage == null;
    }

    public boolean performOk() {
        if (this.useFileOpts) {
            return this.performOk((IResource)this.getElement());
        }
        return super.performOk();
    }

    public boolean performCancel() {
        if (this.useFileOpts && this.panel.isRestoredDefaults() && this.fileSettings != null) {
            PluginUtilities.putSettingList((SettingList)this.fileSettings, (IProject)((IFile)this.getElement()).getProject());
        }
        return super.performCancel();
    }

    public boolean performOk(IResource res) {
        if (!this.panel.isRestoredDefaults()) {
            this.panel.setOptionsAsPersistent(res, false);
        }
        PluginUtilities.saveProjectOptions((IProject)res.getProject());
        this.panel.setRestoredDefaults(false);
        VcobolNavigator isNav = PluginUtilities.findVcobolNavigator();
        if (isNav != null) {
            isNav.refresh(res);
        }
        return true;
    }

    protected void performDefaults() {
        if (this.useFileOpts) {
            IFile file = (IFile)this.getElement();
            this.fileSettings = PluginUtilities.getSettingList((IResource)file, (boolean)false);
            PluginUtilities.removePersistentProperties((IFile)file);
            this.panel.restoreProjectDefaults();
            this.panel.setRestoredDefaults(true);
        }
    }

    public ResourceSettingsPanel getPanel() {
        return this.panel;
    }

    public void setNextPage(IWizardPage page) {
        this.nextPage = page;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public void setPreviousPage(IWizardPage page) {
        this.prevPage = page;
    }

    public void setWizard(IWizard newWizard) {
        this.wizard = newWizard;
    }
}

