/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.wizards;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewLinkedFilesPage
extends WizardPage {
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private Tree dirTree;
    private TreeItem dirTreeRootItem;
    private Tree fileTree;
    private Tree destTree;
    private TreeItem lastFileItem;
    private TreeItem lastDirItem;
    private TreeEditor fileTreeEditor;
    private Button selectAll;
    private Button deselectAll;
    private Button filterTypes;
    private Text fromDir;
    protected IContainer parentFolder;
    protected String[] fileNames;
    protected File[] files;
    private static final int YES = 0;
    private static final int YES_ALL = 1;
    private static final int NO = 2;
    private static final int NO_ALL = 3;
    private boolean existsProjects = false;
    private int overwriteCode = 2;
    private String[] lastExtensions;
    private String lastOtherExtensions;
    private FileFilter filter = new /* Unavailable Anonymous Inner Class!! */;

    public NewLinkedFilesPage(String pageName) {
        super(pageName);
    }

    public NewLinkedFilesPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected String getLastLinkDirectory() {
        return VcobolEditorPlugin.getDefault().getPreferenceStore().getString("vcobol.LinkDirectory");
    }

    protected void setLastLinkDirectory(String dir) {
        VcobolEditorPlugin.getDefault().getPreferenceStore().setValue("vcobol.LinkDirectory", dir);
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    private boolean isIscobolProject(IProject project) {
        try {
            return project.getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void createControl(Composite parent) {
        String lastDirectory;
        Object obj;
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        composite.setLayout((Layout)gl);
        Label lbl = new Label(composite, 0);
        lbl.setText(VresourceBundle.getString((String)"select_dest_folder_lbl"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        lbl.setLayoutData((Object)gd);
        this.destTree = new Tree(composite, 0x10000800);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 180;
        this.destTree.setLayoutData((Object)gd);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        this.destTree.addListener(36, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        if (projects != null) {
            this.destTree.setItemCount(projects.length);
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen() && this.isIscobolProject(projects[i])) {
                    this.existsProjects = true;
                    TreeItem item = new TreeItem(this.destTree, 0);
                    item.setImage(VcobolEditorPlugin.getDefault().getImageProvider().getImage("/prj.gif"));
                    item.setText(projects[i].getName());
                    item.setData((Object)projects[i]);
                }
                ++i;
            }
        }
        this.destTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        lbl = new Label(composite, 0);
        lbl.setText(VresourceBundle.getString((String)"from_dir_lbl"));
        this.fromDir = new Text(composite, 2048);
        this.fromDir.addListener(14, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.fromDir.addTraverseListener((TraverseListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData(768);
        this.fromDir.setLayoutData((Object)gd);
        Button browse = new Button(composite, 8);
        browse.setText(VresourceBundle.getString((String)"browse_lbl"));
        browse.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite treePanel = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        treePanel.setLayoutData((Object)gd);
        gl = new GridLayout();
        gl.numColumns = 2;
        treePanel.setLayout((Layout)gl);
        lbl = new Label(treePanel, 0);
        lbl = new Label(treePanel, 0);
        lbl.setText("(" + VresourceBundle.getString((String)"rename_help_msg") + ")");
        gd = new GridData();
        gd.horizontalIndent = 10;
        lbl.setLayoutData((Object)gd);
        this.dirTree = new Tree(treePanel, 268437508);
        gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 300;
        this.dirTree.setLayoutData((Object)gd);
        this.dirTree.addListener(36, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.dirTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree = new Tree(treePanel, 2084);
        this.fileTree.setToolTipText(VresourceBundle.getString((String)"rename_help_msg"));
        this.fileTreeEditor = new TreeEditor(this.fileTree);
        this.fileTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 300;
        gd.horizontalIndent = 10;
        this.fileTree.setLayoutData((Object)gd);
        Composite buttons = new Composite(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 3;
        buttons.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalSpan = 3;
        buttons.setLayoutData((Object)gd);
        this.filterTypes = new Button(buttons, 8);
        this.filterTypes.setText(VresourceBundle.getString((String)"filter_types_lbl"));
        this.filterTypes.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.selectAll = new Button(buttons, 8);
        this.selectAll.setText(VresourceBundle.getString((String)"select_all_lbl"));
        this.selectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deselectAll = new Button(buttons, 8);
        this.deselectAll.setText(VresourceBundle.getString((String)"deselect_all_lbl"));
        this.deselectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.selection != null && (obj = this.selection.getFirstElement()) instanceof IContainer) {
            this.select((IContainer)obj);
        }
        if ((lastDirectory = this.getLastLinkDirectory()) != null) {
            this.fromDir.setText(lastDirectory);
            this.loadDirTree(lastDirectory);
        }
        this.validatePage();
    }

    private void selectFiles() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.lastExtensions != null) {
            int i = 0;
            while (i < this.lastExtensions.length) {
                map.put(this.lastExtensions[i], this.lastExtensions[i]);
                ++i;
            }
        }
        if (this.lastOtherExtensions != null) {
            StringTokenizer stn = new StringTokenizer(this.lastOtherExtensions, ",");
            while (stn.hasMoreTokens()) {
                String s = stn.nextToken();
                if (s.startsWith("*.")) {
                    s = s.substring(2);
                } else if (s.startsWith(".")) {
                    s = s.substring(1);
                }
                map.put(s, s);
            }
        }
        TreeItem[] items = this.fileTree.getItems();
        int i = 0;
        while (i < items.length) {
            String fn = items[i].getText();
            int idx = fn.lastIndexOf(46);
            if (idx >= 0 && idx < fn.length() - 1 && map.containsKey(fn.substring(idx + 1))) {
                items[i].setChecked(true);
            } else {
                items[i].setChecked(false);
            }
            ++i;
        }
        this.setFiles();
        this.validatePage();
    }

    private void loadDirTree(String dirname) {
        this.dirTree.removeAll();
        this.fileTree.removeAll();
        File root = new File(dirname);
        this.fileNames = null;
        this.files = null;
        if (root.exists() && root.isDirectory()) {
            this.setLastLinkDirectory(dirname);
            this.dirTreeRootItem = new TreeItem(this.dirTree, 0);
            this.dirTreeRootItem.setText(root.getName());
            this.dirTreeRootItem.setImage(VcobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
            this.dirTreeRootItem.setData("file", (Object)root);
            File[] dirs = root.listFiles(this.filter);
            if (dirs != null && dirs.length > 0) {
                this.dirTreeRootItem.setData("children", (Object)dirs);
                this.dirTreeRootItem.setItemCount(dirs.length);
                this.dirTreeRootItem.setExpanded(true);
            }
            this.dirTree.setSelection(this.dirTreeRootItem);
            this.loadFileTree(root);
        }
        this.validatePage();
    }

    protected void setPageValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void setPageInvalid(String errmsg) {
        this.setErrorMessage(errmsg);
        this.setMessage(null);
        this.setPageComplete(false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
    }

    void activateEditor(TreeItem item) {
        boolean showBorder = true;
        Composite composite = new Composite((Composite)this.fileTree, 0);
        if (showBorder) {
            composite.setBackground(item.getDisplay().getSystemColor(2));
        }
        Text text = new Text(composite, 0);
        int inset = showBorder ? 1 : 0;
        composite.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        text.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        text.addTraverseListener((TraverseListener)new /* Unavailable Anonymous Inner Class!! */);
        text.addVerifyListener((VerifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileTreeEditor.setEditor((Control)composite, item);
        text.setText(item.getText());
        text.selectAll();
        text.setFocus();
    }

    private boolean validatePage() {
        boolean Return;
        if (!this.existsProjects) {
            this.setPageInvalid(VresourceBundle.getString((String)"no_projects_msg"));
            return false;
        }
        boolean bl = Return = this.validateParent() && this.validateSelection();
        if (Return) {
            this.setPageValid();
        }
        return Return;
    }

    private boolean validateParent() {
        if (this.parentFolder == null) {
            this.setPageInvalid(VresourceBundle.getString((String)"select_dest_folder_lbl"));
            return false;
        }
        return true;
    }

    protected boolean validateSelection() {
        return true;
    }

    private void setFiles() {
        ArrayList<String> n = new ArrayList<String>();
        ArrayList<Object> f = new ArrayList<Object>();
        TreeItem[] items = this.fileTree.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                n.add(items[i].getText());
                f.add(items[i].getData());
            }
            ++i;
        }
        if (f.size() == 0) {
            this.fileNames = null;
            this.files = null;
        } else {
            this.fileNames = new String[n.size()];
            n.toArray(this.fileNames);
            this.files = new File[f.size()];
            f.toArray(this.files);
        }
    }

    protected boolean exists(IResource res) {
        IPath location = res.getLocation();
        return location != null && location.toFile().exists();
    }

    protected void createFiles(ArrayList outputFiles, IProgressMonitor monitor) {
        try {
            try {
                this.parentFolder.refreshLocal(2, null);
                if (monitor != null) {
                    monitor.beginTask("Create Links", this.fileNames.length);
                }
                boolean saveProjectOptions = false;
                int i = 0;
                while (i < this.fileNames.length) {
                    if (monitor != null && monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String name = this.fileNames[i];
                    Path p = new Path(name);
                    IFile file = this.parentFolder.getFile((IPath)p);
                    if (monitor != null) {
                        monitor.subTask("Link file '" + file.getName() + "'...");
                    }
                    if (this.canCreate(file, this.files[i])) {
                        if (this.exists((IResource)file)) {
                            PluginUtilities.deleteFile((IFile)file, (boolean)false);
                        }
                        if (PluginUtilities.createLinkFile((IFile)file, (URI)this.files[i].toURI())) {
                            outputFiles.add(file);
                            saveProjectOptions = true;
                        }
                    } else {
                        PluginUtilities.removePersistentProperties((IFile)file);
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    ++i;
                }
                if (saveProjectOptions) {
                    PluginUtilities.saveProjectOptions((IProject)this.parentFolder.getProject());
                }
            }
            catch (CoreException coreException) {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected IFile[] createFiles() {
        if (this.fileNames == null) {
            return null;
        }
        try {
            ArrayList outputFiles = new ArrayList();
            this.createFiles(outputFiles, null);
            IFile[] Return = new IFile[outputFiles.size()];
            outputFiles.toArray(Return);
            return Return;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void select(IContainer cnt) {
        if (cnt != null) {
            IPath path = cnt.getFullPath();
            this.select(this.destTree.getItems(), path, 0);
            this.parentFolder = cnt;
        }
        this.validatePage();
    }

    private void select(TreeItem[] items, IPath path, int idx) {
        int i = 0;
        while (i < items.length) {
            if (items[i].getText().equals(path.segment(idx))) {
                if (idx >= path.segmentCount() - 1 || items[i].getItemCount() <= 0) {
                    this.destTree.setSelection(items[i]);
                    return;
                }
                this.select(items[i].getItems(), path, idx + 1);
                return;
            }
            ++i;
        }
    }

    public boolean validateFileName(String filename) {
        return true;
    }

    private void loadFileTree(File dir) {
        File[] files = dir.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */);
        Arrays.sort(files, new /* Unavailable Anonymous Inner Class!! */);
        this.fileTree.removeAll();
        int i = 0;
        while (i < files.length) {
            TreeItem item = new TreeItem(this.fileTree, 0);
            String name = files[i].getName();
            item.setText(name);
            item.setData((Object)files[i]);
            item.setImage(this.getFileTreeItemImage(files[i].getName()));
            ++i;
        }
        this.selectFiles();
        this.fileNames = null;
        this.validatePage();
    }

    protected Image getFileTreeItemImage(String filename) {
        int idx;
        ImageDescriptor imd;
        IEditorDescriptor defEditor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(filename);
        Image image = null;
        if (defEditor != null && (imd = defEditor.getImageDescriptor()) != null && (idx = filename.lastIndexOf(46)) >= 0 && idx < filename.length() - 1) {
            image = VcobolEditorPlugin.getDefault().getImageProvider().getEditorReferenceImage(imd, filename.substring(idx + 1));
        }
        if (image == null) {
            image = VcobolEditorPlugin.getDefault().getImageProvider().getImage("/file_obj.gif");
        }
        return null;
    }

    private int openMessageDialog(String message) {
        int[] Return = new int[1];
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return Return[0];
    }

    protected boolean canCreate(IFile destFile, File srcFile) {
        if (this.exists((IResource)destFile)) {
            switch (this.overwriteCode) {
                case 1: {
                    return true;
                }
                case 0: 
                case 2: {
                    this.overwriteCode = this.openMessageDialog(String.valueOf(VresourceBundle.getString((String)"overwrite_lbl")) + " file '" + destFile.getName() + "'");
                    if (this.overwriteCode < 0) {
                        this.overwriteCode = 2;
                    }
                    switch (this.overwriteCode) {
                        case 0: 
                        case 1: {
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    static /* synthetic */ String[] access$0(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.lastExtensions;
    }

    static /* synthetic */ String access$1(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.lastOtherExtensions;
    }

    static /* synthetic */ Tree access$2(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.destTree;
    }

    static /* synthetic */ boolean access$3(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.validatePage();
    }

    static /* synthetic */ Text access$4(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.fromDir;
    }

    static /* synthetic */ void access$5(NewLinkedFilesPage newLinkedFilesPage, String string) {
        newLinkedFilesPage.loadDirTree(string);
    }

    static /* synthetic */ TreeItem access$6(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.dirTreeRootItem;
    }

    static /* synthetic */ FileFilter access$7(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.filter;
    }

    static /* synthetic */ Tree access$8(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.dirTree;
    }

    static /* synthetic */ TreeItem access$9(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.lastDirItem;
    }

    static /* synthetic */ void access$10(NewLinkedFilesPage newLinkedFilesPage, File file) {
        newLinkedFilesPage.loadFileTree(file);
    }

    static /* synthetic */ void access$11(NewLinkedFilesPage newLinkedFilesPage, TreeItem treeItem) {
        newLinkedFilesPage.lastDirItem = treeItem;
    }

    static /* synthetic */ void access$12(NewLinkedFilesPage newLinkedFilesPage, TreeItem treeItem) {
        newLinkedFilesPage.lastFileItem = treeItem;
    }

    static /* synthetic */ void access$13(NewLinkedFilesPage newLinkedFilesPage) {
        newLinkedFilesPage.setFiles();
    }

    static /* synthetic */ TreeItem access$14(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.lastFileItem;
    }

    static /* synthetic */ void access$15(NewLinkedFilesPage newLinkedFilesPage, String[] stringArray) {
        newLinkedFilesPage.lastExtensions = stringArray;
    }

    static /* synthetic */ void access$16(NewLinkedFilesPage newLinkedFilesPage, String string) {
        newLinkedFilesPage.lastOtherExtensions = string;
    }

    static /* synthetic */ void access$17(NewLinkedFilesPage newLinkedFilesPage) {
        newLinkedFilesPage.selectFiles();
    }

    static /* synthetic */ Tree access$18(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.fileTree;
    }

    static /* synthetic */ TreeEditor access$19(NewLinkedFilesPage newLinkedFilesPage) {
        return newLinkedFilesPage.fileTreeEditor;
    }
}

