/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.wizards;

import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.vcobol.plugins.editor.views.VcobolNavigator;
import com.vcobol.plugins.editor.wizards.NewLinkedFilesPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewLinkedFilesWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewLinkedFilesPage page;

    public NewLinkedFilesWizard() {
        this.setWindowTitle(VresourceBundle.getString((String)"new_linked_files_title"));
    }

    public boolean performFinish() {
        IFile[] progFiles = this.page.createFiles();
        if (progFiles != null && progFiles.length > 0) {
            VcobolNavigator isNav = PluginUtilities.findVcobolNavigator();
            BasicNewResourceWizard.selectAndReveal((IResource)progFiles[0].getParent(), (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
            if (isNav != null) {
                isNav.refresh((IResource)progFiles[0].getProject());
            }
        }
        return this.page.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void addPages() {
        try {
            this.adjustSelection();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.page = new NewLinkedFilesPage("NewLinkedFilesPage", VresourceBundle.getString((String)"new_linked_files2_title"), null);
        this.page.init(this.workbench, this.selection);
        this.page.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page);
    }

    protected void adjustSelection() throws CoreException {
        IContainer folder;
        IResource resource;
        IProject project;
        Object elem;
        if (this.selection != null && !this.selection.isEmpty() && (elem = this.selection.getFirstElement()) instanceof IResource && (project = (resource = (IResource)elem).getProject()) != null && project.getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") != null && (folder = this.getDefaultFolder(project)) != null) {
            this.selection = new StructuredSelection((Object)folder);
        }
    }

    protected IContainer getDefaultFolder(IProject project) throws CoreException {
        String mode = PluginUtilities.getCurrentSettingMode((IResource)project);
        IContainer[] copyFolders = PluginUtilities.getCopyFolders((IProject)project, (String)mode);
        if (copyFolders != null && copyFolders.length > 0) {
            return copyFolders[0];
        }
        return null;
    }
}

