/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.wizards;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.vcobol.plugins.editor.views.VcobolNavigator;
import com.vcobol.plugins.editor.wizards.ResourceSettingsPanel;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectSettingsPage
extends PropertyPage
implements IWizardPage {
    private Text srcTxt;
    private Text resourceTxt;
    private Text logsTxt;
    private Text dataTxt;
    private Text vcobolPropsTxt;
    private IWizard wizard;
    private IWizardPage prevPage;
    private IWizardPage nextPage;
    private boolean valid = true;
    private Control control;

    public boolean canFlipToNextPage() {
        return this.valid;
    }

    public String getName() {
        return "";
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.control != null) {
            IPreferenceStore store = VcobolEditorPlugin.getDefault().getPreferenceStore();
            this.srcTxt.setText(this.getPreference(store, "vcobol.newproject.sourcedir"));
            this.resourceTxt.setText(this.getPreference(store, "vcobol.newproject.resourcesdir"));
            this.logsTxt.setText(this.getPreference(store, "vcobol.newproject.logsdir"));
            this.dataTxt.setText(this.getPreference(store, "vcobol.newproject.datadir"));
            this.vcobolPropsTxt.setText(this.getPreference(store, "vcobol.newproject.ispropsfile"));
        }
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(IWizard w) {
        this.wizard = w;
    }

    public void setNextPage(IWizardPage page) {
        this.nextPage = page;
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setPreviousPage(IWizardPage page) {
        this.prevPage = page;
    }

    public IWizardPage getPreviousPage() {
        return this.prevPage;
    }

    public boolean isPageComplete() {
        return this.valid;
    }

    private String getPreference(IPreferenceStore store, String name) {
        if (store.contains(name)) {
            return store.getString(name);
        }
        return store.getDefaultString(name);
    }

    public Control createContents(Composite parent) {
        String def;
        int numColumns;
        IPreferenceStore store = VcobolEditorPlugin.getDefault().getPreferenceStore();
        this.setTitle("Project Settings");
        IProject project = (IProject)this.getElement();
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = numColumns = project != null ? 3 : 2;
        composite.setLayout((Layout)gl);
        Label l = new Label(composite, 0);
        l.setText(String.valueOf(VresourceBundle.getString((String)"src_dir_lbl")) + ": ");
        this.srcTxt = new Text(composite, 2048);
        GridData gd = new GridData(768);
        this.srcTxt.setLayoutData((Object)gd);
        this.srcTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (project != null) {
            def = PluginUtilities.getPersistentProperty((IResource)project, (String)"Default", (String)"sourcedir");
            if (def != null) {
                this.srcTxt.setText(def);
            }
            this.createBrowseButton(project, this.srcTxt);
        } else {
            this.srcTxt.setText(this.getPreference(store, "vcobol.newproject.sourcedir"));
        }
        l = new Label(composite, 0);
        l.setText(String.valueOf(VresourceBundle.getString((String)"res_dir_lbl")) + ": ");
        this.resourceTxt = new Text(composite, 2048);
        gd = new GridData(768);
        this.resourceTxt.setLayoutData((Object)gd);
        this.resourceTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (project != null) {
            def = PluginUtilities.getPersistentProperty((IResource)project, (String)"Default", (String)"resourcesdir");
            if (def != null) {
                this.resourceTxt.setText(def);
            }
            this.createBrowseButton(project, this.resourceTxt);
        } else {
            this.resourceTxt.setText(this.getPreference(store, "vcobol.newproject.resourcesdir"));
        }
        l = new Label(composite, 0);
        l.setText(String.valueOf(VresourceBundle.getString((String)"logs_dir_lbl")) + ": ");
        this.logsTxt = new Text(composite, 2048);
        gd = new GridData(768);
        this.logsTxt.setLayoutData((Object)gd);
        this.logsTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (project != null) {
            def = PluginUtilities.getPersistentProperty((IResource)project, (String)"Default", (String)"logsdir");
            if (def != null) {
                this.logsTxt.setText(def);
            }
            this.createBrowseButton(project, this.logsTxt);
        } else {
            this.logsTxt.setText(this.getPreference(store, "vcobol.newproject.logsdir"));
        }
        l = new Label(composite, 0);
        l.setText(String.valueOf(VresourceBundle.getString((String)"data_dir_lbl")) + ": ");
        this.dataTxt = new Text(composite, 2048);
        gd = new GridData(768);
        this.dataTxt.setLayoutData((Object)gd);
        this.dataTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (project != null) {
            def = PluginUtilities.getPersistentProperty((IResource)project, (String)"Default", (String)"datadir");
            if (def != null) {
                this.dataTxt.setText(def);
            }
            this.createBrowseButton(project, this.dataTxt);
        } else {
            this.dataTxt.setText(this.getPreference(store, "vcobol.newproject.datadir"));
        }
        Group grp = new Group(composite, 0);
        grp.setText("vcobol.properties");
        gd = new GridData(768);
        gd.horizontalSpan = gl.numColumns;
        gd.heightHint = 250;
        grp.setLayoutData((Object)gd);
        grp.setLayout((Layout)new FillLayout());
        this.vcobolPropsTxt = new Text((Composite)grp, 2818);
        if (project != null) {
            try {
                IFolder resourceFolder = PluginUtilities.getResourcesFolder((IProject)project);
                if (resourceFolder != null && resourceFolder.exists()) {
                    IFile file = resourceFolder.getFile((IPath)new Path("vcobol.properties"));
                    if (!file.exists()) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(this.getPreference(store, "vcobol.newproject.ispropsfile").getBytes());
                        PluginUtilities.createFile((IFile)file, (InputStream)bais);
                        bais.close();
                    }
                    InputStream is = file.getContents();
                    byte[] bytes = new byte[is.available()];
                    is.read(bytes);
                    is.close();
                    this.vcobolPropsTxt.setText(new String(bytes));
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            this.vcobolPropsTxt.setText(this.getPreference(store, "vcobol.newproject.ispropsfile"));
        }
        this.control = composite;
        return composite;
    }

    private void createBrowseButton(IProject project, Text text) {
        Button btn = new Button(text.getParent(), 8);
        btn.setText(VresourceBundle.getString((String)"browse_lbl"));
        GridData gd = new GridData(4);
        btn.setLayoutData((Object)gd);
        btn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setValid(boolean v) {
        this.valid = v;
        super.setValid(v);
    }

    private boolean setPageValid(String errorMessage, int errorType) {
        this.setMessage(errorMessage, errorType);
        return errorMessage == null || errorType != 3;
    }

    public boolean isValid() {
        if (this.control == null) {
            return true;
        }
        String errorMessage = ResourceSettingsPanel.validateOpt((IProject)((IProject)this.getElement()), (String)"sourcedir", (String)this.srcTxt.getText());
        if (errorMessage != null) {
            return this.setPageValid(errorMessage, 2);
        }
        if (this.srcTxt.getText().equalsIgnoreCase("translated")) {
            errorMessage = VresourceBundle.getString((String)"translated_reserved_msg");
            return this.setPageValid(errorMessage, 2);
        }
        errorMessage = ResourceSettingsPanel.validateOpt((IProject)((IProject)this.getElement()), (String)"resourcesdir", (String)this.resourceTxt.getText());
        if (errorMessage != null) {
            return this.setPageValid(errorMessage, 2);
        }
        errorMessage = ResourceSettingsPanel.validateOpt((IProject)((IProject)this.getElement()), (String)"logsdir", (String)this.logsTxt.getText());
        if (errorMessage != null) {
            return this.setPageValid(errorMessage, 2);
        }
        errorMessage = ResourceSettingsPanel.validateOpt((IProject)((IProject)this.getElement()), (String)"datadir", (String)this.dataTxt.getText());
        if (errorMessage != null) {
            return this.setPageValid(errorMessage, 2);
        }
        return this.setPageValid(errorMessage, 2);
    }

    public boolean performOk() {
        return this.performOk((IProject)this.getElement(), false);
    }

    private void saveField(IProject project, Text text, boolean createDirs, String mode, String key, String def) {
        String src = text.getText();
        if (src.length() == 0) {
            src = def;
        }
        Path p = new Path(src);
        if (!src.equals("/") && !src.equals("") && !project.exists((IPath)p) && createDirs) {
            PluginUtilities.createFolder((IFolder)project.getFolder((IPath)p));
        }
        PluginUtilities.setPersistentProperty((IResource)project, (String)mode, (String)key, (String)src);
    }

    public boolean performOk(IProject project, boolean createDirs) {
        if (project != null) {
            VcobolNavigator isNav;
            this.saveField(project, this.srcTxt, createDirs, "Default", "sourcedir", "source");
            this.saveField(project, this.resourceTxt, createDirs, "Default", "resourcesdir", "");
            this.saveField(project, this.logsTxt, createDirs, "Default", "logsdir", "logs");
            this.saveField(project, this.dataTxt, createDirs, "Default", "datadir", "data");
            PluginUtilities.saveProjectOptions((IProject)project);
            try {
                IFolder resourceFolder = PluginUtilities.getResourcesFolder((IProject)project);
                if (resourceFolder != null && resourceFolder.exists()) {
                    IFile file = resourceFolder.getFile((IPath)new Path("vcobol.properties"));
                    if (!file.exists()) {
                        PluginUtilities.createFile((IFile)file, null);
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(this.vcobolPropsTxt.getText().getBytes());
                    PluginUtilities.modifyFile((IFile)file, (InputStream)bais, (boolean)false);
                    bais.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if ((isNav = PluginUtilities.findVcobolNavigator()) != null) {
                isNav.refresh((IResource)project);
            }
        }
        return true;
    }
}

