/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.wizards;

import com.vcobol.plugins.editor.util.PluginUtilities;
import com.vcobol.plugins.editor.wizards.FileSettingsPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public abstract class VcobolNewFileWizard
extends BasicNewFileResourceWizard {
    protected WizardNewFileCreationPage mainPage;
    protected FileSettingsPage settingsPage;
    public static final String rcsid = "$Id: IscobolNewFileWizard.java,v 1.4 2008/12/12 11:14:37 gianni Exp $";

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        if (this.settingsPage != null) {
            this.settingsPage.performOk((IResource)file);
        }
        this.selectAndReveal((IResource)file);
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        this.fileCreated(file);
        return true;
    }

    protected abstract void fileCreated(IFile var1);

    public void addPages() {
        try {
            this.adjustSelection();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.mainPage = this.createMainPage();
        this.mainPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.mainPage);
        this.settingsPage = this.createFileSettingsPage();
        if (this.settingsPage != null) {
            this.settingsPage.setWizard((IWizard)this);
            this.settingsPage.setPreviousPage((IWizardPage)this.mainPage);
            this.addPage((IWizardPage)this.settingsPage);
        }
    }

    protected final void adjustSelection() throws CoreException {
        IContainer folder;
        IProject selProject = this.getSelectedProject();
        if (selProject != null && (folder = this.getDefaultFolder(selProject)) != null) {
            this.selection = new StructuredSelection((Object)folder);
        }
    }

    protected final IProject getSelectedProject() {
        Object elem;
        if (this.selection != null && !this.selection.isEmpty() && (elem = this.selection.getFirstElement()) instanceof IResource) {
            IProject project = ((IResource)elem).getProject();
            try {
                if (project != null && project.getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") != null) {
                    return project;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    protected IContainer getDefaultFolder(IProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        return PluginUtilities.getSourceFolder((IProject)project);
    }

    protected abstract WizardNewFileCreationPage createMainPage();

    protected abstract FileSettingsPage createFileSettingsPage();
}

