/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.wizards;

import com.vcobol.plugins.editor.VcobolEditor;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.util.PluginUtilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class VcobolNewProgramPage
extends WizardNewFileCreationPage {
    private static final String eol = System.getProperty("line.separator", "\n");
    public static final String rcsid = "$Id: IscobolNewProgramPage.java,v 1.7 2008/12/12 11:14:37 gianni Exp $";
    private static final String FIX_SPACES = "       ";

    public VcobolNewProgramPage(IStructuredSelection sel) {
        super(VresourceBundle.getString((String)"new_program_title"), sel);
        this.setDescription(VresourceBundle.getString((String)"new_program_desc"));
    }

    public IFile createNewFile() {
        IFile Return;
        String filename = this.getFileName();
        String ext = null;
        int idx = filename.lastIndexOf(46);
        if (idx >= 0 && idx < filename.length() - 1) {
            ext = filename.substring(idx + 1);
        }
        if (ext == null) {
            if (idx >= 0) {
                this.setFileName(String.valueOf(filename) + "cbl");
            } else {
                this.setFileName(String.valueOf(filename) + ".cbl");
            }
        }
        if ((Return = super.createNewFile()) == null || Return.isLinked()) {
            return Return;
        }
        String progId = filename.toUpperCase();
        if (idx >= 0) {
            progId = progId.substring(0, idx);
        }
        StringBuffer contents = new StringBuffer();
        contents.append(eol).append(FIX_SPACES).append("IDENTIFICATION DIVISION.").append(eol).append(eol);
        contents.append(FIX_SPACES).append("PROGRAM-ID. ").append(progId).append(".").append(eol);
        contents.append(FIX_SPACES).append("AUTHOR. ").append(System.getProperty("user.name", "")).append(".").append(eol).append(eol);
        contents.append(FIX_SPACES).append("ENVIRONMENT DIVISION.").append(eol).append(eol);
        contents.append(FIX_SPACES).append("CONFIGURATION SECTION.").append(eol).append(eol);
        contents.append(FIX_SPACES).append("DATA DIVISION.").append(eol).append(eol);
        contents.append(FIX_SPACES).append("WORKING-STORAGE SECTION.").append(eol).append(eol);
        contents.append(FIX_SPACES).append("LINKAGE SECTION.").append(eol).append(eol);
        contents.append(FIX_SPACES).append("PROCEDURE DIVISION.").append(eol).append(eol);
        contents.append(FIX_SPACES).append("MAIN.");
        ByteArrayInputStream bais = new ByteArrayInputStream(contents.toString().getBytes());
        PluginUtilities.modifyFile((IFile)Return, (InputStream)bais, (boolean)true);
        try {
            bais.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IEditorDescriptor defaultEditor = IDE.getDefaultEditor((IFile)Return);
        if (defaultEditor == null || !defaultEditor.getId().equals(VcobolEditor.ID)) {
            IDE.setDefaultEditor((IFile)Return, (String)VcobolEditor.ID);
        }
        return Return;
    }

    protected boolean validatePage() {
        boolean Return = super.validatePage();
        if (!Return) {
            return Return;
        }
        IPath containerPath = this.getContainerFullPath();
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath);
        if (!(container instanceof IContainer) || !PluginUtilities.isInSourceFolder((IContainer)((IContainer)container))) {
            this.setErrorMessage(VresourceBundle.getString((String)"file_not_in_src_fld_msg"));
            Return = false;
        } else {
            this.setErrorMessage(null);
        }
        return Return;
    }
}

