/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.wizards;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import com.vcobol.plugins.editor.util.PluginUtilities;
import com.vcobol.plugins.editor.wizards.ClasspathPage;
import com.vcobol.plugins.editor.wizards.ProjectSettingsPage;
import com.vcobol.plugins.editor.wizards.ProjectSettingsPage2;
import com.vcobol.plugins.editor.wizards.VcobolNewProjectPage;
import com.vcobol.plugins.editor.wizards.VcobolNewProjectWizard;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class VcobolNewProjectWizard
extends BasicNewProjectResourceWizard
implements INewWizard {
    public static final String rcsid = "$Id: IscobolNewProjectWizard.java,v 1.8 2008/12/11 14:16:09 gianni Exp $";
    private VcobolNewProjectPage mainPage;
    private ProjectSettingsPage projectPage1;
    private ProjectSettingsPage2 projectPage2;
    private ClasspathPage classpathPage;
    private WizardNewProjectReferencePage referencePage;
    private IProject newProject;

    public void addPages() {
        this.mainPage = new VcobolNewProjectPage();
        this.addPage((IWizardPage)this.mainPage);
        this.projectPage1 = new ProjectSettingsPage();
        this.projectPage1.setWizard((IWizard)this);
        this.projectPage1.setPreviousPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.projectPage1);
        this.projectPage2 = new ProjectSettingsPage2();
        this.projectPage2.setWizard((IWizard)this);
        this.projectPage2.setPreviousPage((IWizardPage)this.projectPage1);
        this.addPage((IWizardPage)this.projectPage2);
        this.classpathPage = new ClasspathPage();
        this.classpathPage.setWizard((IWizard)this);
        this.classpathPage.setPreviousPage((IWizardPage)this.projectPage2);
        this.addPage((IWizardPage)this.classpathPage);
        this.projectPage1.setNextPage((IWizardPage)this.projectPage2);
        this.projectPage2.setNextPage((IWizardPage)this.classpathPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("basicReferenceProjectPage");
            this.referencePage.setTitle(VresourceBundle.getString((String)"project_ref_title"));
            this.referencePage.setDescription(VresourceBundle.getString((String)"project_ref_desc"));
            this.classpathPage.setNextPage((IWizardPage)this.referencePage);
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    protected IProject createNewProject() {
        IProject[] refProjects;
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        if (this.referencePage != null && (refProjects = this.referencePage.getReferencedProjects()).length > 0) {
            description.setReferencedProjects(refProjects);
        }
        1 op = new /* Unavailable Anonymous Inner Class!! */;
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException _ex) {
            return null;
        }
        catch (InvocationTargetException e) {
            PluginUtilities.log((Throwable)e);
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    private void intCreateProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        try {
            VcobolEditorPlugin.getDefault().addProject(this.newProject);
            this.addBuilder(this.newProject, "com.vcobol.plugins.editor.VcobolEditor.VcobolBuilder");
            this.projectPage1.performOk(this.newProject, true);
            this.projectPage2.performOk(this.newProject, true);
            this.classpathPage.performOk(this.newProject);
        }
        catch (CoreException ex) {
            PluginUtilities.log((Throwable)ex);
        }
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    private void addBuilder(IProject project, String id) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(id)) {
                return;
            }
            ++i;
        }
        ICommand command = desc.newCommand();
        command.setBuilderName(id);
        command.setBuilding(6, true);
        ICommand[] nc = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, nc, 1, commands.length);
        nc[0] = command;
        desc.setBuildSpec(nc);
        project.setDescription(desc, null);
        desc.setNatureIds(new String[]{"com.vcobol.plugins.editor.VcobolEditor.VcobolNature", "com.vcobol.plugins.editor.VcobolEditor.VcobolNatureExt"});
        project.setDescription(desc, null);
    }

    static /* synthetic */ void access$0(VcobolNewProjectWizard vcobolNewProjectWizard, IProjectDescription iProjectDescription, IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        vcobolNewProjectWizard.intCreateProject(iProjectDescription, iProject, iProgressMonitor);
    }
}

