/*
 * Decompiled with CFR 0.152.
 */
package com.vcobol.plugins.editor.wizards;

import com.vcobol.plugins.editor.VcobolEditorPlugin;
import com.vcobol.plugins.editor.VresourceBundle;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class VcobolPropertiesImportExportPage
extends WizardPage {
    private IStructuredSelection selection;
    private String propFileName;
    private Tree tree;
    private Text propFileNameTxt;
    private Button browseBtn;
    private boolean existsProjects = false;
    protected IProject parentProject;
    private boolean Import;

    public VcobolPropertiesImportExportPage(String pageName, IStructuredSelection selection, boolean Import) {
        super(pageName, "vCOBOL Project Preferences", null);
        this.selection = selection;
        this.Import = Import;
    }

    public IProject getParentProject() {
        return this.parentProject;
    }

    public String getPropFileName() {
        return this.propFileName;
    }

    private boolean validatePage() {
        boolean Return;
        if (!this.existsProjects) {
            this.setPageInvalid(VresourceBundle.getString((String)"no_projects_msg"));
            return false;
        }
        boolean bl = Return = this.validateParent() && this.validatePropFileName();
        if (Return) {
            this.setPageValid();
        }
        return Return;
    }

    private boolean validatePropFileName() {
        this.propFileName = this.propFileNameTxt.getText();
        if (this.propFileName.length() == 0) {
            this.setPageInvalid(VresourceBundle.getString((String)"sel_propfile_lbl"));
            return false;
        }
        if (this.Import && !new File(this.propFileName).exists()) {
            this.setPageInvalid("File '" + this.propFileNameTxt.getText() + "' " + VresourceBundle.getString((String)"not_exist_msg"));
            return false;
        }
        return true;
    }

    protected void setPageValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    protected void setPageInvalid(String errmsg) {
        this.setErrorMessage(errmsg);
        this.setMessage(null);
        this.setPageComplete(false);
    }

    private boolean validateParent() {
        if (this.parentProject == null) {
            this.setPageInvalid(VresourceBundle.getString((String)"select_parent_prj_msg"));
            return false;
        }
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        composite.setLayout((Layout)gl);
        Label lbl = new Label(composite, 0);
        if (this.Import) {
            lbl.setText(VresourceBundle.getString((String)"sel_dst_prj_lbl"));
        } else {
            lbl.setText(VresourceBundle.getString((String)"sel_src_prj_lbl"));
        }
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        lbl.setLayoutData((Object)gd);
        this.tree = new Tree(composite, 2048);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 80;
        this.tree.setLayoutData((Object)gd);
        Label l = new Label(composite, 0);
        l.setText(String.valueOf(VresourceBundle.getString((String)"propfile_lbl")) + ":");
        this.propFileNameTxt = new Text(composite, 2048);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        gd = new GridData(768);
        this.propFileNameTxt.setLayoutData((Object)gd);
        this.propFileNameTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.browseBtn = new Button(composite, 8);
        this.browseBtn.setText(VresourceBundle.getString((String)"browse_lbl"));
        this.browseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (projects != null) {
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen() && this.isVcobolProject(projects[i])) {
                    this.existsProjects = true;
                    TreeItem item = new TreeItem(this.tree, 0);
                    item.setImage(VcobolEditorPlugin.getDefault().getImageProvider().getImage("/prj.gif"));
                    item.setText(projects[i].getName());
                    item.setData((Object)projects[i]);
                }
                ++i;
            }
        }
        this.tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.selection.isEmpty()) {
            IProject selPrj = ((IResource)this.selection.getFirstElement()).getProject();
            TreeItem[] items = this.tree.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].getText().equals(selPrj.getName())) {
                    this.tree.setSelection(items[i]);
                    this.parentProject = selPrj;
                }
                ++i;
            }
        }
        this.validatePage();
    }

    private boolean isVcobolProject(IProject project) {
        try {
            return project.getNature("com.vcobol.plugins.editor.VcobolEditor.VcobolNature") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static /* synthetic */ boolean access$0(VcobolPropertiesImportExportPage vcobolPropertiesImportExportPage) {
        return vcobolPropertiesImportExportPage.validatePage();
    }

    static /* synthetic */ boolean access$1(VcobolPropertiesImportExportPage vcobolPropertiesImportExportPage) {
        return vcobolPropertiesImportExportPage.Import;
    }

    static /* synthetic */ Text access$2(VcobolPropertiesImportExportPage vcobolPropertiesImportExportPage) {
        return vcobolPropertiesImportExportPage.propFileNameTxt;
    }
}

