/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.html_android.gui;

import com.iscobol.html_android.gui.ControlModifyListener;
import com.iscobol.html_android.gui.WebContentsControl;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class WebContentsControl {
    private static final String INCL_CLASSES_PFX = "Included: ";
    private static final String INCL_HTML_PFX = "Included: ";
    private static final String EXCL_CLASSES_PFX = "Excluded: ";
    private static final String EXCL_HTML_PFX = "Excluded: ";
    private static final String INCL_CP_PFX = "Project classpath: ";
    private Tree tree;
    private Button editBtn;
    private Button resetBtn;
    private Text systemPropTxt;
    private TreeItem inclClassesItem;
    private TreeItem exclClassesItem;
    private TreeItem inclHtmlItem;
    private TreeItem exclHtmlItem;
    private TreeItem inclClasspathItem;
    private ControlModifyListener listener;
    private IProject project;
    private Type type;

    public WebContentsControl(IProject iProject, Type type) {
        this.project = iProject;
        this.type = type;
    }

    public Composite createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        this.tree = new Tree((Composite)group, 2048);
        gridData = new GridData(1808);
        gridData.widthHint = 200;
        gridData.heightHint = 300;
        gridData.verticalSpan = 2;
        this.tree.setLayoutData((Object)gridData);
        TreeItem treeItem = new TreeItem(this.tree, 0);
        treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
        treeItem.setText("classes");
        this.inclClassesItem = new TreeItem(treeItem, 0);
        this.inclClassesItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/include.gif"));
        this.setIncludeClassesDefault();
        this.exclClassesItem = new TreeItem(treeItem, 0);
        this.exclClassesItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/exclude.gif"));
        this.setExcludeClassesDefault();
        this.inclClasspathItem = new TreeItem(treeItem, 0);
        this.inclClasspathItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/classpath.gif"));
        this.setIncludeClasspathDefault();
        TreeItem treeItem2 = new TreeItem(this.tree, 0);
        treeItem2.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/folder.gif"));
        treeItem2.setText("html");
        this.inclHtmlItem = new TreeItem(treeItem2, 0);
        this.inclHtmlItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/include.gif"));
        this.setIncludeHtmlDefault();
        this.exclHtmlItem = new TreeItem(treeItem2, 0);
        this.exclHtmlItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/exclude.gif"));
        this.setExcludeHtmlDefault();
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        this.editBtn = new Button((Composite)group, 8);
        this.editBtn.setText("Edit");
        this.editBtn.setLayoutData((Object)gridData);
        this.editBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editBtn.setEnabled(false);
        this.resetBtn = new Button((Composite)group, 8);
        this.resetBtn.setText("Reset");
        this.resetBtn.setLayoutData((Object)gridData);
        this.resetBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.resetBtn.setEnabled(false);
        this.tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.type == Type.RUN_CONFIGURATION) {
            Group group2 = new Group(composite2, 0);
            group2.setText("System properties");
            group2.setLayout((Layout)new GridLayout());
            this.systemPropTxt = new Text((Composite)group2, 2048);
            group2.setLayoutData((Object)new GridData(768));
            this.systemPropTxt.setLayoutData((Object)new GridData(768));
            this.systemPropTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        return composite2;
    }

    public void setIncludeClasses(String string) {
        this.inclClassesItem.setText("Included: " + string);
    }

    public void setIncludeHtml(String string) {
        this.inclHtmlItem.setText("Included: " + string);
    }

    public void setIncludeClasspath(String string) {
        this.inclClasspathItem.setText(INCL_CP_PFX + string);
    }

    public void setExcludeClasses(String string) {
        this.exclClassesItem.setText("Excluded: " + string);
    }

    public void setExcludeHtml(String string) {
        this.exclHtmlItem.setText("Excluded: " + string);
    }

    public String getIncludeClasses() {
        return this.inclClassesItem.getText().substring("Included: ".length());
    }

    public String getExcludeClasses() {
        return this.exclClassesItem.getText().substring("Excluded: ".length());
    }

    public String getIncludeClasspath() {
        return this.inclClasspathItem.getText().substring(INCL_CP_PFX.length());
    }

    public String getIncludeHtml() {
        return this.inclHtmlItem.getText().substring("Included: ".length());
    }

    public String getExcludeHtml() {
        return this.exclHtmlItem.getText().substring("Excluded: ".length());
    }

    public boolean isIncludeClassesDefault() {
        return this.inclClassesItem.getText().substring("Included: ".length()).equals("(All)");
    }

    public boolean isIncludeHtmlDefault() {
        return this.inclHtmlItem.getText().substring("Included: ".length()).equals("(All)");
    }

    public boolean isIncludeClasspathDefault() {
        return this.inclClasspathItem.getText().substring(INCL_CP_PFX.length()).equals("(All)");
    }

    public boolean isExcludeClassesDefault() {
        return this.exclClassesItem.getText().substring("Excluded: ".length()).equals("(None)");
    }

    public boolean isExcludeHtmlDefault() {
        return this.exclHtmlItem.getText().substring("Excluded: ".length()).equals("(None)");
    }

    public void setIncludeClassesDefault() {
        this.inclClassesItem.setText("Included: (All)");
    }

    public void setIncludeHtmlDefault() {
        this.inclHtmlItem.setText("Included: (All)");
    }

    public void setIncludeClasspathDefault() {
        this.inclClasspathItem.setText("Project classpath: (All)");
    }

    public void setExcludeClassesDefault() {
        this.exclClassesItem.setText("Excluded: (None)");
    }

    public void setExcludeHtmlDefault() {
        this.exclHtmlItem.setText("Excluded: (None)");
    }

    public void setSystemProperties(String string) {
        if (this.type == Type.RUN_CONFIGURATION) {
            this.systemPropTxt.setText(string != null ? string : "");
        }
    }

    public String getSystemProperties() {
        return this.type == Type.RUN_CONFIGURATION ? this.systemPropTxt.getText() : "";
    }

    public void initializeFrom(Map<String, String> map) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = map.get("___included_classes");
        if (string5 != null) {
            this.setIncludeClasses(string5);
        }
        if ((string4 = map.get("___excluded_classes")) != null) {
            this.setExcludeClasses(string4);
        }
        if ((string3 = map.get("___included_html")) != null) {
            this.setIncludeHtml(string3);
        }
        if ((string2 = map.get("___excluded_html")) != null) {
            this.setExcludeHtml(string2);
        }
        if ((string = map.get("___included_classpath")) != null) {
            this.setIncludeClasspath(string);
        }
        String string6 = map.get("___system_props");
        this.setSystemProperties(string6);
    }

    public void performApply(Map<String, String> map) {
        map.put("___included_classes", this.getIncludeClasses());
        map.put("___excluded_classes", this.getExcludeClasses());
        map.put("___included_html", this.getIncludeHtml());
        map.put("___excluded_html", this.getExcludeHtml());
        map.put("___included_classpath", this.getIncludeClasspath());
        if (this.type == Type.RUN_CONFIGURATION) {
            map.put("___system_props", this.getSystemProperties());
        }
    }

    public ControlModifyListener getListener() {
        return this.listener;
    }

    public void setListener(ControlModifyListener controlModifyListener) {
        this.listener = controlModifyListener;
    }

    private void fireModifyEvent() {
        if (this.listener != null) {
            this.listener.controlModified();
        }
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
        this.setIncludeClassesDefault();
        this.setIncludeHtmlDefault();
        this.setIncludeClasspathDefault();
        this.setExcludeClassesDefault();
        this.setExcludeHtmlDefault();
        this.resetBtn.setEnabled(false);
    }

    static /* synthetic */ Tree access$000(WebContentsControl webContentsControl) {
        return webContentsControl.tree;
    }

    static /* synthetic */ TreeItem access$100(WebContentsControl webContentsControl) {
        return webContentsControl.inclClasspathItem;
    }

    static /* synthetic */ IProject access$200(WebContentsControl webContentsControl) {
        return webContentsControl.project;
    }

    static /* synthetic */ void access$300(WebContentsControl webContentsControl) {
        webContentsControl.fireModifyEvent();
    }

    static /* synthetic */ TreeItem access$400(WebContentsControl webContentsControl) {
        return webContentsControl.inclClassesItem;
    }

    static /* synthetic */ TreeItem access$500(WebContentsControl webContentsControl) {
        return webContentsControl.exclClassesItem;
    }

    static /* synthetic */ TreeItem access$600(WebContentsControl webContentsControl) {
        return webContentsControl.inclHtmlItem;
    }

    static /* synthetic */ TreeItem access$700(WebContentsControl webContentsControl) {
        return webContentsControl.exclHtmlItem;
    }

    static /* synthetic */ Button access$800(WebContentsControl webContentsControl) {
        return webContentsControl.editBtn;
    }

    static /* synthetic */ Button access$900(WebContentsControl webContentsControl) {
        return webContentsControl.resetBtn;
    }
}

