/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.html_android.launch;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class InclusionAndExclusionPatternsDialog
extends Dialog {
    public static final int CLASSES = 1;
    public static final int HTML = 2;
    private int contentType;
    private IProject project;
    private String inclusionPattern;
    private String exclusionPattern;
    private Tree inclusionPatternTree;
    private Tree exclusionPatternTree;

    public InclusionAndExclusionPatternsDialog(Shell shell, IProject iProject, String string, String string2, int n) {
        super(shell);
        this.project = iProject;
        this.inclusionPattern = string;
        this.exclusionPattern = string2;
        this.contentType = n;
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Inclusion and Exclusion Patterns");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.inclusionPatternTree = this.createTree(composite2, "Inclusion patterns:", IscobolEditorPlugin.getDefault().getImageProvider().getImage("/include.gif"), this.inclusionPattern);
        this.exclusionPatternTree = this.createTree(composite2, "Exclusion patterns:", IscobolEditorPlugin.getDefault().getImageProvider().getImage("/exclude.gif"), this.exclusionPattern);
        this.inclusionPattern = null;
        this.exclusionPattern = null;
        return composite2;
    }

    public void okPressed() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TreeItem treeItem : this.inclusionPatternTree.getItems()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(treeItem.getText());
        }
        this.inclusionPattern = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        for (TreeItem treeItem : this.exclusionPatternTree.getItems()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(treeItem.getText());
        }
        this.exclusionPattern = stringBuilder.toString();
        super.okPressed();
    }

    public String getInclusionPattern() {
        return this.inclusionPattern;
    }

    public String getExclusionPattern() {
        return this.exclusionPattern;
    }

    private Tree createTree(Composite composite, String string, Image image, String string2) {
        Label label = new Label(composite, 0);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Tree tree = new Tree(composite, 2050);
        gridData = new GridData(1808);
        gridData.widthHint = 630;
        gridData.heightHint = 150;
        gridData.verticalSpan = 2;
        tree.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("Add");
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button button2 = new Button(composite, 8);
        button2.setText("Remove");
        button2.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.verticalAlignment = 128;
        button.setLayoutData((Object)gridData);
        button2.setLayoutData((Object)gridData);
        String string3 = this.getParentFolder();
        if (string3 != null) {
            for (String string4 : string2.split("\\;")) {
                File file = new File(string3 + File.separator + string4);
                if (!file.exists()) continue;
                TreeItem treeItem = new TreeItem(tree, 0);
                treeItem.setImage(image);
                treeItem.setText(string4);
            }
        }
        return tree;
    }

    private String getParentFolder() {
        String string = null;
        if (this.contentType == 1) {
            try {
                string = PluginUtilities.getOutputFolder((IProject)this.project, (String)PluginUtilities.getCurrentSettingMode((IResource)this.project));
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        } else {
            try {
                IContainer iContainer = PluginUtilities.getHtmlAndroidFolder((IProject)this.project);
                if (iContainer != null) {
                    string = iContainer.getLocation().toString();
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
        return string;
    }

    static /* synthetic */ String access$000(InclusionAndExclusionPatternsDialog inclusionAndExclusionPatternsDialog) {
        return inclusionAndExclusionPatternsDialog.getParentFolder();
    }
}

