/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.html_android.wizards;

import com.iscobol.html_android.launch.IscobolHtmlLaunchConfigurationDelegate;
import com.iscobol.html_android.wizards.HtmlToAndroidExportWizard;
import com.iscobol.html_android.wizards.HtmlToAndroidPage1;
import com.iscobol.html_android.wizards.HtmlToAndroidPage2;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HtmlToAndroidExportWizard
extends Wizard
implements IExportWizard {
    private static final String WRITE_EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private IStructuredSelection selection;
    private HtmlToAndroidPage1 page1;
    private HtmlToAndroidPage2 page2;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }

    public boolean performFinish() {
        IProject iProject = (IProject)this.selection.getFirstElement();
        IProject iProject2 = this.page1.getANDROIDProject();
        Map map = this.page2.getAttributes();
        try {
            String[] stringArray = this.getActivityClassName(iProject2);
            String string = stringArray[0];
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getActivityJavaFilePath(string));
            arrayList.add("/res/layout/activity_main.xml");
            if (stringArray[1] == null) {
                arrayList.add("AndroidManifest.xml");
            }
            KeepBackupDialog keepBackupDialog = new KeepBackupDialog(this.getShell(), arrayList.toArray(new String[arrayList.size()]));
            keepBackupDialog.open();
            if (stringArray[1] == null) {
                this.writeAndroidManifest(iProject2, keepBackupDialog.keepBackup);
            }
            this.writeActivityJavaSourceFile(string, iProject2, keepBackupDialog.keepBackup);
            this.writeActivityXmlSourceFile(iProject2, keepBackupDialog.keepBackup);
            this.writeHtmlZipFile(map, iProject, iProject2);
            this.writeCobolJarFile(map, iProject, iProject2);
            this.writeMobileJarFile(iProject2);
            iProject2.refreshLocal(2, null);
        }
        catch (Exception exception) {
            PluginUtilities.logError((String)exception.getMessage());
            return false;
        }
        return true;
    }

    private void writeMobileJarFile(IProject iProject) throws Exception {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = Platform.getBundle((String)"com.iscobol.plugins.libraries").getEntry("ismobile/libs/ismobile.jar").openStream();
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            fileOutputStream = new FileOutputStream(iProject.getLocation().toString() + "/libs/ismobile.jar");
            ((OutputStream)fileOutputStream).write(byArray);
        }
        catch (Exception exception) {
            try {
                throw new Exception("Cannot write 'ismobile.jar' file");
            }
            catch (Throwable throwable) {
                this.closeResources(new Closeable[]{inputStream, fileOutputStream});
                throw throwable;
            }
        }
        this.closeResources(new Closeable[]{inputStream, fileOutputStream});
    }

    private void closeResources(Closeable ... closeableArray) {
        try {
            for (Closeable closeable : closeableArray) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeHtmlZipFile(Map<String, String> map, IProject iProject, IProject iProject2) throws Exception {
        File file = new File(iProject2.getLocation().toString() + "/res/raw");
        if (!file.exists()) {
            file.mkdir();
        }
        String string = file.getAbsolutePath() + "/html.zip";
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            IContainer iContainer = PluginUtilities.getHtmlAndroidFolder((IProject)iProject);
            String string2 = map.get("___included_html");
            String string3 = map.get("___excluded_html");
            IscobolHtmlLaunchConfigurationDelegate.addEntries((File)iContainer.getLocation().toFile(), (String)string2, (String)string3, (String)"", linkedHashMap);
            for (String string4 : linkedHashMap.keySet()) {
                File file2 = new File((String)linkedHashMap.get(string4));
                if (file2.isDirectory()) continue;
                this.writeZipEntry(zipOutputStream, string4, file2);
            }
            IFolder iFolder = PluginUtilities.getResourcesFolder((IProject)iProject);
            if (iFolder != null && iFolder.exists()) {
                this.writeZipEntry(zipOutputStream, "iscobol.properties", new File(iFolder.getLocation().toString() + "/iscobol.properties"));
            }
        }
        catch (Exception exception) {
            try {
                throw new Exception("Cannot write 'html.zip' file");
            }
            catch (Throwable throwable) {
                this.closeResources(new Closeable[]{zipOutputStream});
                throw throwable;
            }
        }
        this.closeResources(new Closeable[]{zipOutputStream});
    }

    private void writeCobolJarFile(Map<String, String> map, IProject iProject, IProject iProject2) throws Exception {
        String string = iProject2.getLocation().toString() + "/libs/cobol.jar";
        JarOutputStream jarOutputStream = null;
        try {
            jarOutputStream = new JarOutputStream(new FileOutputStream(string));
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            String string2 = PluginUtilities.getOutputFolder((IProject)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject));
            String string3 = map.get("___included_classes");
            String string4 = map.get("___excluded_classes");
            IscobolHtmlLaunchConfigurationDelegate.addEntries((File)new File(string2), (String)string3, (String)string4, (String)"", linkedHashMap);
            for (String string5 : linkedHashMap.keySet()) {
                File file = new File((String)linkedHashMap.get(string5));
                if (file.isDirectory()) continue;
                this.writeJarEntry(jarOutputStream, string5, file);
            }
        }
        catch (Exception exception) {
            try {
                throw new Exception("Cannot write 'cobol.jar' file");
            }
            catch (Throwable throwable) {
                this.closeResources(new Closeable[]{jarOutputStream});
                throw throwable;
            }
        }
        this.closeResources(new Closeable[]{jarOutputStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeZipEntry(ZipOutputStream zipOutputStream, String string, File file) throws IOException {
        FileInputStream fileInputStream;
        block4: {
            fileInputStream = null;
            try {
                if (!file.exists()) break block4;
                fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                ZipEntry zipEntry = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(byArray);
                zipOutputStream.closeEntry();
            }
            catch (IOException iOException) {
                this.closeResources(new Closeable[]{fileInputStream});
                catch (Throwable throwable) {
                    this.closeResources(new Closeable[]{fileInputStream});
                    throw throwable;
                }
            }
        }
        this.closeResources(new Closeable[]{fileInputStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJarEntry(JarOutputStream jarOutputStream, String string, File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                JarEntry jarEntry = new JarEntry(string);
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.write(byArray);
                jarOutputStream.closeEntry();
            }
        }
        catch (Throwable throwable) {
            this.closeResources(new Closeable[]{fileInputStream});
            throw throwable;
        }
        this.closeResources(new Closeable[]{fileInputStream});
    }

    private String getActivityJavaFilePath(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return "/src/" + string2.replace('.', '/') + "/" + string3 + ".java";
    }

    private void writeActivityJavaSourceFile(String string, IProject iProject, boolean bl) throws Exception {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = iProject.getLocation().toString() + "/src/" + string2.replace('.', '/') + "/" + string3 + ".java";
        String string5 = bl ? string4 + ".bak" : null;
        this.writeFile(string4, string5, "resources/android/MainActivity_java_template", (String[][])new String[][]{{"${package_name}", string2}, {"${class_name}", string3}});
    }

    private void writeActivityXmlSourceFile(IProject iProject, boolean bl) throws Exception {
        String string = iProject.getLocation().toString() + "/res/layout/activity_main.xml";
        String string2 = bl ? iProject.getLocation().toString() + "/res/layout/bk_activity_main.xml" : null;
        this.writeFile(string, string2, "resources/android/activity_main.xml", (String[][])new String[0][]);
    }

    private void writeFile(String string, String string2, String string3, String[][] stringArray) throws Exception {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            Object object;
            File file = new File(string);
            if (string2 != null && file.exists()) {
                fileInputStream = new FileInputStream(file);
                object = new byte[((InputStream)fileInputStream).available()];
                ((InputStream)fileInputStream).read((byte[])object);
                fileOutputStream = new FileOutputStream(string2);
                ((OutputStream)fileOutputStream).write((byte[])object);
            }
            printWriter = new PrintWriter(new FileOutputStream(file));
            bufferedReader = new BufferedReader(new InputStreamReader(Platform.getBundle((String)"com.iscobol.plugins.HtmlAndroid").getEntry(string3).openStream()));
            object = bufferedReader.readLine();
            while (object != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    object = object.replace(stringArray[i][0], stringArray[i][1]);
                }
                printWriter.println((String)object);
                object = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            try {
                throw new Exception("Cannot write '" + new File(string).getName() + "' file");
            }
            catch (Throwable throwable) {
                this.closeResources(new Closeable[]{fileInputStream, bufferedReader, fileOutputStream, printWriter});
                throw throwable;
            }
        }
        this.closeResources(new Closeable[]{fileInputStream, bufferedReader, fileOutputStream, printWriter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeAndroidManifest(IProject iProject, boolean bl) throws Exception {
        InputStreamReader inputStreamReader = null;
        try {
            Object object;
            Object object2;
            Object object3;
            String string = iProject.getLocation().toString() + "/AndroidManifest.xml";
            if (bl) {
                object3 = null;
                object2 = null;
                try {
                    object3 = new FileInputStream(string);
                    object = new byte[((InputStream)object3).available()];
                    ((InputStream)object3).read((byte[])object);
                    object2 = new FileOutputStream(string + ".bak");
                    ((OutputStream)object2).write((byte[])object);
                }
                catch (IOException iOException) {
                    this.closeResources(new Closeable[]{object3, object2});
                    catch (Throwable throwable) {
                        this.closeResources(new Closeable[]{object3, object2});
                        throw throwable;
                    }
                }
                this.closeResources(new Closeable[]{object3, object2});
            }
            object3 = DocumentBuilderFactory.newInstance();
            object2 = ((DocumentBuilderFactory)object3).newDocumentBuilder();
            inputStreamReader = new InputStreamReader(new FileInputStream(string));
            object = ((DocumentBuilder)object2).parse(new InputSource(inputStreamReader));
            Element element = object.getDocumentElement();
            Element element2 = this.getChildElement(element, "application");
            Element element3 = object.createElement("uses-permission");
            element3.setAttribute("android:name", WRITE_EXTERNAL_STORAGE_PERMISSION);
            element.insertBefore(element3, element2);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", new Integer(4));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Transformer transformer = transformerFactory.newTransformer();
            Properties properties = transformer.getOutputProperties();
            properties.setProperty("indent", "yes");
            transformer.setOutputProperties(properties);
            DOMSource dOMSource = new DOMSource((Node)object);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            StreamResult streamResult = new StreamResult(new OutputStreamWriter(fileOutputStream));
            transformer.transform(dOMSource, streamResult);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            try {
                throw new Exception("Cannot write 'AndroidManifest.xml' file");
            }
            catch (Throwable throwable) {
                this.closeResources(new Closeable[]{inputStreamReader});
                throw throwable;
            }
        }
        this.closeResources(new Closeable[]{inputStreamReader});
    }

    private String[] getActivityClassName(IProject iProject) throws Exception {
        Object[] objectArray;
        InputStreamReader inputStreamReader = null;
        try {
            String string = iProject.getLocation().toString() + "/AndroidManifest.xml";
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            inputStreamReader = new InputStreamReader(new FileInputStream(string));
            Document document = documentBuilder.parse(new InputSource(inputStreamReader));
            Element element = document.getDocumentElement();
            Element element2 = this.getChildElement(element, "application");
            Element element3 = this.getChildElement(element2, "activity");
            String string2 = element3.getAttribute("android:name");
            if (string2 == null || string2.length() == 0) {
                throw new NullPointerException();
            }
            String string3 = element.getAttribute("package");
            if (string3 != null && string3.length() > 0) {
                string2 = string3 + string2;
            }
            Element[] elementArray = this.getChildElements(element, "uses-permission");
            String string4 = null;
            for (Element element4 : elementArray) {
                String string5 = element4.getAttribute("android:name");
                if (string5 == null || !string5.equals(WRITE_EXTERNAL_STORAGE_PERMISSION)) continue;
                string4 = WRITE_EXTERNAL_STORAGE_PERMISSION;
                break;
            }
            objectArray = new String[]{string2, string4};
        }
        catch (Exception exception) {
            try {
                throw new Exception("Cannot read 'AndroidManifest.xml' file");
            }
            catch (Throwable throwable) {
                this.closeResources(new Closeable[]{inputStreamReader});
                throw throwable;
            }
        }
        this.closeResources(new Closeable[]{inputStreamReader});
        return objectArray;
    }

    private Element getChildElement(Element element, String string) throws NoSuchElementException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(string)) continue;
            return (Element)node;
        }
        throw new NoSuchElementException();
    }

    private Element[] getChildElements(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(string)) continue;
            arrayList.add((Element)node);
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    public void addPages() {
        this.page1 = new HtmlToAndroidPage1();
        this.page1.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new HtmlToAndroidPage2(this.selection);
        this.page2.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.page2);
        this.page2.setPreviousPage((IWizardPage)this.page1);
    }
}

