/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.plugins.editor.IscobolDoubleClickSelector;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.debug.DisplayVariableTextHover;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.VarDecl;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class DisplayCobolElementTextHover
implements ITextHover {
    private IscobolDoubleClickSelector dblClickSelector = new IscobolDoubleClickSelector();
    private IscobolEditor editor;
    private DisplayVariableTextHover displayVarHover;

    public DisplayCobolElementTextHover(IscobolEditor iscobolEditor) {
        this.editor = iscobolEditor;
        this.displayVarHover = new DisplayVariableTextHover(iscobolEditor);
    }

    private SimpleMarkerAnnotation findMarkerAnnotation(ISourceViewer iSourceViewer, int n) {
        try {
            IRegion iRegion = iSourceViewer.getDocument().getLineInformation(n);
            IAnnotationModel iAnnotationModel = iSourceViewer.getAnnotationModel();
            if (iAnnotationModel != null) {
                Iterator iterator = iAnnotationModel.getAnnotationIterator();
                while (iterator.hasNext()) {
                    Position position;
                    Annotation annotation = (Annotation)iterator.next();
                    if (!(annotation instanceof SimpleMarkerAnnotation) || (position = iAnnotationModel.getPosition(annotation)) == null || !position.overlapsWith(iRegion.getOffset(), iRegion.getLength())) continue;
                    return (SimpleMarkerAnnotation)annotation;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        AnnotationModel annotationModel;
        IMarker iMarker;
        Object object;
        String string = this.displayVarHover.getHoverInfo(iTextViewer, iRegion);
        if (string == null) {
            try {
                SimpleMarkerAnnotation simpleMarkerAnnotation = this.findMarkerAnnotation((ISourceViewer)iTextViewer, iTextViewer.getDocument().getLineOfOffset(iRegion.getOffset()));
                if (simpleMarkerAnnotation != null) {
                    string = "______STANDARD_CONTENT_TYPE" + simpleMarkerAnnotation.getText();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (string == null) {
            boolean bl = IscobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.showtooltipmousehover.enabled");
            if (iRegion != null && bl) {
                try {
                    this.dblClickSelector.init(iTextViewer, iRegion.getOffset());
                    if (this.dblClickSelector.matchWord(true)) {
                        int n = this.dblClickSelector.getStartPosition();
                        int n2 = this.dblClickSelector.getEndPosition() - n;
                        if (n2 > 0) {
                            object = iTextViewer.getDocument().get(n, n2).trim();
                            iMarker = this.editor.findSelectedFragment((String)object);
                            string = this.getDescription((IsFragment)iMarker);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (string == null && (annotationModel = (AnnotationModel)this.editor.getViewer().getAnnotationModel()) != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                int n;
                Annotation annotation = (Annotation)iterator.next();
                if (!(annotation instanceof SimpleMarkerAnnotation) || (object = annotationModel.getPosition(annotation)) == null || !object.overlapsWith(iRegion.getOffset(), iRegion.getLength()) || (n = (iMarker = ((SimpleMarkerAnnotation)annotation).getMarker()).getAttribute("severity", 0)) != 2 && n != 1 || (string = iMarker.getAttribute("message", null)) == null) continue;
                string = "______STANDARD_CONTENT_TYPE" + string;
            }
        }
        return string;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        Point point = iTextViewer.getSelectedRange();
        if (point.x <= n && n < point.x + point.y) {
            return new Region(point.x, point.y);
        }
        return new Region(n, 0);
    }

    private String getDescription(IsFragment isFragment) {
        if (isFragment == null) {
            return null;
        }
        if (isFragment instanceof VarDecl) {
            StringBuffer stringBuffer = new StringBuffer("______STANDARD_CONTENT_TYPE");
            VarDecl varDecl = (VarDecl)isFragment;
            int n = varDecl.getLevel();
            if (n < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n + " ");
            stringBuffer.append(varDecl.getName());
            if (varDecl.hasChildren()) {
                stringBuffer.append(" group-item");
            } else if (varDecl.isObjectReference()) {
                stringBuffer.append(" object reference " + varDecl.getTypename());
            } else if (varDecl.getGraphicControlType() >= 0) {
                stringBuffer.append(" ");
                switch (varDecl.getGraphicControlType()) {
                    case 1: {
                        stringBuffer.append("Label");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("Entry-Field");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("Push-Button");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("Check-Box");
                        break;
                    }
                    case 5: {
                        stringBuffer.append("Radio-Button");
                        break;
                    }
                    case 6: {
                        stringBuffer.append("Scroll-Bar");
                        break;
                    }
                    case 7: {
                        stringBuffer.append("List-Box");
                        break;
                    }
                    case 8: {
                        stringBuffer.append("Combo-Box");
                        break;
                    }
                    case 9: {
                        stringBuffer.append("Frame");
                        break;
                    }
                    case 10: {
                        stringBuffer.append("Tab-Control");
                        break;
                    }
                    case 11: {
                        stringBuffer.append("Bar");
                        break;
                    }
                    case 12: {
                        stringBuffer.append("Grid");
                        break;
                    }
                    case 13: {
                        stringBuffer.append("Bitmap");
                        break;
                    }
                    case 14: {
                        stringBuffer.append("Tree-View");
                        break;
                    }
                    case 15: {
                        stringBuffer.append("Web-Browser");
                        break;
                    }
                    case 16: {
                        stringBuffer.append("Ole");
                        break;
                    }
                    case 17: {
                        stringBuffer.append("Status-Bar");
                        break;
                    }
                    case 18: {
                        stringBuffer.append("Slider");
                        break;
                    }
                    case 19: {
                        stringBuffer.append("Java-Bean");
                        break;
                    }
                    case 20: {
                        stringBuffer.append("Date-Entry");
                        break;
                    }
                    default: {
                        stringBuffer.append("Unknown type");
                        break;
                    }
                }
            } else {
                if (varDecl.getPicture() != null) {
                    stringBuffer.append(" pic " + varDecl.getPicture());
                }
                if (varDecl.getUsage() != null) {
                    stringBuffer.append(" " + varDecl.getUsage());
                }
                if (varDecl.getValue() != null) {
                    stringBuffer.append(" value " + varDecl.getValue());
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }
}

