/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.plugins.editor.IscobolSourceViewerConfiguration;
import com.iscobol.plugins.editor.Tokens;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.util.Hashtable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;

public class IscobolAutoEditStrategy
implements IAutoEditStrategy {
    private DefaultIndentLineAutoEditStrategy defaultStrategy = new DefaultIndentLineAutoEditStrategy();
    private IscobolSourceViewerConfiguration configuration;
    private static final String eol = System.getProperty("line.separator", "\n");

    public IscobolAutoEditStrategy(IscobolSourceViewerConfiguration iscobolSourceViewerConfiguration) {
        this.configuration = iscobolSourceViewerConfiguration;
    }

    private boolean isCommentLine(String string, int n) {
        int n2;
        return n > 6 && string.charAt(6) == '*' || (n2 = string.indexOf("*>")) >= 0 && n2 + 1 < n || (n2 = string.indexOf("|")) >= 0 && n2 < n;
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.text.equals("\t") && this.configuration.getEditor().getInsertSpacesForTab()) {
            int n;
            int n2;
            boolean bl = this.configuration.getEditor().isInInsertMode();
            IRegion iRegion = null;
            try {
                iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            int n3 = documentCommand.offset - iRegion.getOffset();
            int[] nArray = this.configuration.getEditor().getTabStops();
            boolean bl2 = false;
            for (n2 = 0; n2 < nArray.length && !bl2; ++n2) {
                n = nArray[n2] - 1 - n3;
                if (n <= 0) continue;
                documentCommand.text = this.getSpaces(n);
                bl2 = true;
            }
            if (!bl2) {
                n2 = nArray.length > 0 ? nArray[nArray.length - 1] : 0;
                int n4 = this.configuration.getEditor().getTabWidth();
                n2 += n4;
                while (!bl2) {
                    n = n2 - 1 - n3;
                    if (n > 0) {
                        documentCommand.text = this.getSpaces(n);
                        bl2 = true;
                    }
                    n2 += n4;
                }
                if (!bl2) {
                    documentCommand.text = this.getSpaces(n2 - n3);
                }
            }
            if (bl) {
                if (PluginUtilities.isAnsiFixedFormat((int)this.configuration.getEditor().getFormat())) {
                    String string = null;
                    String string2 = null;
                    try {
                        string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    if (!this.isCommentLine(string, n3)) {
                        string2 = string.length() > 72 ? string.substring(0, 72) : string;
                        if (n3 < (string2 = string2.replaceAll("\\s*$", "")).length()) {
                            if (string2.length() + documentCommand.text.length() > 72) {
                                documentCommand.doit = false;
                                documentCommand.text = "";
                                documentCommand.length = 0;
                                return;
                            }
                            if (string.length() > 72) {
                                String string3 = documentCommand.text;
                                documentCommand.text = documentCommand.text + string.substring(n3, 72 - string3.length());
                                documentCommand.length = documentCommand.text.length();
                                documentCommand.caretOffset = iRegion.getOffset() + n3 + string3.length();
                            }
                        }
                    }
                }
            } else {
                documentCommand.length = Math.min(documentCommand.text.length(), iRegion.getLength() - n3);
            }
        } else if (documentCommand.text != null && TextUtilities.endsWith((String[])iDocument.getLegalLineDelimiters(), (String)documentCommand.text) == -1) {
            Hashtable hashtable = new Hashtable();
            String string = null;
            int n = 0;
            IRegion iRegion = null;
            try {
                iRegion = iDocument.getLineInformationOfOffset(documentCommand.offset);
                string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                n = documentCommand.offset - iRegion.getOffset();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            int n5 = documentCommand.text.indexOf(eol);
            String string4 = n5 >= 0 && n5 < documentCommand.text.length() ? documentCommand.text.substring(0, n5) : documentCommand.text;
            string = new StringBuffer(string).replace(n, Math.min(n + documentCommand.length, string.length()), string4).toString();
            int n6 = this.configuration.getEditor().getFormat();
            TokenList tokenList = PreProcessor.tokenizer((StringBuffer)new StringBuffer(string), (char)'.', (boolean)false, hashtable);
            String string5 = null;
            int n7 = -1;
            Object object = tokenList.getFirstWithSep();
            while (object != null && string5 == null) {
                if (this.isComment(object.getWord(), object.getOffset(), n6)) {
                    return;
                }
                if (object.getOffset() + object.getWord().length() > n) {
                    string5 = object.getWord();
                    n7 = object.getOffset();
                }
                object = tokenList.getNextWithSep();
            }
            if (string5 == null || n7 == n && documentCommand.length > 0) {
                return;
            }
            object = string5.toUpperCase();
            String string6 = (String)Tokens.endTokens.get(object);
            if (string6 != null) {
                int n8 = 0;
                try {
                }
                catch (BadLocationException badLocationException) {
                    return;
                }
                int n9 = -1;
                int n10 = 0;
                int n11 = n8;
                block15: for (n8 = iDocument.getLineOfOffset(documentCommand.offset); n8 >= 0; --n8) {
                    try {
                        iRegion = iDocument.getLineInformation(n8);
                        string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    tokenList = PreProcessor.tokenizer((StringBuffer)new StringBuffer(string), (char)'.', (boolean)false, hashtable);
                    Token token = tokenList.getFirstWithSep();
                    while (token != null && !this.isComment(token.getWord(), token.getOffset(), n6)) {
                        String string7 = token.getWord().toUpperCase();
                        if (string7.equals(object)) {
                            ++n10;
                        } else if (string7.equals(string6)) {
                            if (n10 == 0) {
                                n9 = token.getOffset();
                                break block15;
                            }
                            --n10;
                        }
                        token = tokenList.getNextWithSep();
                    }
                }
                if (n9 >= 0 && n8 < n11) {
                    int n12 = n9 - n7;
                    if (n12 > 0) {
                        documentCommand.offset -= n - n7;
                        documentCommand.length += n - n7;
                        int n13 = n7 + string5.length() - n;
                        if (n13 >= 0) {
                            if (n13 <= documentCommand.text.length()) {
                                documentCommand.text = this.getSpaces(n12) + string5 + documentCommand.text.substring(n13);
                            } else {
                                documentCommand.length += n13 - documentCommand.text.length();
                                documentCommand.text = this.getSpaces(n12) + string5;
                            }
                        } else {
                            documentCommand.text = this.getSpaces(n12) + string5 + documentCommand.text;
                        }
                    } else if (n12 < 0) {
                        int n14 = n - n7 - n12;
                        int n15 = n7 + string5.length() - n;
                        try {
                            String string8 = iDocument.get(documentCommand.offset - n14, -n12).trim();
                            if (string8.length() > 0) {
                                return;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            return;
                        }
                        documentCommand.offset -= n14;
                        documentCommand.length += n14;
                        if (n15 >= 0) {
                            if (n15 <= documentCommand.text.length()) {
                                documentCommand.text = string5 + documentCommand.text.substring(n15);
                            } else {
                                documentCommand.length += n15 - documentCommand.text.length();
                                documentCommand.text = string5;
                            }
                        } else {
                            documentCommand.text = string5 + documentCommand.text;
                        }
                    }
                }
            }
        } else {
            this.defaultCustomizeDocumentCommand(iDocument, documentCommand);
        }
    }

    private void defaultCustomizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        this.defaultStrategy.customizeDocumentCommand(iDocument, documentCommand);
    }

    private boolean isComment(String string, int n, int n2) {
        return string.startsWith("*>") || string.startsWith("|") || string.equals("*") && n == 0 && PluginUtilities.isTerminalFormat((int)n2) || string.equals("*") && n == 6 && PluginUtilities.isAnsiFixedFormat((int)n2);
    }

    private String getSpaces(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

