/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.plugins.editor.IscobolWordDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class IscobolDoubleClickSelector
implements ITextDoubleClickStrategy {
    protected ITextViewer textViewer;
    protected int position;
    protected int startPosition;
    protected int endPosition;
    protected static char[] fgBrackets = new char[]{'\"', '\"', '\'', '\''};

    public void init(ITextViewer iTextViewer, int n) {
        this.position = n;
        if (this.position < 0) {
            return;
        }
        this.textViewer = iTextViewer;
    }

    public void doubleClicked(ITextViewer iTextViewer) {
        this.init(iTextViewer, iTextViewer.getSelectedRange().x);
        if (!this.selectBracketBlock()) {
            this.selectWord();
        }
    }

    protected boolean matchBracketsAt() {
        int n = fgBrackets.length;
        int n2 = fgBrackets.length;
        this.startPosition = -1;
        this.endPosition = -1;
        try {
            int n3;
            IDocument iDocument = this.textViewer.getDocument();
            char c = iDocument.getChar(this.position - 1);
            char c2 = iDocument.getChar(this.position);
            for (n3 = 0; n3 < fgBrackets.length; n3 += 2) {
                if (c != fgBrackets[n3]) continue;
                this.startPosition = this.position - 1;
                n = n3;
            }
            for (n3 = 1; n3 < fgBrackets.length; n3 += 2) {
                if (c2 != fgBrackets[n3]) continue;
                this.endPosition = this.position;
                n2 = n3;
            }
            if (this.startPosition > -1 && n < n2) {
                this.endPosition = this.searchForClosingBracket(this.startPosition, c, fgBrackets[n + 1], iDocument);
                if (this.endPosition > -1) {
                    return true;
                }
                this.startPosition = -1;
            } else if (this.endPosition > -1) {
                this.startPosition = this.searchForOpenBracket(this.endPosition, fgBrackets[n2 - 1], c2, iDocument);
                if (this.startPosition > -1) {
                    return true;
                }
                this.endPosition = -1;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    public boolean matchWord() {
        return this.matchWord(false);
    }

    public boolean matchWord(boolean bl) {
        IDocument iDocument = this.textViewer.getDocument();
        try {
            char c;
            int n;
            for (n = this.position; n >= 0 && IscobolWordDetector.IsWordPart((char)(c = iDocument.getChar(n))); --n) {
            }
            this.startPosition = n;
            if (bl) {
                ++this.startPosition;
            }
            int n2 = iDocument.getLength();
            for (n = this.position; n < n2 && IscobolWordDetector.IsWordPart((char)(c = iDocument.getChar(n))); ++n) {
            }
            this.endPosition = n;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected int searchForClosingBracket(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        int n2;
        int n3 = 1;
        int n4 = iDocument.getLength();
        for (n2 = n + 1; n2 < n4 && n3 > 0; ++n2) {
            char c3 = iDocument.getChar(n2);
            if (c3 == c && c3 != c2) {
                ++n3;
                continue;
            }
            if (c3 != c2) continue;
            --n3;
        }
        if (n3 == 0) {
            return n2 - 1;
        }
        return -1;
    }

    protected int searchForOpenBracket(int n, char c, char c2, IDocument iDocument) throws BadLocationException {
        int n2;
        int n3 = 1;
        for (n2 = n - 1; n2 >= 0 && n3 > 0; --n2) {
            char c3 = iDocument.getChar(n2);
            if (c3 == c2 && c3 != c) {
                ++n3;
                continue;
            }
            if (c3 != c) continue;
            --n3;
        }
        if (n3 == 0) {
            return n2 + 1;
        }
        return -1;
    }

    protected boolean selectBracketBlock() {
        if (this.matchBracketsAt()) {
            if (this.startPosition == this.endPosition) {
                this.textViewer.setSelectedRange(this.startPosition, 0);
            } else {
                this.textViewer.setSelectedRange(this.startPosition + 1, this.endPosition - this.startPosition - 1);
            }
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.startPosition == this.endPosition) {
                this.textViewer.setSelectedRange(this.startPosition, 0);
            } else {
                this.textViewer.setSelectedRange(this.startPosition + 1, this.endPosition - this.startPosition - 1);
            }
        }
    }

    public ITextViewer getTextViewer() {
        return this.textViewer;
    }

    public int getPosition() {
        return this.position;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }
}

