/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IscobolOutlinePage;
import com.iscobol.plugins.editor.actions.SortAction;
import com.iscobol.plugins.editor.util.IOFileStorage;
import com.iscobol.plugins.editor.util.IOFileStorageEditorInput;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class IscobolOutlinePage
extends ContentOutlinePage {
    public static final String rcsid = "$Id: IscobolOutlinePage.java,v 1.10 2009/03/09 11:14:00 gianni Exp $";
    protected IscobolEditor editor;
    private IsFragment input;
    private MyContentProvider contentProvider;
    private IPropertyChangeListener propchangelist;
    private SortAction sortAction;
    private boolean highlightEditorRange = true;

    public IscobolOutlinePage(IscobolEditor iscobolEditor) {
        this.editor = iscobolEditor;
    }

    public void dispose() {
        if (this.propchangelist != null) {
            IscobolEditorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propchangelist);
        }
        super.dispose();
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        super.selectionChanged(selectionChangedEvent);
        ISelection iSelection = selectionChangedEvent.getSelection();
        IsFragment isFragment = null;
        if (!iSelection.isEmpty()) {
            isFragment = (IsFragment)((IStructuredSelection)iSelection).getFirstElement();
        }
        this.selectionChanged(isFragment, iSelection);
    }

    public void selectionChanged(IsFragment isFragment, ISelection iSelection) {
        if (!this.highlightEditorRange) {
            return;
        }
        if (isFragment != null) {
            IRegion iRegion;
            Object object;
            Object object2;
            Object object3;
            IscobolEditor iscobolEditor = this.editor;
            if (isFragment.getFilename() != null && this.editor.getProject() != null) {
                try {
                    Path path;
                    object3 = PluginUtilities.makeRelative((String)isFragment.getFilename(), (IProject)this.editor.getProject());
                    object2 = new File((String)object3);
                    if (((File)object2).isAbsolute()) {
                        object = ((File)object2).exists() ? new IOFileStorageEditorInput(new IOFileStorage((File)object2, false)) : null;
                    } else {
                        path = new Path((String)object3);
                        iRegion = PluginUtilities.findMember((IContainer)this.editor.getProject(), (IPath)path);
                        object = iRegion instanceof IFile ? new FileEditorInput((IFile)iRegion) : (this.editor.getProject().exists((IPath)path) ? new FileEditorInput(this.editor.getProject().getFile((String)object3)) : null);
                    }
                    if (object != null) {
                        iscobolEditor = (IscobolEditor)this.editor.getEditorSite().getPage().openEditor((IEditorInput)object, IscobolEditor.ID, true, 3);
                        if (this.editor.getProject() != null && iscobolEditor.getProject() == null) {
                            iscobolEditor.setProject(this.editor.getProject());
                        }
                        path = (IscobolOutlinePage)iscobolEditor.getOutlinePage();
                        path.setInput(this.getInput());
                        path.getTreeViewer().setExpandedElements(this.getTreeViewer().getExpandedElements());
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
            object3 = isFragment.getPosition();
            try {
                if (object3 != null) {
                    iscobolEditor.highlight(object3.getOffset(), object3.getLength());
                } else {
                    try {
                        object = iscobolEditor.getViewer().getDocument();
                        object2 = object.getLineInformation(isFragment.getStartLine());
                        int n = isFragment.getEndLine() >= 0 ? isFragment.getEndLine() : object.getNumberOfLines();
                        iRegion = object.getLineInformation(n);
                        iscobolEditor.highlight(object2.getOffset(), iRegion.getOffset() + iRegion.getLength() - object2.getOffset());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                iscobolEditor.highlight(-1, -1);
            }
            if (iscobolEditor.getOutlinePage().getControl() != null) {
                iscobolEditor.getOutlinePage().setFocus();
            }
            if (iscobolEditor != this.editor) {
                object = iscobolEditor;
                new /* Unavailable Anonymous Inner Class!! */.start();
            }
        } else {
            this.editor.resetHighlightRange();
        }
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        TreeViewer treeViewer = this.getTreeViewer();
        this.contentProvider = new MyContentProvider(null);
        treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new MyDecoratingLabelProvider((ILabelProvider)new MyLabelProvider(null), (ILabelDecorator)new MyLabelDecorator(null)));
        this.propchangelist = new /* Unavailable Anonymous Inner Class!! */;
        IscobolEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propchangelist);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setInput(this.input);
    }

    public boolean getHighlightEditorRange() {
        return this.highlightEditorRange;
    }

    public void setHighlightEditorRange(boolean bl) {
        this.highlightEditorRange = bl;
    }

    public IsFragment getInput() {
        return this.input;
    }

    public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
        this.addSortAction(iToolBarManager);
    }

    public void addSortAction(IToolBarManager iToolBarManager) {
        if (this.sortAction == null) {
            this.sortAction = new SortAction();
            this.sortAction.setId("com.iscobol.plugins.editor.actions.SortAction");
            this.sortAction.setChecked(IscobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.outlinesort.enabled"));
            iToolBarManager.add((IAction)this.sortAction);
        }
    }

    public void removeSortAction(IToolBarManager iToolBarManager) {
        if (this.sortAction != null) {
            iToolBarManager.remove(this.sortAction.getId());
            this.sortAction = null;
        }
    }

    public void setInput(IsFragment isFragment) {
        this.input = isFragment;
        this.update();
    }

    protected IsFragment[] getRootNodes(IsFragment isFragment) {
        if (isFragment != null) {
            return new IsFragment[]{isFragment};
        }
        return null;
    }

    public void update() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            if (this.input != null) {
                Control control = treeViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setRedraw(false);
                    if (this.input.getType() == 1) {
                        treeViewer.setAutoExpandLevel(3);
                    } else if (this.input.getType() == 6) {
                        treeViewer.setAutoExpandLevel(5);
                    }
                    treeViewer.setInput((Object)new RootObject(this.getRootNodes(this.input)));
                    control.setRedraw(true);
                }
            } else {
                Control control = treeViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setRedraw(false);
                    treeViewer.setInput((Object)new RootObject(null));
                    control.setRedraw(true);
                }
            }
        }
    }

    static /* synthetic */ MyContentProvider access$300(IscobolOutlinePage iscobolOutlinePage) {
        return iscobolOutlinePage.contentProvider;
    }
}

