/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolProjectionViewer;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class IscobolProjectionViewer
extends ProjectionViewer {
    public static final String rcsid = "$Id: IscobolProjectionViewer.java,v 1.2 2008/10/02 10:14:17 gianni Exp $";
    private IscobolEditor editor;
    private boolean redraw = true;

    public IscobolProjectionViewer(IscobolEditor iscobolEditor, Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n) {
        super(composite, iVerticalRuler, iOverviewRuler, bl, n);
        this.editor = iscobolEditor;
    }

    IscobolEditor getEditor() {
        return this.editor;
    }

    public void setTabsToSpacesConverter(IAutoEditStrategy iAutoEditStrategy) {
    }

    private IRegion getTextBlockFromSelection(ITextSelection iTextSelection) throws BadLocationException {
        IDocument iDocument = this.getDocument();
        int n = iDocument.getLineOffset(iTextSelection.getStartLine());
        int n2 = iTextSelection.getEndLine();
        int n3 = iDocument.getNumberOfLines() > n2 + 1 ? iDocument.getLineOffset(n2 + 1) : iDocument.getLength();
        return new Region(n, n3 - n);
    }

    private int getFirstCompleteLineOfRegion(IRegion iRegion) {
        try {
            IDocument iDocument = this.getDocument();
            int n = iDocument.getLineOfOffset(iRegion.getOffset());
            int n2 = iDocument.getLineOffset(n);
            if (n2 >= iRegion.getOffset()) {
                return n;
            }
            n2 = iDocument.getLineOffset(n + 1);
            return n2 > iRegion.getOffset() + iRegion.getLength() ? -1 : n + 1;
        }
        catch (BadLocationException badLocationException) {
            PluginUtilities.log((Throwable)badLocationException);
            return -1;
        }
    }

    private Object selectContentTypePlugin(String string, Map map) {
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void shiftRight(int n, int n2, String string, boolean bl) {
        try {
            IDocument iDocument = this.getDocument();
            int[] nArray = new int[n2 - n + 1];
            IRegion[] iRegionArray = new IRegion[nArray.length];
            int n3 = bl ? 7 : 0;
            int n4 = 0;
            while (n <= n2) {
                iRegionArray[n4] = iDocument.getLineInformation(n);
                if (bl) {
                    String string2 = iDocument.get(iRegionArray[n4].getOffset(), iRegionArray[n4].getLength());
                    if (string2.length() > 72) {
                        string2 = string2.substring(0, 72);
                    }
                    if (string2.length() > 72 - string.length()) {
                        if (string2.charAt(72 - string.length()) != ' ') return;
                    }
                    nArray[n4] = iRegionArray[n4].getOffset() + n3;
                } else {
                    nArray[n4] = iRegionArray[n4].getOffset() + n3;
                }
                ++n4;
                ++n;
            }
            if (nArray == null) return;
            n4 = 0;
            int n5 = 0;
            while (n5 < nArray.length) {
                if (bl) {
                    if (iRegionArray[n5].getLength() > 72) {
                        iDocument.replace(nArray[n5] + n4, 0, string);
                        iDocument.replace(iRegionArray[n5].getOffset() + n4 + 72, string.length(), "");
                    } else {
                        iDocument.replace(nArray[n5] + n4, 0, string);
                        n4 += string.length();
                    }
                } else {
                    iDocument.replace(nArray[n5] + n4, 0, string);
                    n4 += string.length();
                }
                ++n5;
            }
            return;
        }
        catch (BadLocationException badLocationException) {
            PluginUtilities.log((Throwable)badLocationException);
        }
    }

    private void shiftLeft(int n, int n2, String[] stringArray, boolean bl, boolean bl2) {
        IDocument iDocument = this.getDocument();
        try {
            int n3;
            IRegion[] iRegionArray = new IRegion[n2 - n + 1];
            IRegion[] iRegionArray2 = new IRegion[n2 - n + 1];
            for (n3 = 0; n3 < iRegionArray.length; ++n3) {
                int n4;
                iRegionArray2[n3] = iDocument.getLineInformation(n + n3);
                String string = iDocument.get(iRegionArray2[n3].getOffset(), iRegionArray2[n3].getLength());
                int n5 = -1;
                int n6 = bl2 ? 7 : 0;
                int[] nArray = TextUtilities.indexOf((String[])stringArray, (String)string, (int)n6);
                if (nArray[0] != -1) {
                    if (bl) {
                        String string2 = iDocument.get(iRegionArray2[n3].getOffset(), nArray[0]);
                        if ((string2 = string2.trim()).length() == 0) {
                            n5 = iRegionArray2[n3].getOffset() + nArray[0];
                        }
                    } else if (nArray[0] == n6) {
                        n5 = iRegionArray2[n3].getOffset() + n6;
                    }
                }
                if (n5 > -1) {
                    n4 = stringArray[nArray[1]].length();
                    if (n4 == 0 && !bl && iRegionArray2[n3].getLength() > 0) {
                        return;
                    }
                } else {
                    return;
                }
                iRegionArray[n3] = new Region(n5, n4);
            }
            n3 = 0;
            for (int i = 0; i < iRegionArray.length; ++i) {
                IRegion iRegion = iRegionArray[i];
                iDocument.replace(iRegion.getOffset() - n3, iRegion.getLength(), "");
                if (bl2 && iRegionArray2[i].getLength() > 72) {
                    iDocument.replace(iRegionArray2[i].getOffset() - n3 + 72, 0, this.spaces(iRegion.getLength()));
                    continue;
                }
                n3 += iRegion.getLength();
            }
        }
        catch (BadLocationException badLocationException) {
            PluginUtilities.log((Throwable)badLocationException);
        }
    }

    private String spaces(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void standardShift(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        block17: {
            ITextSelection iTextSelection;
            DocumentRewriteSession documentRewriteSession;
            IDocument iDocument;
            block16: {
                if (this.fUndoManager != null) {
                    this.fUndoManager.beginCompoundChange();
                }
                iDocument = this.getDocument();
                Map map = null;
                documentRewriteSession = null;
                try {
                    int n;
                    int n2;
                    iTextSelection = (ITextSelection)this.getSelection();
                    IRegion iRegion = this.getTextBlockFromSelection(iTextSelection);
                    ITypedRegion[] iTypedRegionArray = TextUtilities.computePartitioning((IDocument)iDocument, (String)this.getDocumentPartitioning(), (int)iRegion.getOffset(), (int)iRegion.getLength(), (boolean)false);
                    int n3 = 0;
                    int[] nArray = new int[iTypedRegionArray.length * 2];
                    int n4 = 0;
                    int n5 = 0;
                    while (n4 < iTypedRegionArray.length) {
                        nArray[n5] = this.getFirstCompleteLineOfRegion((IRegion)iTypedRegionArray[n4]);
                        n2 = iTypedRegionArray[n4].getLength();
                        n = iTypedRegionArray[n4].getOffset() + n2;
                        if (n2 > 0) {
                            --n;
                        }
                        nArray[n5 + 1] = nArray[n5] == -1 ? -1 : iDocument.getLineOfOffset(n);
                        n3 += nArray[n5 + 1] - nArray[n5] + 1;
                        ++n4;
                        n5 += 2;
                    }
                    IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                    documentRewriteSession = iDocumentExtension4.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                    if (n3 >= 20) {
                        map = TextUtilities.removeDocumentPartitioners((IDocument)iDocument);
                    }
                    Map map2 = bl ? this.fDefaultPrefixChars : this.fIndentChars;
                    n2 = 0;
                    n = 0;
                    while (n2 < iTypedRegionArray.length) {
                        String[] stringArray = (String[])this.selectContentTypePlugin(iTypedRegionArray[n2].getType(), map2);
                        if (stringArray != null && stringArray.length > 0 && nArray[n] >= 0 && nArray[n + 1] >= 0) {
                            if (bl2) {
                                this.shiftRight(nArray[n], nArray[n + 1], stringArray[0], bl4);
                            } else {
                                this.shiftLeft(nArray[n], nArray[n + 1], stringArray, bl3, bl4);
                            }
                        }
                        ++n2;
                        n += 2;
                    }
                    if (map == null) break block16;
                }
                catch (BadLocationException badLocationException) {
                    PluginUtilities.log((Throwable)badLocationException);
                    break block17;
                }
                finally {
                    if (map != null) {
                        TextUtilities.addDocumentPartitioners((IDocument)iDocument, map);
                    }
                    IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                    iDocumentExtension4.stopRewriteSession(documentRewriteSession);
                    if (this.fUndoManager != null) {
                        this.fUndoManager.endCompoundChange();
                    }
                }
                TextUtilities.addDocumentPartitioners((IDocument)iDocument, (Map)map);
            }
            iTextSelection = (IDocumentExtension4)iDocument;
            iTextSelection.stopRewriteSession(documentRewriteSession);
            if (this.fUndoManager != null) {
                this.fUndoManager.endCompoundChange();
            }
        }
    }

    protected void updateTextListeners(TextViewer.WidgetCommand widgetCommand) {
        if (this.redraw) {
            super.updateTextListeners(widgetCommand);
        }
    }

    private void customShiftLeft(boolean bl) {
        int n;
        int n2 = this.getTextWidget().getSelection().x;
        int n3 = 1;
        IRegion iRegion = null;
        String string = null;
        IDocument iDocument = this.getDocument();
        try {
            iRegion = iDocument.getLineInformationOfOffset(n2);
            n3 = n2 - iRegion.getOffset();
            string = this.getDocument().get(iRegion.getOffset(), iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        int[] nArray = this.editor.getTabStops();
        int n4 = 0;
        for (n = nArray.length - 1; n >= 0 && n4 == 0; --n) {
            if (nArray[n] - 1 >= n3) continue;
            n4 = nArray[n] - 1;
        }
        if (nArray.length > 0 && n4 == nArray[nArray.length - 1] - 1) {
            n = this.editor.getTabWidth();
            while (n3 > n4 + n) {
                n4 += n;
            }
        }
        for (n = n3 - 1; n >= 0 && string.charAt(n) == ' '; --n) {
        }
        int n5 = Math.max(n4, n + 1);
        if (bl && n5 <= 6) {
            return;
        }
        int n6 = n3 - n5;
        if (n6 > 0) {
            IUndoManager iUndoManager = this.getUndoManager();
            iUndoManager.beginCompoundChange();
            try {
                if (bl) {
                    iDocument.replace(iRegion.getOffset() + n5, n6, "");
                    if (string.length() > 72) {
                        iDocument.replace(iRegion.getOffset() + 72 - n6, 0, this.spaces(n6));
                    }
                } else {
                    iDocument.replace(iRegion.getOffset() + n5, n6, "");
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            iUndoManager.endCompoundChange();
        }
    }

    protected void shift(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = PluginUtilities.isAnsiFixedFormat((int)this.editor.getFormat());
        if (bl2 || this.getTextWidget().getSelectionCount() > 0) {
            this.standardShift(bl, bl2, bl3, bl4);
        } else {
            this.customShiftLeft(bl4);
        }
    }

    protected StyledText createTextWidget(Composite composite, int n) {
        return new MyStyledText(this, composite, n);
    }

    public void setDocument(IDocument iDocument, IAnnotationModel iAnnotationModel, int n, int n2) {
        if (iAnnotationModel == null) {
            iAnnotationModel = new AnnotationModel();
        }
        super.setDocument(iDocument, iAnnotationModel, n, n2);
    }

    protected void addMyLineBackgroundListener(LineBackgroundListener lineBackgroundListener) {
        ((MyStyledText)this.getTextWidget()).addMyLineBackgroundListener(lineBackgroundListener);
    }

    public int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return super.findAndSelect(n, string, bl, bl2, bl3, bl4);
    }

    public void mySetRedraw(boolean bl) {
        if (this.redraw != bl) {
            this.redraw = bl;
            if (this.redraw && this.getTextWidget() != null) {
                this.getTextWidget().redraw();
            }
        }
    }

    static /* synthetic */ boolean access$000(IscobolProjectionViewer iscobolProjectionViewer) {
        return iscobolProjectionViewer.redraw;
    }

    static /* synthetic */ IscobolEditor access$100(IscobolProjectionViewer iscobolProjectionViewer) {
        return iscobolProjectionViewer.editor;
    }
}

