/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.actions;

import com.iscobol.plugins.editor.dialogs.SetCurrentModeDialog;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class ChangeModeAction
extends Action {
    private IProject selectedProject;
    private Shell shell;

    public void run() {
        if (this.selectedProject == null || this.shell == null) {
            return;
        }
        String[] stringArray = PluginUtilities.getSettingModes((IResource)this.selectedProject);
        String string = PluginUtilities.getCurrentSettingMode((IResource)this.selectedProject);
        SetCurrentModeDialog setCurrentModeDialog = new SetCurrentModeDialog(this.shell, this.selectedProject.getName(), stringArray, string);
        String string2 = setCurrentModeDialog.openDialog();
        if (string2 != null && !string2.equals(string)) {
            PluginUtilities.setCurrentSettingMode((String)string2, (IResource)this.selectedProject);
            PluginUtilities.saveProjectOptions((IProject)this.selectedProject);
        }
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IResource iResource;
        IEditorPart iEditorPart;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            this.selectedProject = this.getIscobolProject((IStructuredSelection)iSelection);
        }
        if (this.selectedProject == null && (iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && iEditorPart.getEditorInput() != null && (iResource = (IResource)iEditorPart.getEditorInput().getAdapter(IResource.class)) != null) {
            this.selectedProject = iResource.getProject();
        }
        if (this.selectedProject != null) {
            iAction.setEnabled(true);
        } else {
            iAction.setEnabled(false);
        }
    }

    private IProject getIscobolProject(IStructuredSelection iStructuredSelection) {
        IProject iProject = null;
        try {
            iProject = (IProject)PluginUtilities.castOrAdapt((Object)iStructuredSelection.getFirstElement(), IProject.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (iProject != null) {
            try {
                if (iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null) {
                    return iProject;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void setShell(Shell shell) {
        this.shell = shell;
    }

    protected IProject getSelectedProject() {
        return this.selectedProject;
    }
}

