/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.actions;

import com.iscobol.plugins.editor.actions.ChangeModeAction;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.SettingModeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

public class ChangeModeWindowActionDelegate
extends ChangeModeAction
implements IWorkbenchWindowActionDelegate,
IWorkbenchWindowPulldownDelegate2,
SettingModeListener {
    private Menu toolMenu;
    private Menu popupMenu;

    public ChangeModeWindowActionDelegate() {
        PluginUtilities.addSettingModeListener((SettingModeListener)this);
    }

    public void dispose() {
        if (this.toolMenu != null && !this.toolMenu.isDisposed()) {
            this.toolMenu.dispose();
        }
        if (this.popupMenu != null && !this.popupMenu.isDisposed()) {
            this.popupMenu.dispose();
        }
        PluginUtilities.removeSettingModeListener((SettingModeListener)this);
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.setShell(iWorkbenchWindow.getShell());
    }

    public Menu getMenu(Control control) {
        if (this.toolMenu != null && !this.toolMenu.isDisposed()) {
            this.toolMenu.dispose();
        }
        this.toolMenu = new Menu(control);
        this.fillMenu(this.toolMenu);
        return this.toolMenu;
    }

    private void fillMenu(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            menuItemArray[i].dispose();
        }
        IProject iProject = this.getSelectedProject();
        if (iProject != null) {
            String[] stringArray = PluginUtilities.getSettingModes((IResource)iProject);
            String string = PluginUtilities.getCurrentSettingMode((IResource)iProject);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("Default")) continue;
                MenuItem menuItem = new MenuItem(menu, 16);
                String string2 = stringArray[i];
                menuItem.setText(string2);
                menuItem.setSelection(string2.equals(string));
                menuItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public Menu getMenu(Menu menu) {
        if (this.popupMenu != null && !this.popupMenu.isDisposed()) {
            this.popupMenu.dispose();
        }
        this.popupMenu = new Menu(menu);
        this.fillMenu(this.popupMenu);
        return this.popupMenu;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        super.selectionChanged(iAction, iSelection);
        this.updateMenus();
    }

    private void updateMenus() {
        if (this.toolMenu != null && !this.toolMenu.isDisposed()) {
            this.fillMenu(this.toolMenu);
        }
        if (this.popupMenu != null && !this.popupMenu.isDisposed()) {
            this.fillMenu(this.popupMenu);
        }
    }

    public void settingModeAdded(String string, IResource iResource) {
        if (iResource == this.getSelectedProject()) {
            this.updateMenus();
        }
    }

    public void settingModeRemoved(String string, IResource iResource) {
        if (iResource == this.getSelectedProject()) {
            this.updateMenus();
        }
    }
}

