/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.actions;

import com.iscobol.plugins.editor.IscobolEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public abstract class FormatTextAction
extends Action
implements IEditorActionDelegate {
    protected IEditorPart editor;
    protected int[][] selectionRanges;
    private TextViewer viewer;

    public FormatTextAction() {
    }

    public FormatTextAction(String string, String string2, ImageDescriptor imageDescriptor) {
        this.setText(string);
        this.setToolTipText(string2);
        this.setImageDescriptor(imageDescriptor);
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.editor = iEditorPart;
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void run() {
        this.getSelectionRanges();
        TextViewer textViewer = this.viewer;
        int[][] nArray = this.selectionRanges;
        if (textViewer != null && nArray != null) {
            String[] stringArray = new String[nArray.length];
            StyledText styledText = textViewer.getTextWidget();
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = nArray[i][1] > 0 ? styledText.getText(nArray[i][0], nArray[i][0] + nArray[i][1] - 1) : "";
            }
            String[] stringArray2 = this.formatText(stringArray);
            if (stringArray2 != null) {
                IUndoManager iUndoManager = textViewer.getUndoManager();
                iUndoManager.beginCompoundChange();
                for (int i = 0; i < nArray.length && i < stringArray2.length; ++i) {
                    if (nArray[i][1] <= 0) continue;
                    styledText.replaceTextRange(nArray[i][0], nArray[i][1], stringArray2[i]);
                }
                iUndoManager.endCompoundChange();
            }
        }
    }

    protected abstract String[] formatText(String[] var1);

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.getSelectionRanges();
        iAction.setEnabled(this.viewer != null && this.selectionRanges != null);
    }

    private void getSelectionRanges() {
        IscobolEditor iscobolEditor;
        this.viewer = this.editor != null ? (this.editor instanceof IscobolEditor ? ((IscobolEditor)this.editor).getViewer() : ((iscobolEditor = (IscobolEditor)this.editor.getAdapter(IscobolEditor.class)) != null ? iscobolEditor.getViewer() : null)) : null;
        if (this.viewer == null) {
            this.selectionRanges = null;
            return;
        }
        iscobolEditor = this.viewer.getTextWidget();
        if (iscobolEditor.getSelectionCount() > 0) {
            try {
                int[] nArray = (int[])iscobolEditor.getClass().getMethod("getSelectionRanges", new Class[0]).invoke((Object)iscobolEditor, new Object[0]);
                this.selectionRanges = new int[nArray.length / 2][2];
                int n = 0;
                int n2 = 0;
                while (n < nArray.length) {
                    this.selectionRanges[n2][0] = nArray[n++];
                    this.selectionRanges[n2][1] = nArray[n++];
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                Point point = iscobolEditor.getSelectionRange();
                this.selectionRanges = new int[][]{{point.x, point.y}};
            }
        } else {
            this.viewer = null;
            this.selectionRanges = null;
        }
    }
}

