/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.actions;

import com.iscobol.plugins.editor.builder.EdbiisBuilder;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class LaunchEdbiisAction
extends Action
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private IProject selectedProject;
    private Shell shell;

    public void run() {
        if (this.selectedProject == null || this.shell == null) {
            return;
        }
        EdbiisBuilder edbiisBuilder = new EdbiisBuilder(this.selectedProject);
        try {
            edbiisBuilder.build(this.shell);
        }
        catch (Exception exception) {
            PluginUtilities.log((Throwable)exception);
        }
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IResource iResource;
        IEditorPart iEditorPart;
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            this.selectedProject = this.getIscobolProject((IStructuredSelection)iSelection);
        }
        if (this.selectedProject == null && (iEditorPart = PluginUtilities.getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null && iEditorPart.getEditorInput() != null && (iResource = (IResource)iEditorPart.getEditorInput().getAdapter(IResource.class)) != null) {
            this.selectedProject = iResource.getProject();
        }
        if (this.selectedProject != null) {
            iAction.setEnabled(true);
        } else {
            iAction.setEnabled(false);
        }
    }

    private IProject getIscobolProject(IStructuredSelection iStructuredSelection) {
        IProject iProject = null;
        try {
            iProject = (IProject)PluginUtilities.castOrAdapt((Object)iStructuredSelection.getFirstElement(), IProject.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (iProject != null) {
            try {
                if (iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") != null) {
                    return iProject;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    protected IProject getSelectedProject() {
        return this.selectedProject;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.shell = iWorkbenchWindow.getShell();
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.shell = iWorkbenchPart.getSite().getShell();
    }
}

