/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.actions;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.actions.IscobolEditorAction;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.dialogs.QuickWatchDialog;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;

/*
 * Exception performing whole class analysis ignored.
 */
public class QuickWatchAction
extends IscobolEditorAction {
    public static final String ID = "com.iscobol.plugins.editor.actions.QuickWatchAction";

    public QuickWatchAction(IscobolEditor iscobolEditor) {
        super(IsresourceBundle.getBundle(), "quickWatchAction.", 1, iscobolEditor);
    }

    public void update() {
        this.setEnabled(IscobolDebugTarget.getDefault() != null && IscobolDebugTarget.getDefault().isSuspended());
    }

    public void run() {
        String[] stringArray;
        IscobolEditor iscobolEditor = this.getIscobolEditor();
        IDocument iDocument = iscobolEditor.getViewer().getDocument();
        int n = iscobolEditor.getViewer().getTextWidget().getCaretOffset();
        String string = null;
        int n2 = -1;
        try {
            n2 = iDocument.getLineOfOffset(n);
            stringArray = iDocument.getLineInformation(n2);
            string = iDocument.get(stringArray.getOffset(), stringArray.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        stringArray = null;
        if (string != null) {
            stringArray = this.getItemsToAdd(string);
        }
        TextSelection textSelection = this.getSelection();
        QuickWatchDialog quickWatchDialog = new QuickWatchDialog(iscobolEditor.getEditorSite().getShell(), textSelection.getText(), stringArray);
        quickWatchDialog.open();
    }

    private String[] getItemsToAdd(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            if (" =():\".,".indexOf(string.charAt(i)) != -1 || (string2 = PluginUtilities.findVariableName((String)string, (int)i, (boolean)false)) == null || !QuickWatchAction.checkWord((String)(string2 = string2.trim()))) continue;
            i += string2.length();
            DebugResponse debugResponse = this.displayVar(string2);
            if (debugResponse == null || debugResponse.getReturnCode() != 0) continue;
            arrayList.add(0, debugResponse.getVarName());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private DebugResponse displayVar(String string) {
        if (string != null && string.length() > 0) {
            return IscobolDebugTarget.getDefault().processCommand("display " + string);
        }
        return null;
    }

    private static boolean checkWord(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c)) continue;
            return true;
        }
        return false;
    }
}

