/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.actions;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.TraceOffCommand;
import com.iscobol.debugger.commands.TraceOnCommand;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.actions.VariableAction;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.dialogs.TraceDialog;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TraceAction
extends VariableAction {
    public static final String rcsid = "$Id: TraceAction.java,v 1.6 2008/02/27 14:39:54 gianni Exp $";

    public TraceAction() {
        super("traceAction.", 2);
    }

    public void handleDebugEvents(DebugEvent[] debugEventArray) {
        Object object;
        super.handleDebugEvents(debugEventArray);
        if (debugEventArray.length > 0 && (object = debugEventArray[0].getSource()) instanceof IscobolDebugTarget && debugEventArray[0].getKind() == 8) {
            this.proxy.setChecked(false);
        }
    }

    public void run() {
        if (this.proxy.isChecked()) {
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (iWorkbenchWindow == null) {
                this.proxy.setChecked(false);
                return;
            }
            TraceDialog traceDialog = new TraceDialog(iWorkbenchWindow.getShell(), IsresourceBundle.getString((String)"start_tr_title"));
            traceDialog.open();
            TraceOnCommand traceOnCommand = traceDialog.getCommand();
            if (traceOnCommand != null) {
                DebugResponse debugResponse = IscobolDebugTarget.getDefault().processCommand((DebugCommand)traceOnCommand);
                if (debugResponse.getReturnCode() != 0) {
                    PluginUtilities.logError((String)debugResponse.getMessage().substring(2));
                    this.proxy.setChecked(false);
                }
            } else {
                this.proxy.setChecked(false);
            }
        } else {
            DebugResponse debugResponse = IscobolDebugTarget.getDefault().processCommand((DebugCommand)new TraceOffCommand());
            if (debugResponse.getReturnCode() != 0) {
                PluginUtilities.logError((String)debugResponse.getMessage().substring(2));
                this.proxy.setChecked(true);
            }
        }
    }
}

