/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.builder;

import com.iscobol.compiler.ErrorInCompilationException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.builder.EdbiisBuilder;
import com.iscobol.plugins.editor.preferences.EasyDBOptionList;
import com.iscobol.plugins.editor.util.InternalErrorException;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IOConsole;

/*
 * Exception performing whole class analysis ignored.
 */
public class EdbiisBuilder {
    private static final String eol = System.getProperty("line.separator", "\n");
    private static final Set<String> excludedOptionKeys;
    private IProject project;

    public EdbiisBuilder(IProject iProject) {
        this.project = iProject;
    }

    public void build(IProgressMonitor iProgressMonitor) throws CoreException {
        this.build(null, iProgressMonitor);
    }

    public void build(Shell shell) throws CoreException {
        this.build(shell, null);
    }

    private void build(Shell shell, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        Object object2;
        IResource[] iResourceArray;
        String string = PluginUtilities.getCurrentSettingMode((IResource)this.project);
        String string2 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)string, (String)"-efo=");
        IFolder iFolder = null;
        if (string2 == null || string2.equals("___iscobol.option.false")) {
            iResourceArray = PluginUtilities.getPersistentProperty((IResource)this.project, (String)string, (String)"-efd");
            if (iResourceArray != null && iResourceArray.equals("___iscobol.option.true")) {
                iFolder = PluginUtilities.getSourceFolder((IProject)this.project);
            }
        } else {
            iFolder = this.project.getFolder((IPath)new Path(string2));
        }
        if (iFolder == null || !iFolder.exists()) {
            throw new InternalErrorException("EdbiisBuilder: XML folder not found");
        }
        iResourceArray = iFolder.members();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < iResourceArray.length; ++i) {
            if (iResourceArray[i].getType() != 1 || (object2 = (IFile)iResourceArray[i]).getFileExtension() == null || !object2.getFileExtension().equals("xml")) continue;
            arrayList.add(object2);
        }
        if (arrayList.size() == 0) {
            return;
        }
        String string3 = IscobolEditorPlugin.getStringFromStore((String)"iscobol.easydb.exec");
        object2 = new File(string3);
        if (!(((File)object2).exists() && ((File)object2).isFile() && ((File)object2).canExecute())) {
            throw new InternalErrorException("Invalid EasyDB Executable Path: '" + string3 + "'. Please check it in 'Window/Preferences/isCOBOL/Database Bridge'");
        }
        String string4 = IscobolEditorPlugin.getStringFromStore((String)"easydb.-ld");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(string3);
        if (string4 != null && string4.length() > 0) {
            arrayList2.add("-ld=" + string4);
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String[] stringArray = EasyDBOptionList.getDatabaseOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            object = PluginUtilities.getPersistentProperty((IResource)this.project, (String)"Default", (String)("easydb." + stringArray[i]));
            if (object == null || !((String)object).equals("___iscobol.option.true")) continue;
            arrayList3.add(stringArray[i]);
        }
        String string5 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)"Default", (String)"easydb.Generic");
        if (string5 != null && string5.equals("___iscobol.option.true")) {
            arrayList3.add("Generic");
        }
        object = this.getEDBOptions(EasyDBOptionList.getGenericOptions());
        ArrayList arrayList4 = this.getEDBOptions(EasyDBOptionList.getOracleOptions());
        ArrayList arrayList5 = this.getEDBOptions(EasyDBOptionList.getSqlServerOptions());
        arrayList2.addAll((Collection<String>)object);
        String string6 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)string, (String)"-dx");
        if (string6 == null || string6.equals("___iscobol.option.false")) {
            string6 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)string, (String)"-d");
        }
        if (shell != null) {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
            try {
                progressMonitorDialog.run(true, true, (IRunnableWithProgress)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            this.build(arrayList2, arrayList4, arrayList5, arrayList3, arrayList, iProgressMonitor);
        }
        this.project.refreshLocal(2, null);
    }

    private ArrayList<String> getEDBOptions(String[] stringArray) throws CoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = PluginUtilities.getPersistentProperty((IResource)this.project, (String)"Default", (String)("easydb." + stringArray[i]));
            if (string == null || string.equals("___iscobol.option.false")) continue;
            if (EasyDBOptionList.hasValue((String)stringArray[i])) {
                File file;
                if (EasyDBOptionList.isFolder((String)stringArray[i]) && !(file = new File(string)).isAbsolute()) {
                    string = PluginUtilities.getProjectRootDir((IProject)this.project) + File.separator + string;
                }
                arrayList.add(stringArray[i] + "=" + string);
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    private IFolder createFolder(IContainer iContainer, String string) {
        IFolder iFolder = iContainer.getFolder((IPath)new Path(string));
        if (!iFolder.exists()) {
            PluginUtilities.createFolder((IFolder)iFolder);
        }
        return iFolder;
    }

    private static ArrayList<String> getOptionList(IProject iProject, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = OptionList.getAllOptionKeys((boolean)false);
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement().toString();
            if (excludedOptionKeys.contains(string3) || (string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)string3)) == null || string2.equals("___iscobol.option.false")) continue;
            if (OptionList.valueIsDirectory((String)string3) || OptionList.valueIsPath((String)string3)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(PluginUtilities.buildAbsolutePathList((String)string2, (IProject)iProject));
                arrayList.add(string3 + stringBuffer.toString());
                continue;
            }
            if (OptionList.hasValue((String)string3)) {
                arrayList.add(string3 + string2);
                continue;
            }
            arrayList.add(string3);
        }
        return arrayList;
    }

    private void build(ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, ArrayList<String> arrayList4, ArrayList<IFile> arrayList5, IProgressMonitor iProgressMonitor) throws CoreException {
        ArrayList arrayList6 = EdbiisBuilder.getOptionList((IProject)this.project, (String)PluginUtilities.getCurrentSettingMode((IResource)this.project));
        String string = PluginUtilities.getProjectRootDir((IProject)this.project) + File.separator + "edbiis-output" + File.separator;
        IFolder iFolder = this.createFolder((IContainer)this.project, "edbiis-output");
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask("Launch Edbiis", arrayList5.size() * (arrayList4.size() + 1));
        }
        ArrayList<String> arrayList7 = new ArrayList<String>();
        for (int i = 0; i < arrayList4.size(); ++i) {
            String string2;
            String string3;
            ArrayList<String> arrayList8 = new ArrayList<String>();
            arrayList8.addAll(arrayList);
            String string4 = arrayList4.get(i);
            if (string4.equals("Generic")) {
                string3 = "Generic DB";
                string2 = "generic";
            } else {
                string3 = EasyDBOptionList.getDescription((String)string4);
                string2 = EasyDBOptionList.getDatabaseFolderName((String)string4);
            }
            if (string4.equals("-do")) {
                arrayList8.addAll(arrayList2);
            } else if (string4.equals("-ds")) {
                arrayList8.addAll(arrayList3);
            }
            IFolder iFolder2 = this.createFolder((IContainer)iFolder, string2);
            IFolder iFolder3 = this.createFolder((IContainer)iFolder2, "source");
            IFolder iFolder4 = this.createFolder((IContainer)iFolder2, "classes");
            this.createFolder((IContainer)iFolder2, "sql");
            IFolder iFolder5 = this.createFolder((IContainer)iFolder2, "copy");
            for (int j = 0; j < arrayList5.size(); ++j) {
                if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ArrayList<String> arrayList9 = new ArrayList<String>();
                arrayList9.addAll(arrayList8);
                IFile iFile = arrayList5.get(j);
                if (!this.needsGeneration(iFile, iFolder3)) continue;
                if (!string4.equals("Generic")) {
                    arrayList9.add(string4);
                }
                arrayList9.add("-od=" + string + File.separator + string2 + File.separator + "source");
                arrayList9.add("-oc=" + string + File.separator + string2 + File.separator + "copy");
                arrayList9.add("-os=" + string + File.separator + string2 + File.separator + "sql");
                arrayList9.add(iFile.getLocation().toOSString());
                if (iProgressMonitor != null) {
                    iProgressMonitor.subTask("Generate " + iFile.getName() + " for " + string3 + "...");
                }
                Process process = DebugPlugin.exec((String[])arrayList9.toArray(new String[arrayList9.size()]), null);
                StringWriter stringWriter = EdbiisBuilder.redirOutputToConsole((IOConsole)IscobolEditorPlugin.getDefault().getConsole(), (InputStream)process.getErrorStream());
                int n = -1;
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n == 0) {
                    iFolder3.refreshLocal(1, null);
                    IFile iFile2 = this.findGeneratedFile(iFile.getName(), iFolder3);
                    if (iFile2 != null) {
                        String string5 = this.compileCobolSource(iFile2.getLocation().toOSString(), iFolder5, arrayList6, iFolder4);
                        if (string5 != null) {
                            arrayList7.add(string5);
                        }
                    } else {
                        PluginUtilities.log((String)("Error executing Edbiis with '" + iFile.getName() + "':" + eol + stringWriter));
                    }
                } else {
                    PluginUtilities.log((String)("Error executing Edbiis with '" + iFile.getName() + "':" + eol + stringWriter));
                }
                if (iProgressMonitor == null) continue;
                iProgressMonitor.worked(1);
            }
            this.compileJavaSources(arrayList7);
            arrayList7.clear();
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(arrayList5.size());
            iProgressMonitor.done();
        }
    }

    private void compileJavaSources(ArrayList<String> arrayList) throws CoreException {
        if (arrayList.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(IscobolEditorPlugin.getDefault().getJavacCompiler());
        arrayList2.add("-classpath");
        arrayList2.add(PluginUtilities.getIscobolLibraryPath());
        arrayList2.addAll(arrayList);
        Process process = DebugPlugin.exec((String[])arrayList2.toArray(new String[arrayList2.size()]), null);
        EdbiisBuilder.redirOutputToConsole((IOConsole)IscobolEditorPlugin.getDefault().getConsole(), (InputStream)process.getErrorStream());
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            new File(arrayList.get(i)).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String compileCobolSource(String string, IFolder iFolder, ArrayList<String> arrayList, IFolder iFolder2) throws CoreException {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        IOConsoleForwarderOutputStream iOConsoleForwarderOutputStream = new IOConsoleForwarderOutputStream(IscobolEditorPlugin.getDefault().getConsole());
        System.setOut(new PrintStream((OutputStream)iOConsoleForwarderOutputStream));
        System.setErr(new PrintStream((OutputStream)iOConsoleForwarderOutputStream));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(arrayList);
        arrayList2.add("-jj");
        arrayList2.add("-sa");
        StringBuffer stringBuffer = new StringBuffer("-sp=");
        stringBuffer.append(iFolder.getLocation().toOSString());
        IContainer[] iContainerArray = PluginUtilities.getCopyFolders((IProject)this.project, (String)PluginUtilities.getCurrentSettingMode((IResource)this.project));
        for (int i = 0; i < iContainerArray.length; ++i) {
            stringBuffer.append(File.pathSeparator).append(iContainerArray[i].getLocation().toOSString());
        }
        arrayList2.add(stringBuffer.toString());
        arrayList2.add("-od=" + iFolder2.getLocation().toOSString());
        arrayList2.add(string);
        OptionList optionList = new OptionList(arrayList2.toArray(new String[arrayList2.size()]));
        try {
            Pcc pcc = Pcc.run((String)string, (String)(iFolder2.getLocation().toOSString() + File.separator), (OptionList)optionList, (String)null, (Errors)new Errors(), (Reader)null, (boolean)true, null);
            String string2 = iFolder2.getLocation().toOSString() + File.separator + pcc.getClassName() + ".java";
            return string2;
        }
        catch (ErrorInCompilationException errorInCompilationException) {
            Vector vector = errorInCompilationException.pcc.getErrors().getAllMessages();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("Error compiling '" + new File(string).getName() + "':");
            for (Object e : vector) {
                if (!e.toString().startsWith("--S: ")) continue;
                printWriter.println(e);
            }
            printWriter.close();
            PluginUtilities.log((String)stringWriter.toString());
            Iterator iterator = null;
            return iterator;
        }
        finally {
            System.setOut(printStream);
            System.setErr(printStream2);
            try {
                iOConsoleForwarderOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean needsGeneration(IFile iFile, IFolder iFolder) throws CoreException {
        IFile iFile2 = this.findGeneratedFile(iFile.getName(), iFolder);
        return iFile2 == null || iFile2.getModificationStamp() < iFile.getModificationStamp();
    }

    private IFile findGeneratedFile(String string, IFolder iFolder) throws CoreException {
        string = new Path(string).removeFileExtension().toString();
        IResource[] iResourceArray = iFolder.members();
        for (int i = 0; i < iResourceArray.length; ++i) {
            if (iResourceArray[i].getType() != 1) continue;
            IFile iFile = (IFile)iResourceArray[i];
            String string2 = new Path(iFile.getName()).removeFileExtension().toString();
            if (string2.startsWith("EDBI-")) {
                string2 = string2.substring(5);
            }
            if (!string2.equals(string)) continue;
            return iFile;
        }
        return null;
    }

    private static StringWriter redirOutputToConsole(IOConsole iOConsole, InputStream inputStream) {
        StringWriter stringWriter = new StringWriter();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return stringWriter;
    }

    static /* synthetic */ void access$000(EdbiisBuilder edbiisBuilder, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, IProgressMonitor iProgressMonitor) throws CoreException {
        edbiisBuilder.build(arrayList, arrayList2, arrayList3, arrayList4, arrayList5, iProgressMonitor);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("-cax");
        hashSet.add("-ce=");
        hashSet.add("-cfl");
        hashSet.add("-coe");
        hashSet.add("-ef");
        hashSet.add("-efc");
        hashSet.add("-efd");
        hashSet.add("-efo=");
        hashSet.add("-eo=");
        hashSet.add("-es");
        hashSet.add("-exec=");
        hashSet.add("-flsu");
        hashSet.add("-fsv");
        hashSet.add("-g");
        hashSet.add("-help");
        hashSet.add("-helpx");
        hashSet.add("-jj");
        hashSet.add("-jc");
        hashSet.add("-jo=");
        hashSet.add("-la");
        hashSet.add("-ld");
        hashSet.add("-lf");
        hashSet.add("-lfo");
        hashSet.add("-lo=");
        hashSet.add("-noexec");
        hashSet.add("-od=");
        hashSet.add("-rw=");
        hashSet.add("-sa");
        hashSet.add("-st");
        hashSet.add("-sf");
        hashSet.add("-smat");
        hashSet.add("-sp=");
        hashSet.add("-v");
        hashSet.add("-wd2");
        hashSet.add("-wu");
        hashSet.add("-xcv");
        hashSet.add("-xms");
        hashSet.add("-xmsn");
        hashSet.add("-xo0");
        hashSet.add("-xosrt");
        hashSet.add("-xwca");
        hashSet.add("-xwh");
        hashSet.add("-xwhc");
        hashSet.add("-xwhj");
        hashSet.add("-ze");
        hashSet.add("-zi");
        hashSet.add("-zy");
        excludedOptionKeys = Collections.unmodifiableSet(hashSet);
    }
}

