/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.annotations.BreakpointAnnotation;
import com.iscobol.plugins.editor.annotations.WatchpointAnnotation;
import com.iscobol.plugins.editor.util.DefaultResourceImpl;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ui.IEditorPart;

public class BreakpointMarker
implements IMarker {
    private IResource resource;
    private Map attrs = new HashMap();
    private long creationTime;
    private String type;
    private IBreakpoint breakpoint;
    private IEditorPart editor;
    private Annotation annotation;
    private String resourceName;
    private IMarker fileMarker;

    public BreakpointMarker(String string) {
        this(string, null, null);
    }

    public BreakpointMarker(String string, String string2, IMarker iMarker) {
        this.type = string;
        this.resourceName = string2;
        this.fileMarker = iMarker;
        this.creationTime = System.currentTimeMillis();
    }

    private SourceViewer getViewer() {
        IscobolEditor iscobolEditor = this.editor instanceof IscobolEditor ? (IscobolEditor)this.editor : (IscobolEditor)this.editor.getAdapter(IscobolEditor.class);
        if (iscobolEditor != null) {
            return iscobolEditor.getViewer();
        }
        return null;
    }

    public IMarker getFileMarker() {
        return this.fileMarker;
    }

    public void setEditor(IEditorPart iEditorPart) {
        this.editor = iEditorPart;
        if (this.editor != null) {
            try {
                SourceViewer sourceViewer = this.getViewer();
                IAnnotationModel iAnnotationModel = sourceViewer.getAnnotationModel();
                if (iAnnotationModel != null) {
                    Position position = new Position(sourceViewer.getDocument().getLineOffset(this.getAttribute("lineNumber", 1) - 1));
                    if (this.type.equals("com.iscobol.plugins.editor.IscobolEditor.IscobolBreakpointMarker")) {
                        this.annotation = new BreakpointAnnotation(this);
                    } else if (this.type.equals("com.iscobol.plugins.editor.IscobolEditor.IscobolWatchpointMarker")) {
                        this.annotation = new WatchpointAnnotation();
                    }
                    if (this.annotation != null) {
                        iAnnotationModel.addAnnotation(this.annotation, position);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void delete() throws CoreException {
        if (this.editor != null && this.annotation != null) {
            try {
                IAnnotationModel iAnnotationModel = this.getViewer().getAnnotationModel();
                if (iAnnotationModel != null) {
                    iAnnotationModel.removeAnnotation(this.annotation);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setBreakpoint(IBreakpoint iBreakpoint) {
        this.breakpoint = iBreakpoint;
    }

    public boolean exists() {
        return false;
    }

    public Object getAttribute(String string) throws CoreException {
        return this.getAttribute(string, (String)null);
    }

    public int getAttribute(String string, int n) {
        Integer n2 = (Integer)this.attrs.get(string);
        if (n2 != null) {
            return n2;
        }
        return n;
    }

    public String getAttribute(String string, String string2) {
        String string3 = (String)this.attrs.get(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public boolean getAttribute(String string, boolean bl) {
        Boolean bl2 = (Boolean)this.attrs.get(string);
        if (bl2 != null) {
            return bl2;
        }
        return bl;
    }

    public Map getAttributes() throws CoreException {
        return this.attrs;
    }

    public Object[] getAttributes(String[] stringArray) throws CoreException {
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.attrs.get(stringArray[i]);
        }
        return objectArray;
    }

    public long getCreationTime() throws CoreException {
        return this.creationTime;
    }

    public long getId() {
        try {
            return Long.parseLong(this.attrs.get("org.eclipse.debug.core.id").toString());
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public IResource getResource() {
        if (this.resource == null) {
            this.resource = DefaultResourceImpl.getInstance((IMarker)this, (String)this.resourceName, (String)"com.iscobol.plugins.editor.IscobolEditor");
        }
        return this.resource;
    }

    public void setResource(IResource iResource) {
        this.resource = iResource;
    }

    public String getType() throws CoreException {
        return this.type;
    }

    public boolean isSubtypeOf(String string) throws CoreException {
        return false;
    }

    private void put(String string, Object object) {
        this.attrs.put(string, object);
        this.fireBreakpointChanged();
    }

    private void fireBreakpointChanged() {
        if (this.breakpoint != null) {
            DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged(this.breakpoint);
        }
    }

    public void setAttribute(String string, int n) throws CoreException {
        this.put(string, (Object)new Integer(n));
    }

    public void setAttribute(String string, Object object) throws CoreException {
        this.put(string, object);
    }

    public void setAttribute(String string, boolean bl) throws CoreException {
        this.put(string, (Object)new Boolean(bl));
    }

    public void setAttributes(Map map) throws CoreException {
        if (!map.isEmpty()) {
            this.attrs.putAll(map);
            this.fireBreakpointChanged();
        }
    }

    public void setAttributes(String[] stringArray, Object[] objectArray) throws CoreException {
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length && i < objectArray.length; ++i) {
                this.attrs.put(stringArray[i], objectArray[i]);
            }
            this.fireBreakpointChanged();
        }
    }

    public Object getAdapter(Class clazz) {
        return null;
    }
}

