/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.debug.BreakpointMarker;
import com.iscobol.plugins.editor.debug.IscobolBreakpoint;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.ui.IEditorPart;

public class IscobolBreakpoint
extends LineBreakpoint {
    public static final String ID = "IscobolBreakpoint";
    public static final String STORAGE_NAME_ATTR = "_storageName";
    public static final String TIMESTAMP_ATTR = "_timestamp";
    public static final String PROGRAM_NAME_ATTR = "_programName";
    private IStorage storage;
    private String storageName;
    private BreakpointMarker bpMarker;

    public IscobolBreakpoint() {
    }

    public IscobolBreakpoint(String string) throws CoreException {
        1 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        if (this.storage instanceof IFile) {
            this.run(this.getMarkerRule((IResource)((IFile)this.storage)), (IWorkspaceRunnable)var2_2);
        } else {
            this.run(null, (IWorkspaceRunnable)var2_2);
        }
    }

    public IscobolBreakpoint(IStorage iStorage, int n, IEditorPart iEditorPart) throws CoreException {
        IscobolEditor iscobolEditor;
        this.storage = iStorage;
        this.storageName = this.storage.getName();
        if (!(iEditorPart instanceof IscobolEditor) && (iscobolEditor = (IscobolEditor)iEditorPart.getAdapter(IscobolEditor.class)) != null) {
            this.storageName = iscobolEditor.getEditorInput().getName();
        }
        iscobolEditor = new /* Unavailable Anonymous Inner Class!! */;
        if (this.storage instanceof IFile) {
            this.run(this.getMarkerRule((IResource)((IFile)this.storage)), (IWorkspaceRunnable)iscobolEditor);
        } else {
            this.run(null, (IWorkspaceRunnable)iscobolEditor);
        }
    }

    public void setPersisted(boolean bl) throws CoreException {
        super.setPersisted(bl);
    }

    public boolean isPersisted() throws CoreException {
        return super.isPersisted();
    }

    public BreakpointMarker getBPMarker() {
        return this.bpMarker;
    }

    public String getStorageName() {
        if (this.storageName == null) {
            this.storageName = this.getMarker().getAttribute(STORAGE_NAME_ATTR, null);
        }
        return this.storageName;
    }

    public String getClassName() {
        return PluginUtilities.getIscobolClassName((String)this.getStorage().getName());
    }

    public String getModelIdentifier() {
        return "IscobolDebugModel";
    }

    protected IMarker ensureMarker() throws DebugException {
        return this.getMarker();
    }

    public String getVariableName() {
        return this.getVariableName(null);
    }

    public String getVariableName(String string) {
        return this.getMarker().getAttribute("varname", string);
    }

    public void setVariableName(String string) throws CoreException {
        this.getMarker().setAttribute("varname", (Object)string);
    }

    public String getPropertyName() {
        return this.getPropertyName(null);
    }

    public String getPropertyName(String string) {
        return this.getMarker().getAttribute("propertyname", string);
    }

    public void setPropertyName(String string) throws CoreException {
        this.getMarker().setAttribute("propertyname", (Object)string);
    }

    public String getEnvName() {
        return this.getEnvName(null);
    }

    public String getEnvName(String string) {
        return this.getMarker().getAttribute("envname", string);
    }

    public void setEnvName(String string) throws CoreException {
        this.getMarker().setAttribute("envname", (Object)string);
    }

    public boolean isHexadecimal() {
        return this.isHexadecimal(false);
    }

    public boolean isHexadecimal(boolean bl) {
        return this.getMarker().getAttribute("hexadecimal", bl);
    }

    public void setHexadecimal(boolean bl) throws CoreException {
        this.getMarker().setAttribute("hexadecimal", bl);
    }

    public IStorage getStorage() {
        if (this.storage != null) {
            return this.storage;
        }
        IResource iResource = this.getMarker().getResource();
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        return null;
    }

    public void setLineNumber(int n) throws CoreException {
        this.getMarker().setAttribute("lineNumber", n);
    }

    public int getLineNumber() {
        return this.getMarker().getAttribute("lineNumber", 0);
    }

    public String getFilename() {
        return this.getStorage().getName();
    }

    public boolean equals(IStorage iStorage, int n) {
        return this.getStorage().equals(iStorage) && this.getLineNumber() == n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IscobolBreakpoint)) {
            return false;
        }
        IscobolBreakpoint iscobolBreakpoint = (IscobolBreakpoint)object;
        if (this.getProgramName() != null) {
            return PluginUtilities.equals((Object)this.getProgramName(), (Object)iscobolBreakpoint.getProgramName());
        }
        return this.equals(iscobolBreakpoint.getStorage(), iscobolBreakpoint.getLineNumber());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getProgramName() != null) {
            stringBuffer.append("[program: " + this.getProgramName() + "]");
        } else {
            stringBuffer.append(this.getStorageName());
            stringBuffer.append(" [line: " + this.getLineNumber());
            String string = this.getVariableName();
            String string2 = this.getEnvName();
            if (string != null || string2 != null) {
                stringBuffer.append(", when ");
                String string3 = this.getEnvName();
                if (string3 != null) {
                    stringBuffer.append("env::" + string3);
                } else {
                    stringBuffer.append(this.getVariableName(""));
                }
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String getProgramName() {
        return this.getMarker().getAttribute(PROGRAM_NAME_ATTR, (String)null);
    }

    static /* synthetic */ IStorage access$000(IscobolBreakpoint iscobolBreakpoint) {
        return iscobolBreakpoint.storage;
    }

    static /* synthetic */ String access$100(IscobolBreakpoint iscobolBreakpoint) {
        return iscobolBreakpoint.storageName;
    }

    static /* synthetic */ BreakpointMarker access$202(IscobolBreakpoint iscobolBreakpoint, BreakpointMarker breakpointMarker) {
        iscobolBreakpoint.bpMarker = breakpointMarker;
        return iscobolBreakpoint.bpMarker;
    }

    static /* synthetic */ BreakpointMarker access$200(IscobolBreakpoint iscobolBreakpoint) {
        return iscobolBreakpoint.bpMarker;
    }
}

