/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.GetInfoCommand;
import com.iscobol.debugger.commands.GetVariablesCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.debug.IDebugHelper;
import com.iscobol.plugins.editor.debug.IscobolBreakpoint;
import com.iscobol.plugins.editor.debug.IscobolDebugElement;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.debug.IscobolStackFrame;
import com.iscobol.plugins.editor.debug.IscobolThread;
import com.iscobol.plugins.editor.debug.IscobolValue;
import com.iscobol.plugins.editor.debug.IscobolVariable;
import com.iscobol.plugins.editor.debug.IscobolWatchpoint;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.VarDecl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;

/*
 * Exception performing whole class analysis ignored.
 */
public class IscobolDebugTarget
extends IscobolDebugElement
implements IDebugTarget,
IDebugElement,
IDisconnect {
    static final String rcsid = "$Id: IscobolDebugTarget.java,v 1.14 2008/12/11 14:10:43 gianni Exp $";
    private static final int MAX_ATTEMPTS = 10;
    public static final String ATTR_SKIP_EVENT = "SKIP_EVENT";
    public static final String ISWATCHPOINT_MARKER_TYPE = "com.iscobol.plugins.editor.IscobolEditor.IscobolWatchpointMarker";
    public static final String ISBREAKPOINT_MARKER_TYPE = "com.iscobol.plugins.editor.IscobolEditor.IscobolBreakpointMarker";
    private EventDispatchJob job;
    private String name;
    private IProcess process;
    private IProject project;
    private int port;
    private int maxAttempts;
    private ClassReloaderThread classReloaderThread;
    private String host;
    private IscobolThread currThread;
    private boolean suspended;
    private boolean disconnected = true;
    private String lastCommandStr;
    private DebugCommand lastCommand;
    private DebugTM tm;
    private IBreakpoint lastBreakpoint;
    private boolean terminated;
    private List<String> breakpointCommands = new ArrayList();
    private Map<Integer, IscobolThread> threads = new HashMap();
    private ArrayList<IscobolVariable> variables = new ArrayList();
    private Map<String, IscobolWatchpoint> monitorTable = new HashMap();
    private Map<String, DebugResponse.DebugInfo> debugInfos = new HashMap();
    private static IOConsoleReaderThread ioConsoleReaderThread = null;
    private static IscobolDebugTarget instance;

    public IscobolDebugTarget(String string, IProject iProject, IProcess iProcess, String string2, int n, int n2, ILaunch iLaunch) {
        this(string, iProject, iProcess, string2, n, n2, 10, iLaunch);
    }

    public IscobolDebugTarget(String string, IProject iProject, IProcess iProcess, String string2, int n, int n2, int n3, ILaunch iLaunch) {
        super(null, iLaunch);
        this.name = string;
        this.project = iProject;
        this.process = iProcess;
        this.launch = iLaunch;
        this.host = string2;
        this.port = n;
        this.maxAttempts = n3;
        if (n2 > 0) {
            try {
                this.classReloaderThread = new ClassReloaderThread(this, string2, n2);
                this.classReloaderThread.start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    int showReloadClassError(String string, String string2) {
        int[] nArray = new int[]{0};
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return nArray[0];
    }

    private void showIsCobolConsole() {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
        boolean bl = false;
        for (int i = 0; i < iViewReferenceArray.length && !bl; ++i) {
            IConsoleView iConsoleView;
            if (!iViewReferenceArray[i].getId().equals("org.eclipse.ui.console.ConsoleView") || (iConsoleView = (IConsoleView)iViewReferenceArray[i].getView(false)) == null || iConsoleView.getConsole() != IscobolEditorPlugin.getDefault().getConsole()) continue;
            bl = true;
        }
        if (!bl) {
            try {
                iWorkbenchPage.showView("org.eclipse.ui.console.ConsoleView", "iscobolIOConsoleView", 3);
                ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)IscobolEditorPlugin.getDefault().getConsole());
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    private void start() {
        instance = this;
        IscobolDebugTarget.instance.terminated = false;
        DebugResponse debugResponse = null;
        boolean bl = false;
        for (int i = 1; !(bl = (debugResponse = DebuggerInvoker.invokeRemote((String)this.host, (int)this.port)).getReturnCode() != 106) && i != this.maxAttempts - 1; ++i) {
            if (instance == null || IscobolDebugTarget.instance.terminated) {
                return;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (debugResponse.getReturnCode() == 103 || debugResponse.getReturnCode() == 104) {
            String string = debugResponse.getMessage();
            if (string == null || string.length() == 0) {
                string = "Program Finished";
            }
            PluginUtilities.logError((String)string);
            DebuggerInvoker.exitDebug();
            instance = null;
            return;
        }
        if (!bl) {
            PluginUtilities.logError((String)(IsresourceBundle.getString((String)"conn_refused_msg") + " " + this.port));
            DebuggerInvoker.exitDebug();
            instance = null;
            return;
        }
        if (this.getProcess() == null) {
            this.disconnected = false;
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            if (ioConsoleReaderThread == null) {
                ioConsoleReaderThread = new IOConsoleReaderThread();
                ioConsoleReaderThread.start();
            }
        }
        ISourceLookupResult iSourceLookupResult = null;
        String string = debugResponse.getLastFile();
        if (string != null && string.length() > 0) {
            IscobolStackFrame iscobolStackFrame = new IscobolStackFrame("", string, debugResponse.getLine(), debugResponse.getLastProgram(), null, (IDebugTarget)this, this.getLaunch());
            iSourceLookupResult = DebugUITools.lookupSource((Object)iscobolStackFrame, (ISourceLocator)this.getLaunch().getSourceLocator());
        }
        if (iSourceLookupResult != null) {
            IscobolDebugTarget.openEditor((IEditorInput)iSourceLookupResult.getEditorInput());
        }
        debugResponse = DebuggerInvoker.getResponse();
        this.suspended = true;
        if (debugResponse != null) {
            debugResponse.getReturnCode();
            if (debugResponse.getReturnCode() != 106 && debugResponse.getReturnCode() != 103) {
                DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
                DebuggerInvoker.setCheckFileOfBreakpoints((boolean)false);
                this.job = new EventDispatchJob(this, debugResponse);
                this.job.schedule();
                this.installDeferredBreakpoints();
            } else {
                instance = null;
            }
        } else {
            instance = null;
        }
    }

    public static IscobolEditor openEditor(IEditorInput iEditorInput) {
        IscobolEditor[] iscobolEditorArray = new IscobolEditor[1];
        new /* Unavailable Anonymous Inner Class!! */.start();
        return iscobolEditorArray[0];
    }

    public static final IscobolDebugTarget getDefault() {
        return instance;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public void setLastBreakpoint(IBreakpoint iBreakpoint) {
        this.lastBreakpoint = iBreakpoint;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public void refreshVariablesView() {
        this.refreshDebugView("org.eclipse.debug.ui.VariableView");
    }

    public void refreshBreakpointView() {
        this.refreshDebugView("org.eclipse.debug.ui.BreakpointView");
    }

    public void refreshDebugView(String string) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] iThreadArray = new IThread[this.threads.size()];
        this.threads.values().toArray(iThreadArray);
        return iThreadArray;
    }

    public boolean hasThreads() throws DebugException {
        if (this.getProcess() != null) {
            return !this.getProcess().isTerminated() && !this.threads.isEmpty();
        }
        return !this.isDisconnected() && !this.threads.isEmpty();
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        return this.isSuspended();
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public boolean canTerminate() {
        if (this.getProcess() != null) {
            return this.getProcess().canTerminate();
        }
        return false;
    }

    public boolean isTerminated() {
        if (this.getProcess() != null) {
            return this.getProcess().isTerminated();
        }
        return false;
    }

    public void terminate() throws DebugException {
        this.terminated();
    }

    private boolean isHtmlProject() {
        try {
            return this.getProject() != null && this.getProject().getNature("com.iscobol.plugins.HtmlAndroid.IscobolHtmlAndroidNature") != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void terminated() {
        String string;
        String string2;
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        IPreferenceStore iPreferenceStore = this.monitorTable.values().iterator();
        while (iPreferenceStore.hasNext()) {
            IscobolWatchpoint iscobolWatchpoint = (IscobolWatchpoint)iPreferenceStore.next();
            iscobolWatchpoint.setValue(null);
        }
        this.monitorTable.clear();
        this.fireTerminateEvent();
        try {
            this.removeTerminatedThreads(new ThreadObject[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resetCurrentLine();
        this.variables.clear();
        try {
            if (this.getProcess() != null) {
                this.getProcess().terminate();
            } else {
                if (this.getLaunch() instanceof Launch) {
                    ((Launch)this.getLaunch()).disconnect();
                }
                this.disconnected = true;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        DebuggerInvoker.exitDebug();
        if (this.job != null) {
            this.job.cancel();
            this.job.getThread().interrupt();
            this.job = null;
        }
        this.suspended = false;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        instance = null;
        if (this.classReloaderThread != null) {
            this.classReloaderThread.close();
            this.classReloaderThread = null;
        }
        int n = (iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore()).contains("iscobol.switchback.ispersp") ? iPreferenceStore.getInt("iscobol.switchback.ispersp") : iPreferenceStore.getDefaultInt("iscobol.switchback.ispersp");
        boolean[] blArray = new boolean[]{false};
        if (this.isHtmlProject()) {
            string2 = "isCOBOL HTML";
            string = "IscobolHtmlAndroidNature";
        } else {
            string2 = "isCOBOL";
            string = "IscobolPerspective";
        }
        if (n == 2) {
            Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        } else if (n == 0) {
            blArray[0] = true;
        }
        if (blArray[0]) {
            Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.currThread = null;
    }

    public void reloadClasses(String[] stringArray) {
        if (this.classReloaderThread == null) {
            return;
        }
        this.classReloaderThread.reloadClasses(stringArray);
    }

    public boolean canResume() {
        if (this.getProcess() != null) {
            return !this.getProcess().isTerminated() && this.isSuspended();
        }
        return !this.isDisconnected() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        this.putCommand("continue");
    }

    public void suspend() throws DebugException {
        DebuggerInvoker.suspend();
    }

    public void putInput(String string) {
        DebuggerInvoker.putInput((String)string);
    }

    public void putCommand(String string) {
        if (this.job != null) {
            this.job.setCommandLine(string);
        }
    }

    private void started() {
        this.fireCreationEvent();
    }

    private void installDeferredBreakpoints() {
        int n;
        IDebugHelper iDebugHelper = (IDebugHelper)this.getAdapter(IDebugHelper.class);
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("IscobolDebugModel");
        DebugResponse debugResponse = null;
        for (n = 0; n < iBreakpointArray.length; ++n) {
            if (!(iBreakpointArray[n] instanceof IscobolBreakpoint)) continue;
            debugResponse = this.installDeferredBreakpoint(iBreakpointArray[n], iDebugHelper);
        }
        for (n = 0; n < iBreakpointArray.length; ++n) {
            if (!(iBreakpointArray[n] instanceof IscobolWatchpoint) || (debugResponse = this.installDeferredBreakpoint(iBreakpointArray[n], iDebugHelper)).getReturnCode() != 0) continue;
            IscobolWatchpoint iscobolWatchpoint = (IscobolWatchpoint)iBreakpointArray[n];
            this.monitorTable.put(this.getKey(iscobolWatchpoint), iscobolWatchpoint);
        }
        this.updateMonitors(debugResponse);
    }

    private DebugResponse installDeferredBreakpoint(IBreakpoint iBreakpoint, IDebugHelper iDebugHelper) {
        DebugResponse debugResponse = null;
        try {
            debugResponse = null;
            String string = this.makeCommand(iBreakpoint, iDebugHelper);
            if (string != null) {
                debugResponse = this.processCommand(string);
            }
            if (debugResponse != null && debugResponse.getReturnCode() != 0) {
                iBreakpoint.getMarker().setAttribute("SKIP_EVENT", true);
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(iBreakpoint, true);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return debugResponse;
    }

    private void suspended(int n) {
        this.suspended = true;
        if (this.currThread != null) {
            this.currThread.fireSuspendEvent(n);
        }
    }

    private void resumed(int n) {
        this.suspended = false;
        if (this.currThread != null) {
            this.currThread.fireResumeEvent(n);
        }
        this.resetCurrentLine();
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        try {
            if (iBreakpoint.getMarker().getAttribute("SKIP_EVENT", false)) {
                return;
            }
            if (iBreakpoint instanceof IscobolBreakpoint) {
                IDebugHelper iDebugHelper = (IDebugHelper)this.getAdapter(IDebugHelper.class);
                String string = this.makeBreakpointCommand((IscobolBreakpoint)iBreakpoint, iDebugHelper);
                if (this.job != null && this.job.getCommandLine() == null) {
                    this.putCommand(string);
                } else {
                    this.breakpointCommands.add(string);
                }
            } else if (iBreakpoint instanceof IscobolWatchpoint) {
                IscobolWatchpoint iscobolWatchpoint = (IscobolWatchpoint)iBreakpoint;
                String string = this.makeWatchpointCommand(iscobolWatchpoint);
                this.monitorTable.put(this.getKey(iscobolWatchpoint), iscobolWatchpoint);
                if (this.job != null && this.job.getCommandLine() == null) {
                    this.putCommand(string);
                } else {
                    this.breakpointCommands.add(string);
                }
            }
        }
        catch (CoreException coreException) {
            PluginUtilities.log((Throwable)coreException);
        }
    }

    private String makeCommand(IBreakpoint iBreakpoint, IDebugHelper iDebugHelper) throws CoreException {
        if (iBreakpoint instanceof IscobolBreakpoint) {
            return this.makeBreakpointCommand((IscobolBreakpoint)iBreakpoint, iDebugHelper);
        }
        if (iBreakpoint instanceof IscobolWatchpoint) {
            return this.makeWatchpointCommand((IscobolWatchpoint)iBreakpoint);
        }
        return null;
    }

    private String makeWatchpointCommand(IscobolWatchpoint iscobolWatchpoint) {
        return iscobolWatchpoint.getDebugCommand();
    }

    private String makeBreakpointCommand(IscobolBreakpoint iscobolBreakpoint, IDebugHelper iDebugHelper) throws CoreException {
        StringBuffer stringBuffer = new StringBuffer();
        if (iscobolBreakpoint.getProgramName() != null) {
            stringBuffer.append("b0");
            if (!iscobolBreakpoint.isEnabled()) {
                stringBuffer.append(" -d");
            }
            stringBuffer.append(" ").append(iscobolBreakpoint.getProgramName());
        } else {
            stringBuffer.append("break");
            if (!iscobolBreakpoint.isEnabled()) {
                stringBuffer.append(" -d");
            }
            int n = iDebugHelper.getLineNumber(iscobolBreakpoint);
            stringBuffer.append(" " + n);
            String string = iDebugHelper.getFileName(iscobolBreakpoint);
            stringBuffer.append(" " + string);
            String string2 = iscobolBreakpoint.getVariableName();
            String string3 = iscobolBreakpoint.getEnvName();
            if (string2 != null || string3 != null) {
                stringBuffer.append(" when");
                if (string3 != null) {
                    stringBuffer.append(" -env " + string3);
                } else {
                    boolean bl = iscobolBreakpoint.isHexadecimal();
                    if (bl) {
                        stringBuffer.append(" -x ");
                    }
                    stringBuffer.append(" " + string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        this.breakpointAdded(iBreakpoint);
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (iBreakpoint.getMarker().getAttribute("SKIP_EVENT", false)) {
            return;
        }
        if (iBreakpoint instanceof IscobolBreakpoint) {
            this.removeBreakpoint((IscobolBreakpoint)iBreakpoint);
        } else if (iBreakpoint instanceof IscobolWatchpoint) {
            this.removeMonitor((IscobolWatchpoint)iBreakpoint);
        }
    }

    private void removeBreakpoint(IscobolBreakpoint iscobolBreakpoint) {
        String string = "clear";
        string = string + " " + iscobolBreakpoint.getLineNumber();
        string = string + " " + iscobolBreakpoint.getFilename();
        if (this.job != null && this.job.getCommandLine() == null) {
            this.putCommand(string);
        } else {
            this.breakpointCommands.add(string);
        }
    }

    private void removeMonitor(IscobolWatchpoint iscobolWatchpoint) {
        String string = iscobolWatchpoint.getDebugDelCommand();
        if (this.job != null && this.job.getCommandLine() == null) {
            this.putCommand(string);
        } else {
            this.breakpointCommands.add(string);
        }
        this.monitorTable.remove(this.getKey(iscobolWatchpoint));
    }

    public boolean canDisconnect() {
        return !this.disconnected;
    }

    public void disconnect() throws DebugException {
        this.terminate();
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "com.iscobol.plugins.editor.IscobolEditor", 5011, IsresourceBundle.getString((String)"op_not_supported_msg"), null));
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    void setTextCommand(String string) {
        if (string != null) {
            if (string.length() == 0 && this.lastCommandStr != null) {
                string = this.lastCommandStr;
            }
            if (string.length() > 0) {
                this.lastCommandStr = string.trim();
                this.tm = new DebugTM(this.lastCommandStr, " ,;(:=)+*\"<>", DebuggerInvoker.standardCommands);
                int n = -1;
                try {
                    n = this.tm.getCommand(this.tm.getToken());
                }
                catch (DebuggerException debuggerException) {
                    PluginUtilities.logError((String)debuggerException.getMessage());
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    PluginUtilities.logError((String)(IsresourceBundle.getString((String)"internal_error_msg") + " " + this.lastCommandStr));
                    return;
                }
                this.process(n);
            }
        }
    }

    private List<VarName> getCurrentVarnames(IscobolEditor iscobolEditor, String string, int n, int n2, int n3) {
        IDocument iDocument;
        IsFragment isFragment = iscobolEditor.getCurrFragment();
        if (isFragment == null) {
            return Collections.EMPTY_LIST;
        }
        DebugResponse.DebugInfo debugInfo = (DebugResponse.DebugInfo)this.debugInfos.get(string);
        if (debugInfo == null && (iDocument = this.processCommand((DebugCommand)new GetInfoCommand(2, string))) != null && iDocument.getInfo() != null) {
            debugInfo = iDocument.getInfo();
            this.debugInfos.put(string, debugInfo);
        }
        if (debugInfo == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            int n4;
            int n5;
            int n6;
            iDocument = iscobolEditor.getViewer().getDocument();
            DebugLine[] debugLineArray = debugInfo.getLines();
            int n7 = 0;
            int n8 = 0;
            for (n6 = 0; n6 < debugLineArray.length; ++n6) {
                if (debugLineArray[n6].getLineNumber() != n || debugLineArray[n6].getFileIndex() != n2) continue;
                n5 = debugLineArray[n6].getParagraphId();
                for (n4 = 0; n4 <= n3 && n6 >= n4 && debugLineArray[n6 - n4].getParagraphId() == n5 && debugLineArray[n6 - n4].getFileIndex() == n2; ++n4) {
                    n7 = debugLineArray[n6 - n4].getLineNumber();
                }
                break;
            }
            ++n6;
            while (n6 < debugLineArray.length) {
                if (debugLineArray[n6].getFileIndex() == n2) {
                    n8 = debugLineArray[n6].getLineNumber();
                    break;
                }
                ++n6;
            }
            n5 = iDocument.getLineOffset(n7 - 1);
            n4 = n8 > 0 ? iDocument.getLineOffset(n8 - 1) : iDocument.getLength();
            String string2 = iDocument.get(n5, n4 - n5);
            return this.getVarnames(string2, isFragment);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    private List<VarName> getVarnames(String string, IsFragment isFragment) {
        HashSet<String> hashSet = new HashSet<String>();
        Pattern pattern = Pattern.compile("([\\w\\-]+)(\\(.+\\))?");
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (bl) {
                if (string.charAt(i) != '\"') continue;
                bl = false;
                continue;
            }
            if (string.charAt(i) == '\"') {
                bl = true;
                continue;
            }
            if (" =():\".,".indexOf(string.charAt(i)) != -1) continue;
            String string2 = PluginUtilities.findVariableName((String)string, (int)i, (boolean)false);
            if (string2 == null) break;
            Matcher matcher = pattern.matcher(string2 = string2.trim());
            if (!matcher.find()) continue;
            i += string2.length();
            String string3 = isFragment.getVarDecl(matcher.group(1));
            if (string3 == null || string3.isStatic()) continue;
            hashSet.add(string2.toUpperCase());
        }
        ArrayList<VarName> arrayList = new ArrayList<VarName>();
        for (String string3 : hashSet) {
            try {
                arrayList.add(IscobolDebugTarget.createVarName((String)string3));
            }
            catch (DebuggerException debuggerException) {}
        }
        return arrayList;
    }

    private void process(int n) {
        try {
            this.lastCommand = DebuggerInvoker.parseCommand((int)n, (DebugTM)this.tm);
        }
        catch (DebuggerException debuggerException) {
            PluginUtilities.logError((String)debuggerException.getMessage());
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PluginUtilities.logError((String)(IsresourceBundle.getString((String)"internal_error_msg") + " " + this.lastCommandStr));
            return;
        }
        int n2 = -1;
        int n3 = this.lastCommand.getId();
        switch (n3) {
            case 1: 
            case 12: 
            case 16: {
                n2 = 32;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
            case 10: 
            case 11: {
                n2 = 4;
            }
        }
        this.genericCommand(n2);
    }

    private void genericCommand(int n) {
        if (n >= 0) {
            this.resumed(n);
        }
        DebugResponse debugResponse = null;
        debugResponse = this.processCommand(this.lastCommand);
        this.handleResponse(debugResponse);
    }

    boolean isCurrentThread(IscobolThread iscobolThread) {
        return this.currThread == iscobolThread;
    }

    public IscobolThread getCurrentThread() {
        return this.currThread;
    }

    private void handleResponse(DebugResponse debugResponse) {
        boolean bl = debugResponse != null ? debugResponse.getReturnCode() == 103 || debugResponse.getReturnCode() == 104 || debugResponse.getReturnCode() == 105 : true;
        if (bl) {
            this.terminated();
            return;
        }
        int n = debugResponse.getReturnCode();
        int n2 = debugResponse.getLastCmd();
        switch (n) {
            case 0: 
            case 20: {
                break;
            }
            case 101: {
                break;
            }
            case 102: {
                PluginUtilities.logMessage((String)(IsresourceBundle.getString((String)"change_var_msg") + " " + debugResponse.getVarName()), (int)2);
                break;
            }
            default: {
                switch (n2) {
                    case 0: 
                    case 13: {
                        if (this.lastBreakpoint == null) break;
                        try {
                            this.lastBreakpoint.getMarker().setAttribute("SKIP_EVENT", true);
                            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(this.lastBreakpoint, true);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        if (!(this.lastBreakpoint instanceof IscobolWatchpoint)) break;
                        this.monitorTable.remove(this.getKey((IscobolWatchpoint)this.lastBreakpoint));
                    }
                }
                PluginUtilities.logError((String)debugResponse.getMessage().substring(2));
                return;
            }
        }
        IscobolThread iscobolThread = this.currThread;
        if (this.currThread != null && this.currThread.frames != null && this.currThread.frames.length > 0) {
            this.currThread.frames[0].setLineNumber(0);
        }
        this.executeBreakpointCommands();
        switch (n2) {
            case 1: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 29: {
                IscobolEditor iscobolEditor;
                Object object;
                ThreadObject[] threadObjectArray = debugResponse.getThreads();
                if (threadObjectArray != null) {
                    try {
                        this.removeTerminatedThreads(threadObjectArray);
                        this.addNewThreads(threadObjectArray);
                        this.initThreads(threadObjectArray);
                        this.currThread = (IscobolThread)this.threads.get(new Integer(debugResponse.getCurrentThread().getId()));
                        this.currThread.frames[0].setLineNumber(debugResponse.getLine());
                        object = debugResponse.getLastFile();
                        if (this.project != null && object != null) {
                            object = PluginUtilities.makeRelative((String)object, (IProject)this.project);
                        }
                        this.currThread.frames[0].setFilename((String)(object != null ? object : ""));
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                }
                if ((iscobolEditor = PluginUtilities.findIscobolEditorForInput((IEditorInput)(object = DebugUITools.lookupSource((Object)this.currThread.frames[0], (ISourceLocator)this.getLaunch().getSourceLocator())).getEditorInput())) == null) {
                    iscobolEditor = IscobolDebugTarget.openEditor((IEditorInput)object.getEditorInput());
                }
                if (iscobolEditor == null) break;
                int n3 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxhexdumplength");
                int n4 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.hexdumpstartoffset");
                int n5 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxarraylength");
                int n6 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.startarrayindex");
                int n7 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxtextlength");
                List list = this.getCurrentVarnames(iscobolEditor, debugResponse.getLastClass(), debugResponse.getLine(), debugResponse.getLastFileIndex(), 1);
                if (!list.isEmpty()) {
                    IscobolVariable iscobolVariable;
                    int n8;
                    TreeNode[] treeNodeArray;
                    GetVariablesCommand getVariablesCommand = new GetVariablesCommand(list.toArray(new VarName[list.size()]), n3, n4, n5, n6, n7);
                    DebugResponse debugResponse2 = this.processCommand((DebugCommand)getVariablesCommand);
                    Tree tree = debugResponse2.getTree();
                    if (tree == null || (treeNodeArray = tree.getRoot().getChildren()).length <= 0) break;
                    ArrayList<IscobolVariable> arrayList = new ArrayList<IscobolVariable>();
                    ArrayList<TreeNode> arrayList2 = new ArrayList<TreeNode>();
                    for (n8 = 0; n8 < treeNodeArray.length; ++n8) {
                        iscobolVariable = new IscobolVariable(treeNodeArray[n8], null, (IDebugTarget)this, this.getLaunch());
                        arrayList.add(iscobolVariable);
                        arrayList2.add(treeNodeArray[n8]);
                    }
                    n8 = 0;
                    while (n8 < this.variables.size()) {
                        iscobolVariable = (IscobolVariable)this.variables.get(n8);
                        int n9 = arrayList.indexOf(iscobolVariable);
                        if (n9 < 0) {
                            this.variables.remove(n8);
                            continue;
                        }
                        iscobolVariable.setValue((TreeNode)arrayList2.get(n9), true);
                        arrayList.remove(n9);
                        arrayList2.remove(n9);
                        ++n8;
                    }
                    this.variables.addAll(arrayList);
                    break;
                }
                this.variables.clear();
                break;
            }
            case 5: {
                if (debugResponse.getVarName() != null || debugResponse.getTree() != null) {
                    String string = debugResponse.getVarName();
                    String string2 = debugResponse.getVarValue();
                    this.displayMessage(string + " = " + string2);
                    break;
                }
                this.handleDisplayEnvCommand(debugResponse);
                break;
            }
            case 26: {
                this.handleDisplayEnvCommand(debugResponse);
                break;
            }
            case 6: {
                if (debugResponse.getVarName() != null) break;
                this.displayMessage(debugResponse.getMessage().substring(2));
                break;
            }
        }
        this.updateMonitors(debugResponse);
        this.lastBreakpoint = null;
        switch (n) {
            case 101: 
            case 102: {
                this.suspended(16);
                break;
            }
            default: {
                if (iscobolThread != this.currThread) {
                    this.suspended(16);
                    break;
                }
                this.suspended(8);
            }
        }
    }

    public static VarName createVarName(String string) throws DebuggerException {
        DebugTM debugTM = new DebugTM(string, " ,;(:=)+*\"<>", new DebugCommand[0]);
        return new VarName(debugTM);
    }

    public void refreshVariables() {
        IscobolVariable iscobolVariable;
        if (!this.hasVariables()) {
            return;
        }
        int n = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxhexdumplength");
        int n2 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.hexdumpstartoffset");
        int n3 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxarraylength");
        int n4 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.startarrayindex");
        int n5 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxtextlength");
        VarName[] varNameArray = new VarName[this.variables.size()];
        for (int i = 0; i < this.variables.size(); ++i) {
            iscobolVariable = (IscobolVariable)this.variables.get(i);
            try {
                varNameArray[i] = IscobolDebugTarget.createVarName((String)iscobolVariable.getName());
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            try {
                ((IscobolValue)iscobolVariable.getValue()).setNeedRefresh(true);
                continue;
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        GetVariablesCommand getVariablesCommand = new GetVariablesCommand(varNameArray, n, n2, n3, n4, n5);
        iscobolVariable = this.processCommand((DebugCommand)getVariablesCommand);
        Tree tree = iscobolVariable.getTree();
        if (tree != null) {
            TreeNode[] treeNodeArray = tree.getRoot().getChildren();
            for (int i = 0; i < treeNodeArray.length && i < this.variables.size(); ++i) {
                IscobolVariable iscobolVariable2 = (IscobolVariable)this.variables.get(i);
                DebugUtilities.VarValue varValue = DebugUtilities.parseVarValue((String)treeNodeArray[i].getVarValue());
                iscobolVariable2.setHexDump(varValue.hexDump);
                String string = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.variableview.showhex") ? IscobolDebugTarget.getValueString((String)varValue.hexDump) : varValue.textValue;
                try {
                    ((IscobolValue)iscobolVariable2.getValue()).setValueString(string);
                    continue;
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
            }
        }
    }

    public static String getValueString(String string) {
        String string2;
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                int n = string3.indexOf(58) + 1;
                int n2 = Math.min(string3.indexOf(91), string3.indexOf(45));
                char[] cArray = string3.toCharArray();
                for (int i = n + 1; i < n2; ++i) {
                    if (cArray[i] == ' ') continue;
                    stringBuilder.append(cArray[i]);
                }
                string3 = bufferedReader.readLine();
            }
            string2 = stringBuilder.toString();
        }
        catch (IOException iOException) {
            string2 = "";
        }
        return string2;
    }

    void handleDisplayEnvCommand(DebugResponse debugResponse) {
        String string = debugResponse.getMessage().substring(2);
        String string2 = "";
        int n = string.indexOf(61);
        if (n >= 0) {
            string2 = n < string.length() - 1 ? string.substring(n + 1).trim() : "";
            string = string.substring(0, n).trim();
        }
        this.displayMessage(string + " = " + string2);
    }

    public synchronized DebugResponse processCommand(String string) {
        return DebuggerInvoker.processCommand((String)string);
    }

    public synchronized DebugResponse processCommand(DebugCommand debugCommand) {
        return DebuggerInvoker.processCommand((DebugCommand)debugCommand);
    }

    private void updateMonitors(DebugResponse debugResponse) {
        if (debugResponse == null) {
            return;
        }
        Watch[] watchArray = debugResponse.getMonitors();
        if (watchArray != null) {
            for (int i = 0; i < watchArray.length; ++i) {
                IscobolWatchpoint iscobolWatchpoint = (IscobolWatchpoint)this.monitorTable.get(this.getKey(watchArray[i]));
                if (iscobolWatchpoint == null) continue;
                iscobolWatchpoint.setValue(watchArray[i].getValue());
            }
            this.refreshBreakpointView();
        }
    }

    private void displayMessage(String string) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private String getKey(IscobolWatchpoint iscobolWatchpoint) {
        String string = iscobolWatchpoint.getEnvName();
        if (string != null) {
            return string.toUpperCase();
        }
        string = iscobolWatchpoint.getClassName() + "." + iscobolWatchpoint.getVariableName("");
        String string2 = iscobolWatchpoint.getPropertyName();
        if (string2 != null) {
            string = string + "." + string2;
        }
        return string.toUpperCase();
    }

    private String getKey(Watch watch) {
        String string = watch.getEnvProperty();
        if (string != null) {
            return string.toUpperCase();
        }
        string = watch.getClassname() + "." + watch.getFullName();
        String string2 = watch.getPropName();
        if (string2 != null) {
            string = string + "." + string2;
        }
        return string.toUpperCase();
    }

    private void executeBreakpointCommands() {
        int n = this.breakpointCommands.size();
        for (int i = 0; i < n; ++i) {
            this.processCommand((String)this.breakpointCommands.get(i));
        }
        this.breakpointCommands.clear();
    }

    public IProject getProject() {
        return this.project;
    }

    void removeTerminatedThreads(ThreadObject[] threadObjectArray) throws DebugException {
        Vector<IscobolThread> vector = new Vector<IscobolThread>();
        for (IscobolThread iscobolThread : this.threads.values()) {
            boolean bl = false;
            for (int i = 0; i < threadObjectArray.length; ++i) {
                if (iscobolThread.getId() != threadObjectArray[i].getId()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector.addElement(iscobolThread);
            this.threads.remove(new Integer(iscobolThread.getId()));
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((IscobolThread)vector.elementAt(i)).fireTerminateEvent();
        }
    }

    void addNewThreads(ThreadObject[] threadObjectArray) throws DebugException {
        int n;
        Vector<IscobolThread> vector = new Vector<IscobolThread>();
        for (n = 0; n < threadObjectArray.length; ++n) {
            Integer n2 = new Integer(threadObjectArray[n].getId());
            if (this.threads.get(n2) != null) continue;
            IscobolThread iscobolThread = new IscobolThread((IDebugTarget)this, this.getLaunch());
            vector.addElement(iscobolThread);
            this.threads.put(n2, iscobolThread);
        }
        n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((IscobolThread)vector.elementAt(i)).fireCreationEvent();
        }
    }

    void initThreads(ThreadObject[] threadObjectArray) throws DebugException {
        for (int i = 0; i < threadObjectArray.length; ++i) {
            ((IscobolThread)this.threads.get(new Integer(threadObjectArray[i].getId()))).init(threadObjectArray[i]);
        }
    }

    private void resetCurrentLine() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean hasVariables() {
        return this.variables.size() > 0;
    }

    public IVariable[] getVariables() {
        return this.variables.toArray(new IVariable[this.variables.size()]);
    }

    public static void toggleLineBreakpoints(IEditorPart iEditorPart, TextSelection textSelection) throws CoreException {
        IscobolDebugTarget.toggleLineBreakpoints((IEditorPart)iEditorPart, (int)textSelection.getStartLine());
    }

    public static IscobolBreakpoint toggleLineBreakpoints(IEditorPart iEditorPart, int n) throws CoreException {
        if (iEditorPart != null) {
            IStorage iStorage = (IStorage)iEditorPart.getEditorInput().getAdapter(IResource.class);
            if (iStorage == null) {
                iStorage = (IStorage)iEditorPart.getEditorInput().getAdapter(IStorage.class);
            }
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("IscobolDebugModel");
            for (int i = 0; i < iBreakpointArray.length; ++i) {
                if (!(iBreakpointArray[i] instanceof IscobolBreakpoint) || !((IscobolBreakpoint)iBreakpointArray[i]).equals(iStorage, n + 1)) continue;
                iBreakpointArray[i].delete();
                return null;
            }
            IscobolBreakpoint iscobolBreakpoint = new IscobolBreakpoint(iStorage, n + 1, iEditorPart);
            if (IscobolDebugTarget.getDefault() != null) {
                IscobolDebugTarget.getDefault().setLastBreakpoint((IBreakpoint)iscobolBreakpoint);
            }
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)iscobolBreakpoint);
            return iscobolBreakpoint;
        }
        return null;
    }

    public static boolean canToggleLineBreakpoints(IscobolEditor iscobolEditor, TextSelection textSelection) {
        if (iscobolEditor != null) {
            int n = textSelection.getStartLine();
            IDocument iDocument = iscobolEditor.getViewer().getDocument();
            String string = null;
            try {
                string = iDocument.get(iDocument.getLineOffset(n), iDocument.getLineLength(n));
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
            return IscobolDebugTarget.canToggleLineBreakpoints((String)string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canToggleLineBreakpoints(IFile iFile, int n) {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = iFile.getContents();
            bufferedReader = new LineNumberReader(new InputStreamReader(inputStream));
            String string = ((LineNumberReader)bufferedReader).readLine();
            while (true) {
                if (string != null) {
                    if (((LineNumberReader)bufferedReader).getLineNumber() == n) {
                        boolean bl = IscobolDebugTarget.canToggleLineBreakpoints((String)string);
                        return bl;
                    }
                    string = ((LineNumberReader)bufferedReader).readLine();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static boolean canToggleLineBreakpoints(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = false;
        TokenList tokenList = PreProcessor.tokenizer((StringBuffer)new StringBuffer(string), (char)'.', (boolean)true, null);
        Token token = tokenList.getFirst();
        while (token != null && !bl) {
            if (IscobolEditor.isStatement((String)token.getWord())) {
                bl = true;
            }
            token = tokenList.getNext();
        }
        return bl;
    }

    public static IscobolWatchpoint findWatchpoint(IscobolEditor iscobolEditor, String string) throws CoreException {
        if (iscobolEditor != null) {
            IStorage iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IResource.class);
            if (iStorage == null) {
                iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IStorage.class);
            }
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("IscobolDebugModel");
            for (int i = 0; i < iBreakpointArray.length; ++i) {
                if (!(iBreakpointArray[i] instanceof IscobolWatchpoint) || !((IscobolWatchpoint)iBreakpointArray[i]).equals(iStorage, string, "", "")) continue;
                return (IscobolWatchpoint)iBreakpointArray[i];
            }
        }
        return null;
    }

    public static void toggleWatchpoints(IscobolEditor iscobolEditor, String string) throws CoreException {
        if (iscobolEditor != null) {
            IsFragment isFragment;
            IStorage iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IResource.class);
            if (iStorage == null) {
                iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IStorage.class);
            }
            if ((isFragment = iscobolEditor.findSelectedFragment(string)) != null && isFragment.getType() == 13) {
                int n = isFragment.getStartLine();
                IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("IscobolDebugModel");
                for (int i = 0; i < iBreakpointArray.length; ++i) {
                    if (!(iBreakpointArray[i] instanceof IscobolWatchpoint) || !((IscobolWatchpoint)iBreakpointArray[i]).equals(iStorage, string, "", "")) continue;
                    iBreakpointArray[i].delete();
                    return;
                }
                IscobolWatchpoint iscobolWatchpoint = new IscobolWatchpoint(string, iStorage, n + 1, iscobolEditor);
                if (IscobolDebugTarget.getDefault() != null) {
                    IscobolDebugTarget.getDefault().setLastBreakpoint((IBreakpoint)iscobolWatchpoint);
                }
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)iscobolWatchpoint);
            }
        }
    }

    public static boolean canToggleWatchpoints(TextSelection textSelection) {
        return IscobolDebugTarget.canToggleWatchpoints((String)textSelection.getText());
    }

    public static boolean canToggleWatchpoints(String string) {
        boolean bl;
        boolean bl2 = bl = IscobolDebugTarget.getDefault() != null && IscobolDebugTarget.getDefault().isSuspended() && string.length() > 0;
        if (!bl) {
            return false;
        }
        DebugResponse debugResponse = IscobolDebugTarget.getDefault().processCommand("display " + string);
        return debugResponse != null && debugResponse.getReturnCode() == 0;
    }

    public static String getDescription(VarDecl varDecl, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(varDecl.getName());
        if (varDecl.hasChildren()) {
            stringBuffer.append(" group-item");
        } else if (varDecl.isObjectReference()) {
            stringBuffer.append(" object reference " + varDecl.getTypename());
        } else {
            if (varDecl.getPicture() != null) {
                stringBuffer.append(" pic " + varDecl.getPicture());
            }
            if (varDecl.getUsage() != null) {
                stringBuffer.append(" " + varDecl.getUsage());
            }
        }
        stringBuffer.append(" = " + string);
        return stringBuffer.toString();
    }

    static /* synthetic */ void access$000(IscobolDebugTarget iscobolDebugTarget) {
        iscobolDebugTarget.started();
    }

    static /* synthetic */ void access$100(IscobolDebugTarget iscobolDebugTarget, DebugResponse debugResponse) {
        iscobolDebugTarget.handleResponse(debugResponse);
    }

    static /* synthetic */ void access$200(IscobolDebugTarget iscobolDebugTarget) {
        iscobolDebugTarget.terminated();
    }

    static /* synthetic */ boolean access$300(IscobolDebugTarget iscobolDebugTarget) {
        return iscobolDebugTarget.suspended;
    }

    static /* synthetic */ void access$400(IscobolDebugTarget iscobolDebugTarget) {
        iscobolDebugTarget.start();
    }

    static /* synthetic */ void access$500(IscobolDebugTarget iscobolDebugTarget) {
        iscobolDebugTarget.showIsCobolConsole();
    }
}

