/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.debug.IscobolBreakpoint;
import com.iscobol.plugins.editor.debug.IscobolStackFrame;
import com.iscobol.plugins.editor.debug.IscobolWatchpoint;
import com.iscobol.plugins.editor.util.IOFileStorage;
import com.iscobol.plugins.editor.util.IOFileStorageEditorInput;
import com.iscobol.plugins.editor.util.LocalFileStorageEditorInput;
import com.iscobol.plugins.editor.util.ZipEntryStorageEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.debug.ui.IInstructionPointerPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class IscobolModelPresentation
implements IInstructionPointerPresentation {
    public static final String ID = "IscobolDebugModel";
    public static final String rcsid = "$Id: IscobolModelPresentation.java,v 1.11 2008/12/11 14:10:43 gianni Exp $";

    public void computeDetail(IValue iValue, IValueDetailListener iValueDetailListener) {
        String string = "";
        try {
            string = iValue.getValueString();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        iValueDetailListener.detailComputed(iValue, string != null ? string : "");
    }

    public Image getImage(Object object) {
        if (object instanceof IscobolBreakpoint) {
            return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/breakpoint.gif");
        }
        if (object instanceof IscobolWatchpoint) {
            return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/monitor.gif");
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof IscobolStackFrame) {
            return object.toString();
        }
        if (object instanceof IscobolWatchpoint) {
            return object.toString();
        }
        if (object instanceof IscobolBreakpoint) {
            return object.toString();
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        IscobolBreakpoint iscobolBreakpoint;
        if (object instanceof IFile || object instanceof LocalFileStorage || object instanceof IOFileStorage || object instanceof ZipEntryStorage) {
            return IscobolEditor.ID;
        }
        if (object instanceof IscobolBreakpoint && (iscobolBreakpoint = (IscobolBreakpoint)object).getProgramName() == null) {
            return this.getEditorId(iEditorInput, (Object)iscobolBreakpoint.getStorage());
        }
        return null;
    }

    public IEditorInput getEditorInput(Object object) {
        IscobolBreakpoint iscobolBreakpoint;
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof LocalFileStorage) {
            return new LocalFileStorageEditorInput((LocalFileStorage)object);
        }
        if (object instanceof IOFileStorage) {
            return new IOFileStorageEditorInput((IOFileStorage)object);
        }
        if (object instanceof ZipEntryStorage) {
            return new ZipEntryStorageEditorInput((ZipEntryStorage)object);
        }
        if (object instanceof IscobolBreakpoint && (iscobolBreakpoint = (IscobolBreakpoint)object).getProgramName() == null) {
            return this.getEditorInput((Object)iscobolBreakpoint.getStorage());
        }
        return null;
    }

    public Annotation getInstructionPointerAnnotation(IEditorPart iEditorPart, IStackFrame iStackFrame) {
        return null;
    }

    public String getInstructionPointerAnnotationType(IEditorPart iEditorPart, IStackFrame iStackFrame) {
        return null;
    }

    public Image getInstructionPointerImage(IEditorPart iEditorPart, IStackFrame iStackFrame) {
        return null;
    }

    public String getInstructionPointerText(IEditorPart iEditorPart, IStackFrame iStackFrame) {
        if (iEditorPart instanceof IscobolEditor) {
            int n = 0;
            try {
                n = ((IscobolStackFrame)iStackFrame).getLineNumber();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            if (n > 0) {
                IscobolEditor iscobolEditor = (IscobolEditor)iEditorPart;
                iscobolEditor.setDebugCurrentLine(n - 1);
            }
        }
        return null;
    }
}

