/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.plugins.editor.debug.IStepProgram;
import com.iscobol.plugins.editor.debug.IscobolDebugElement;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.debug.IscobolStackFrame;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.ui.IActionFilter;

public class IscobolThread
extends IscobolDebugElement
implements IDebugElement,
IThread,
IStepProgram,
IActionFilter,
IDisconnect {
    public static final String rcsid = "$Id: IscobolThread.java,v 1.7 2008/09/24 08:08:10 gianni Exp $";
    private String name;
    private int id;
    IscobolStackFrame[] frames;
    private static final IBreakpoint[] emptyBpArray = new IBreakpoint[0];

    public IscobolThread(IDebugTarget iDebugTarget, ILaunch iLaunch) {
        super(iDebugTarget, iLaunch);
    }

    public void init(ThreadObject threadObject) {
        this.name = threadObject.getName();
        this.id = threadObject.getId();
        this.frames = this.buildStackFrame(threadObject.getParStack(), this.getDebugTarget(), this.getLaunch());
    }

    public int getId() {
        return this.id;
    }

    public IBreakpoint[] getBreakpoints() {
        return emptyBpArray;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return this.frames;
        }
        return new IStackFrame[0];
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] iStackFrameArray = this.getStackFrames();
        IStackFrame iStackFrame = iStackFrameArray.length > 0 ? iStackFrameArray[0] : null;
        return iStackFrame;
    }

    public boolean hasStackFrames() throws DebugException {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended() && this.isCurrentThread();
    }

    public boolean isCurrentThread() {
        return ((IscobolDebugTarget)this.getDebugTarget()).isCurrentThread(this);
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended() && this.isCurrentThread();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public boolean isStepping() {
        return false;
    }

    public void setStepping(boolean bl) {
    }

    public void stepInto() throws DebugException {
        ((IscobolDebugTarget)this.getDebugTarget()).putCommand("step");
    }

    public void stepOver() throws DebugException {
        ((IscobolDebugTarget)this.getDebugTarget()).putCommand("next");
    }

    public void stepReturn() throws DebugException {
        ((IscobolDebugTarget)this.getDebugTarget()).putCommand("outpar");
    }

    public void stepOutProgram() {
        ((IscobolDebugTarget)this.getDebugTarget()).putCommand("outprog");
    }

    public boolean canStepOutProgram() {
        return this.isSuspended();
    }

    public boolean canDisconnect() {
        return this.getDebugTarget().canDisconnect();
    }

    public boolean isDisconnected() {
        return this.getDebugTarget().isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.getDebugTarget().disconnect();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    IscobolStackFrame[] buildStackFrame(ParagraphObject[] paragraphObjectArray, IDebugTarget iDebugTarget, ILaunch iLaunch) {
        int n = paragraphObjectArray != null ? paragraphObjectArray.length : 0;
        IscobolStackFrame[] iscobolStackFrameArray = new IscobolStackFrame[n];
        IProject iProject = ((IscobolDebugTarget)this.getDebugTarget()).getProject();
        for (int i = 0; i < n; ++i) {
            String string = paragraphObjectArray[i].getFile();
            if (iProject != null) {
                string = PluginUtilities.makeRelative((String)string, (IProject)iProject);
            }
            iscobolStackFrameArray[n - 1 - i] = new IscobolStackFrame(paragraphObjectArray[i].getName(), string, paragraphObjectArray[i].getLine(), paragraphObjectArray[i].getProgName(), this, iDebugTarget, iLaunch);
        }
        return iscobolStackFrameArray;
    }

    public boolean testAttribute(Object object, String string, String string2) {
        if (object instanceof IStepProgram && string.equals("canStepProgram")) {
            try {
                return new Boolean(string2).booleanValue() == ((IStepProgram)object).canStepOutProgram();
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (object instanceof IscobolThread && string.equals("isCurrentThread")) {
            try {
                return new Boolean(string2).booleanValue() == ((IscobolThread)object).isCurrentThread();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }
}

