/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.GetVariablesCommand;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.debug.IscobolDebugElement;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.debug.IscobolVariable;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class IscobolValue
extends IscobolDebugElement
implements IValue {
    public static final String rcsid = "$Id: IscobolValue.java,v 1.3 2008/02/27 14:40:13 gianni Exp $";
    private String value;
    private ArrayList<IscobolVariable> variables = new ArrayList();
    private boolean needRefresh = true;
    private IscobolVariable parent;
    private int type;

    public IscobolValue(String string, IscobolVariable iscobolVariable, IDebugTarget iDebugTarget, ILaunch iLaunch) {
        super(iDebugTarget, iLaunch);
        this.setValueString(string);
        this.parent = iscobolVariable;
        this.type = iscobolVariable.getType();
    }

    public IscobolValue(TreeNode treeNode, String string, IscobolVariable iscobolVariable, IDebugTarget iDebugTarget, ILaunch iLaunch) {
        super(iDebugTarget, iLaunch);
        this.parent = iscobolVariable;
        this.setValue(treeNode, string, false);
        this.type = iscobolVariable.getType();
    }

    public void setValue(TreeNode treeNode, String string, boolean bl) {
        this.setValueString(string);
        if (bl) {
            if (this.variables.size() > 0) {
                this.variables.clear();
                this.setNeedRefresh(true);
            }
        } else if (treeNode.getChildCount() > 0) {
            TreeNode[] treeNodeArray = treeNode.getChildren();
            for (int i = 0; i < treeNodeArray.length; ++i) {
                this.variables.add(new IscobolVariable(treeNodeArray[i], this.parent, this.getDebugTarget(), this.launch));
            }
        }
    }

    void setNeedRefresh(boolean bl) {
        this.needRefresh = bl;
        for (IscobolVariable iscobolVariable : this.variables) {
            try {
                ((IscobolValue)iscobolVariable.getValue()).setNeedRefresh(true);
            }
            catch (DebugException debugException) {}
        }
    }

    boolean getNeedRefresh() {
        return this.needRefresh;
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public void setValueString(String string) {
        this.value = string;
    }

    public String getValueString() throws DebugException {
        return this.value != null ? this.value : "";
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.needRefresh && (DebugUtilities.isGroupItem((int)this.type) || this.parent.getOccurs() > 0)) {
            GetVariablesCommand getVariablesCommand;
            VarName varName;
            this.needRefresh = false;
            int n = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxhexdumplength");
            int n2 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.hexdumpstartoffset");
            int n3 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxarraylength");
            int n4 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.startarrayindex");
            int n5 = IscobolEditorPlugin.getIntFromStore((String)"iscobol.debug.maxtextlength");
            String string = this.parent.getName();
            try {
                varName = IscobolDebugTarget.createVarName((String)string);
                getVariablesCommand = new GetVariablesCommand(varName, n, n2, n3, n4, n5);
            }
            catch (DebuggerException debuggerException) {
                return new IVariable[0];
            }
            varName = ((IscobolDebugTarget)this.getDebugTarget()).processCommand((DebugCommand)getVariablesCommand);
            if (varName != null && varName.getTree() != null) {
                TreeNode[] treeNodeArray = varName.getTree().getRoot().getChildren();
                for (int i = 0; i < treeNodeArray.length; ++i) {
                    IscobolVariable iscobolVariable = new IscobolVariable(treeNodeArray[i], this.parent, this.getDebugTarget(), this.getLaunch());
                    int n6 = this.variables.indexOf(iscobolVariable);
                    if (n6 >= 0) {
                        this.variables.set(n6, iscobolVariable);
                        continue;
                    }
                    this.variables.add(iscobolVariable);
                }
            }
        }
        return this.variables.toArray(new IVariable[this.variables.size()]);
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }
}

