/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug;

import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.debug.IscobolDebugElement;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.debug.IscobolValue;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ui.IActionFilter;

public class IscobolVariable
extends IscobolDebugElement
implements IVariable,
IActionFilter {
    private String fullName;
    private String name;
    private String subscript;
    private IscobolValue value;
    private IscobolVariable parent;
    private String hexDump;
    private int type;
    private int occurs;
    private boolean valueChanged;

    public IscobolVariable(TreeNode treeNode, IscobolVariable iscobolVariable, IDebugTarget iDebugTarget, ILaunch iLaunch) {
        super(iDebugTarget, iLaunch);
        this.fullName = treeNode.getVarName();
        this.setName(treeNode.getVarName());
        this.parent = iscobolVariable;
        this.setValue(treeNode, false);
    }

    private void setName(String string) {
        int n = string.indexOf(40);
        if (n >= 0) {
            this.subscript = string.substring(n);
            this.name = string.substring(0, n);
        } else {
            this.name = string;
        }
    }

    public void setValue(TreeNode treeNode, boolean bl) {
        String string = treeNode.getVarValue();
        DebugUtilities.VarValue varValue = DebugUtilities.parseVarValue((String)string);
        if (bl) {
            this.setValueChanged(this.hexDump != null && !this.hexDump.equals(varValue.hexDump));
        }
        this.hexDump = varValue.hexDump;
        this.type = varValue.type;
        this.occurs = varValue.occurs;
        boolean bl2 = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.variableview.showhex");
        String string2 = bl2 ? IscobolDebugTarget.getValueString((String)varValue.hexDump) : varValue.textValue;
        if (bl) {
            this.value.setValue(treeNode, string2, true);
        } else {
            this.value = treeNode.getChildCount() > 0 ? new IscobolValue(treeNode, string2, this, this.getDebugTarget(), this.getLaunch()) : new IscobolValue(string2, this, this.getDebugTarget(), this.getLaunch());
        }
    }

    public String getName() {
        return this.fullName;
    }

    public IscobolVariable getParent() {
        return this.parent;
    }

    public String getReferenceTypeName() throws DebugException {
        String string;
        switch (this.getType()) {
            case 1: {
                string = "Group Item";
                break;
            }
            case 3: {
                string = "Alphanumeric";
                break;
            }
            case 6: {
                string = "Ascii Storage";
                break;
            }
            case 7: {
                string = "Binary";
                break;
            }
            case 4: {
                string = "Decimal Storage";
                break;
            }
            case 8: {
                string = "Numeric Edited";
                break;
            }
            case 2: {
                string = "Object Reference";
                break;
            }
            case 5: {
                string = "Packed Decimal Storage";
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null && this.getOccurs() > 0) {
            string = string + " (Occurs " + this.getOccurs() + ")";
        }
        return string;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.valueChanged;
    }

    public void setValueChanged(boolean bl) {
        this.valueChanged = bl;
    }

    public void setValue(String string) {
        this.value.setValueString(string);
    }

    public void setValue(IValue iValue) throws DebugException {
        if (iValue instanceof IscobolValue) {
            this.value = (IscobolValue)iValue;
        }
    }

    public String getHexDump() {
        return this.hexDump;
    }

    public void setHexDump(String string) {
        this.hexDump = string;
    }

    public int getType() {
        return this.type;
    }

    public int getOccurs() {
        return this.occurs;
    }

    public boolean supportsValueModification() {
        try {
            return this.type != 2 && !this.value.hasVariables();
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    private boolean isValidParent(IscobolVariable iscobolVariable) {
        return iscobolVariable != null && iscobolVariable.getOccurs() == 0 && iscobolVariable.getType() == 1;
    }

    public boolean verifyValue(String string) throws DebugException {
        boolean bl;
        IscobolVariable iscobolVariable;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = IscobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.variableview.showhex");
        stringBuffer.append("let").append(" ");
        int n = this.fullName.indexOf("::");
        if (n >= 0) {
            stringBuffer.append(this.fullName.substring(0, n)).append(" ");
            stringBuffer.append("property").append(" ");
            stringBuffer.append(this.fullName.substring(n + 2)).append(" ");
        } else {
            if (bl2) {
                stringBuffer.append("-x").append(" ");
            }
            stringBuffer.append(this.name).append(" ");
            iscobolVariable = this.parent;
            while (this.isValidParent(iscobolVariable)) {
                stringBuffer.append("OF ").append(iscobolVariable.name).append(" ");
                iscobolVariable = iscobolVariable.getParent();
            }
            if (this.subscript != null) {
                stringBuffer.append(this.subscript).append(" ");
            }
        }
        stringBuffer.append("=").append(string);
        iscobolVariable = IscobolDebugTarget.getDefault().processCommand(stringBuffer.toString());
        boolean bl3 = bl = iscobolVariable.getReturnCode() == 0;
        if (bl) {
            IscobolDebugTarget.getDefault().refreshVariables();
            IscobolDebugTarget.getDefault().refreshVariablesView();
        }
        return bl;
    }

    public boolean verifyValue(IValue iValue) throws DebugException {
        return this.verifyValue(iValue.getValueString());
    }

    public boolean testAttribute(Object object, String string, String string2) {
        if (object instanceof IscobolVariable && string.equals("parent")) {
            return ((IscobolVariable)object).parent == null;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return ((IscobolVariable)object).fullName.equalsIgnoreCase(this.fullName);
    }
}

