/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.debug.detailpanes;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.debug.IscobolVariable;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;

public class IscobolVariableDetailPane
implements IDetailPane {
    public static final String ID = "IscobolVariableDetailPane";
    public static final String DESCRIPTION = "Hex Dump Viewer";
    IWorkbenchPartSite partSite;
    private Composite control;
    private StyledText text;

    public void init(IWorkbenchPartSite iWorkbenchPartSite) {
        this.partSite = iWorkbenchPartSite;
    }

    public Control createControl(Composite composite) {
        this.control = new Composite(composite, 0);
        this.control.setLayoutData((Object)new GridData(1808));
        this.control.setLayout((Layout)new FillLayout());
        this.text = new StyledText(this.control, 2816);
        this.text.setFont(IscobolEditorPlugin.getDefault().getFontProvider().getFont(new FontData("Courier New", 10, 0)));
        this.text.setEditable(false);
        return this.control;
    }

    public void dispose() {
        this.control.dispose();
    }

    public void display(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty() || !(iStructuredSelection.getFirstElement() instanceof IscobolVariable)) {
            this.text.setText("");
        } else {
            IscobolVariable iscobolVariable = (IscobolVariable)iStructuredSelection.getFirstElement();
            String string = iscobolVariable.getHexDump();
            this.text.setText(string);
        }
    }

    public boolean setFocus() {
        this.text.setFocus();
        return true;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return DESCRIPTION;
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

