/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.debug.IscobolBreakpoint;
import com.iscobol.plugins.editor.debug.IscobolDebugTarget;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;

public class BreakpointDialog
extends Dialog {
    private Text lineTxt;
    private Text fileTxt;
    private Button browseBtn;
    private Button enBtn;
    private Button hexBtn;
    private Button envBtn;
    private Button enableCondBtn;
    private Section enableCondSec;
    private String title;
    private IscobolBreakpoint breakpoint;
    private boolean programBreakpoint;
    private Text condTxt;
    private boolean modified;
    private IFile file;

    public BreakpointDialog(Shell shell, String string, boolean bl, IscobolBreakpoint iscobolBreakpoint) {
        super(shell);
        this.title = string;
        this.breakpoint = iscobolBreakpoint;
        this.programBreakpoint = bl;
        if (iscobolBreakpoint != null) {
            this.programBreakpoint = iscobolBreakpoint.getMarker().getAttribute("_programName", (String)null) != null;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    public IscobolBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected Control createDialogArea(Composite composite) {
        Object object;
        GridData gridData;
        Label label;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        if (!this.programBreakpoint) {
            label = new Label((Composite)group, 0);
            label.setText(IsresourceBundle.getString((String)"set_at_line_lbl"));
            this.lineTxt = new Text((Composite)group, 2048);
            gridData = new GridData();
            gridData.widthHint = 60;
            gridData.horizontalSpan = 2;
            this.lineTxt.setLayoutData((Object)gridData);
        }
        label = new Label((Composite)group, 0);
        label.setText(IsresourceBundle.getString((String)(this.programBreakpoint ? "set_program_name_lbl" : "filename_lbl")));
        this.fileTxt = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.widthHint = 220;
        if (this.programBreakpoint) {
            gridData.horizontalSpan = 2;
        }
        this.fileTxt.setLayoutData((Object)gridData);
        if (!this.programBreakpoint) {
            this.browseBtn = new Button((Composite)group, 8);
            this.browseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
            this.browseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.enBtn = new Button((Composite)group, 32);
        this.enBtn.setText(IsresourceBundle.getString((String)"enabled_lbl"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.enBtn.setLayoutData((Object)gridData);
        if (!this.programBreakpoint) {
            this.enableCondBtn = new Button((Composite)group, 32);
            this.enableCondBtn.setText("Enable Condition");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            this.enableCondBtn.setLayoutData((Object)gridData);
            this.enableCondSec = new Section((Composite)group, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.enableCondSec.setLayoutData((Object)gridData);
            object = new Group((Composite)this.enableCondSec, 0);
            object.setText("Condition");
            this.enableCondSec.setClient((Control)object);
            gridLayout = new GridLayout();
            object.setLayout((Layout)gridLayout);
            this.envBtn = new Button((Composite)object, 32);
            this.envBtn.setText(IsresourceBundle.getString((String)"envname_lbl"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.envBtn.setLayoutData((Object)gridData);
            this.hexBtn = new Button((Composite)object, 32);
            this.hexBtn.setText(IsresourceBundle.getString((String)"hexadecimal_lbl"));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.hexBtn.setLayoutData((Object)gridData);
            this.condTxt = new Text((Composite)object, 2626);
            gridData = new GridData(768);
            gridData.heightHint = 70;
            this.condTxt.setLayoutData((Object)gridData);
            this.enableCondSec.setExpanded(false);
        }
        if (this.breakpoint != null) {
            try {
                this.enBtn.setSelection(this.breakpoint.isEnabled());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (!this.programBreakpoint) {
                this.lineTxt.setText("" + this.breakpoint.getLineNumber());
                this.lineTxt.setEditable(false);
                this.fileTxt.setText(this.breakpoint.getStorageName());
                this.browseBtn.setVisible(false);
                object = this.breakpoint.getVariableName();
                String string = this.breakpoint.getEnvName();
                if (object != null || string != null) {
                    String string2;
                    this.enableCondBtn.setSelection(true);
                    this.enableCondSec.setExpanded(true);
                    String string3 = string2 = string != null ? string : object;
                    if (string2.length() > 0) {
                        this.condTxt.setText(string2);
                    }
                    boolean bl = this.breakpoint.isHexadecimal();
                    this.envBtn.setSelection(string != null);
                    this.hexBtn.setSelection(bl && string == null);
                }
                if (IscobolDebugTarget.getDefault() == null || !IscobolDebugTarget.getDefault().isSuspended()) {
                    this.enableCondBtn.setEnabled(false);
                    this.condTxt.setEnabled(false);
                    this.hexBtn.setEnabled(false);
                    this.envBtn.setEnabled(false);
                }
            } else {
                this.fileTxt.setText(this.breakpoint.getMarker().getAttribute("_programName", ""));
            }
        } else {
            this.enBtn.setSelection(true);
            if (!this.programBreakpoint) {
                object = PluginUtilities.getActiveIscobolEditor();
                if (object != null && object.getFileEditorInput() != null) {
                    this.file = object.getFileEditorInput().getFile();
                    this.fileTxt.setText(this.file.getName());
                    int n = object.getViewer().getTextWidget().getCaretOffset();
                    try {
                        this.lineTxt.setText(Integer.toString(object.getViewer().getDocument().getLineOfOffset(n) + 1));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (IscobolDebugTarget.getDefault() == null || !IscobolDebugTarget.getDefault().isSuspended()) {
                    this.enableCondBtn.setEnabled(false);
                    this.enableCondBtn.setSelection(false);
                    this.enableCondSec.setExpanded(false);
                }
            }
        }
        if (!this.programBreakpoint) {
            this.fileTxt.setEditable(false);
            this.enableCondBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        return composite2;
    }

    private boolean checkLineNumber() {
        try {
            int n = Integer.parseInt(this.lineTxt.getText());
            if (n > 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private void logError(String string) {
        MessageBox messageBox = new MessageBox(this.getShell(), 33);
        messageBox.setText(this.getShell().getText());
        messageBox.setMessage(string);
        messageBox.open();
    }

    protected void okPressed() {
        try {
            if (this.breakpoint != null) {
                this.setModified();
                this.breakpoint.setEnabled(this.enBtn.getSelection());
                if (!this.programBreakpoint) {
                    this.setConditionAttributes();
                }
                this.breakpoint.getMarker().setAttribute("SKIP_EVENT", false);
            } else if (this.programBreakpoint) {
                if (this.fileTxt.getText().length() == 0) {
                    this.logError(IsresourceBundle.getString((String)"set_program_name_lbl"));
                    return;
                }
                this.breakpoint = new IscobolBreakpoint(this.fileTxt.getText());
            } else {
                if (!this.checkLineNumber()) {
                    this.logError(IsresourceBundle.getString((String)"line_no_invalid_value_msg"));
                    return;
                }
                int n = Integer.parseInt(this.lineTxt.getText());
                if (this.file == null) {
                    this.logError(IsresourceBundle.getString((String)"set_filename_msg"));
                    return;
                }
                if (!IscobolDebugTarget.canToggleLineBreakpoints((IFile)this.file, (int)n)) {
                    this.logError(IsresourceBundle.getString((String)"no_verb_at_line_msg") + " " + n + ", file '" + this.file.getName() + "'");
                    return;
                }
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorReference[] iEditorReferenceArray = iWorkbenchPage.findEditors((IEditorInput)new FileEditorInput(this.file), IscobolEditor.ID, 3);
                IscobolEditor iscobolEditor = iEditorReferenceArray.length > 0 ? (IscobolEditor)iEditorReferenceArray[0].getEditor(false) : null;
                this.breakpoint = new IscobolBreakpoint((IStorage)this.file, n, (IEditorPart)iscobolEditor);
                this.setConditionAttributes();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        super.okPressed();
    }

    private void setConditionAttributes() throws CoreException {
        if (this.enableCondBtn.getSelection()) {
            if (this.envBtn.getSelection()) {
                this.breakpoint.setEnvName(this.condTxt.getText());
                this.breakpoint.setHexadecimal(false);
                this.breakpoint.setVariableName(null);
            } else {
                this.breakpoint.setEnvName(null);
                this.breakpoint.setHexadecimal(this.hexBtn.getSelection());
                this.breakpoint.setVariableName(this.condTxt.getText());
            }
        } else {
            this.breakpoint.setEnvName(null);
            this.breakpoint.setPropertyName(null);
            this.breakpoint.setHexadecimal(false);
            this.breakpoint.setVariableName(null);
        }
    }

    private void setModified() throws CoreException {
        if (!this.modified) {
            this.breakpoint.getMarker().setAttribute("SKIP_EVENT", true);
        }
        this.modified = true;
    }

    static /* synthetic */ IFile access$100(BreakpointDialog breakpointDialog) {
        return breakpointDialog.file;
    }

    static /* synthetic */ IFile access$102(BreakpointDialog breakpointDialog, IFile iFile) {
        breakpointDialog.file = iFile;
        return breakpointDialog.file;
    }

    static /* synthetic */ Text access$300(BreakpointDialog breakpointDialog) {
        return breakpointDialog.fileTxt;
    }

    static /* synthetic */ Button access$400(BreakpointDialog breakpointDialog) {
        return breakpointDialog.enableCondBtn;
    }

    static /* synthetic */ Section access$500(BreakpointDialog breakpointDialog) {
        return breakpointDialog.enableCondSec;
    }
}

