/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ClasspathGroup {
    public static final String CLASSPATH_PROPERTY = "classpath";
    private Tree classpathTree;
    private TreeItem iscobolItem;
    private TreeItem projectItem;
    private TreeItem userItem;
    private Button addJarBtn;
    private Button addFolderBtn;
    private Button removeBtn;
    private String classpath = "";
    private Control control;
    private boolean modified;
    private IPropertyChangeListener propertyChangeListener;
    private IProject project;

    public void init(IProject iProject, String string) {
        this.init(iProject, string, false);
    }

    public void init(IProject iProject, String string, boolean bl) {
        this.project = iProject;
        this.classpath = string;
        if (this.classpath == null) {
            this.classpath = "";
        }
        if (this.control != null) {
            this.initData();
        }
        this.modified = false;
    }

    public IPropertyChangeListener getPropertyChangeListener() {
        return this.propertyChangeListener;
    }

    public void setPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListener = iPropertyChangeListener;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public Control createControl(Composite composite) {
        File file;
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setText(IsresourceBundle.getString((String)"jar_class_lbl"));
        this.classpathTree = new Tree((Composite)group, 2050);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 500;
        this.classpathTree.setLayoutData((Object)gridData);
        this.iscobolItem = new TreeItem(this.classpathTree, 0);
        this.iscobolItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/iscobol16x16.png"));
        this.iscobolItem.setText("isCOBOL Entries");
        try {
            file = new File(PluginUtilities.getPluginInstallLocation((String)"com.iscobol.plugins.libraries")).getAbsoluteFile();
            File[] fileArray = new File(file.getPath() + File.separator + "libs").listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            for (int i = 0; i < fileArray.length; ++i) {
                TreeItem treeItem = new TreeItem(this.iscobolItem, 0);
                treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/jar.gif"));
                treeItem.setText(fileArray[i].getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.userItem = new TreeItem(this.classpathTree, 0);
        this.userItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/classpath.gif"));
        this.userItem.setText("User Entries");
        file = new Composite((Composite)group, 0);
        gridLayout = new GridLayout();
        file.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        file.setLayoutData(gridData);
        this.addJarBtn = new Button((Composite)file, 8);
        this.addJarBtn.setText(IsresourceBundle.getString((String)"add_jar_lbl"));
        gridData = new GridData(2);
        this.addJarBtn.setLayoutData((Object)gridData);
        this.addJarBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData(768);
        this.addJarBtn.setLayoutData((Object)gridData);
        this.addFolderBtn = new Button((Composite)file, 8);
        this.addFolderBtn.setText(IsresourceBundle.getString((String)"add_class_fld_lbl"));
        gridData = new GridData(2);
        this.addFolderBtn.setLayoutData((Object)gridData);
        this.addFolderBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn = new Button((Composite)file, 8);
        this.removeBtn.setText(IsresourceBundle.getString((String)"remove_lbl"));
        gridData = new GridData(2);
        this.removeBtn.setLayoutData((Object)gridData);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData(768);
        this.removeBtn.setLayoutData((Object)gridData);
        this.addJarBtn.setEnabled(false);
        this.addFolderBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.classpathTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.initData();
        this.control = group;
        return this.control;
    }

    private boolean isJar(String string) {
        return string.endsWith(".jar") || string.endsWith(".zip");
    }

    private void initData() {
        TreeItem treeItem;
        Object object;
        Object object2;
        Object object3;
        if (this.project != null) {
            if (this.projectItem != null) {
                this.projectItem.removeAll();
            } else {
                this.projectItem = new TreeItem(this.classpathTree, 0, 1);
            }
            this.projectItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/prj.gif"));
            this.projectItem.setText("Project Entries - " + this.project.getName());
            object3 = PluginUtilities.getPersistentProperty((IResource)this.project, (String)"Default", (String)"iscobol.classpath");
            if (object3 != null) {
                object2 = new StringTokenizer((String)object3, File.pathSeparator);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    treeItem = new TreeItem(this.projectItem, 0);
                    treeItem.setText((String)object);
                    treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage(this.isJar((String)object) ? "/jar.gif" : "/folder.gif"));
                }
            }
        } else if (this.projectItem != null) {
            this.projectItem.dispose();
        }
        this.userItem.removeAll();
        object3 = new StringTokenizer(this.classpath, File.pathSeparator);
        while (((StringTokenizer)object3).hasMoreTokens()) {
            object2 = ((StringTokenizer)object3).nextToken();
            object = new File((String)object2);
            treeItem = new TreeItem(this.userItem, 0);
            treeItem.setText((String)object2);
            treeItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage(((File)object).isDirectory() ? "/folder.gif" : "/jar.gif"));
        }
    }

    private void buildClasspath() {
        StringBuilder stringBuilder = new StringBuilder();
        TreeItem[] treeItemArray = this.userItem.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(treeItemArray[i].getText());
        }
        this.classpath = stringBuilder.toString();
        this.modified = true;
    }

    private void firePropertyChange() {
        if (this.propertyChangeListener != null) {
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, CLASSPATH_PROPERTY, null, (Object)this.classpath));
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String string) {
        this.init(this.project, string);
        this.modified = true;
    }

    public void setProject(IProject iProject) {
        this.init(iProject, this.classpath);
    }

    static /* synthetic */ Button access$000(ClasspathGroup classpathGroup) {
        return classpathGroup.addJarBtn;
    }

    static /* synthetic */ TreeItem access$100(ClasspathGroup classpathGroup) {
        return classpathGroup.userItem;
    }

    static /* synthetic */ void access$200(ClasspathGroup classpathGroup) {
        classpathGroup.buildClasspath();
    }

    static /* synthetic */ void access$300(ClasspathGroup classpathGroup) {
        classpathGroup.firePropertyChange();
    }

    static /* synthetic */ Button access$400(ClasspathGroup classpathGroup) {
        return classpathGroup.addFolderBtn;
    }

    static /* synthetic */ Tree access$500(ClasspathGroup classpathGroup) {
        return classpathGroup.classpathTree;
    }

    static /* synthetic */ Button access$600(ClasspathGroup classpathGroup) {
        return classpathGroup.removeBtn;
    }
}

