/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DisplayVariableDialog
extends Dialog {
    private Text varTxt;
    private Text propTxt;
    private Text valTxt;
    private Button setValBtn;
    private Label propLbl;
    private Button envBtn;
    private String defVar;
    private String title;
    private String commandString;
    private boolean asHex = IscobolEditorPlugin.getDefault().getPreferenceStore().getBoolean("iscobol.variableview.showhex");

    public DisplayVariableDialog(Shell shell, String string, String string2) {
        super(shell);
        this.title = string;
        this.defVar = string2;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        this.envBtn = new Button((Composite)group, 32);
        this.envBtn.setText(IsresourceBundle.getString((String)"environment_var_lbl"));
        this.envBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.envBtn.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group, 0);
        label.setText(IsresourceBundle.getString((String)"varname_lbl") + ":");
        this.varTxt = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.widthHint = 220;
        this.varTxt.setLayoutData((Object)gridData);
        this.propLbl = new Label((Composite)group, 0);
        this.propLbl.setText(IsresourceBundle.getString((String)"propname_lbl") + ":");
        this.propTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.propTxt.setLayoutData((Object)gridData);
        this.setValBtn = new Button((Composite)group, 32);
        this.setValBtn.setText(this.asHex ? IsresourceBundle.getString((String)"set_hex_value_lbl") : IsresourceBundle.getString((String)"set_value_lbl"));
        this.setValBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.valTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.valTxt.setLayoutData((Object)gridData);
        this.valTxt.setEnabled(this.setValBtn.getSelection());
        if (this.defVar != null) {
            this.varTxt.setText(this.defVar);
            this.varTxt.selectAll();
        }
        return composite2;
    }

    protected void okPressed() {
        String string = this.varTxt.getText();
        if (string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.envBtn.getSelection()) {
                if (this.setValBtn.getSelection()) {
                    stringBuffer.append("let");
                    stringBuffer.append(" ");
                    stringBuffer.append("-env");
                    stringBuffer.append(" ");
                    stringBuffer.append(string);
                    stringBuffer.append(" =");
                    stringBuffer.append(this.valTxt.getText());
                    DebugResponse debugResponse = DebuggerInvoker.processCommand((String)stringBuffer.toString());
                    if (debugResponse.getReturnCode() != 0) {
                        MessageBox messageBox = new MessageBox(this.getShell(), 33);
                        messageBox.setText(this.getShell().getText());
                        messageBox.setMessage(debugResponse.getMessage());
                        messageBox.open();
                        return;
                    }
                }
                stringBuffer = new StringBuffer();
                stringBuffer.append("display");
                stringBuffer.append(" ");
                stringBuffer.append("-env");
                stringBuffer.append(" ");
                stringBuffer.append(string);
                this.commandString = stringBuffer.toString();
            } else {
                String string2;
                if (this.setValBtn.getSelection()) {
                    stringBuffer.append("let");
                    if (this.asHex) {
                        stringBuffer.append(" ");
                        stringBuffer.append("-x");
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(string);
                    string2 = this.propTxt.getText();
                    if (string2.length() > 0) {
                        stringBuffer.append(" ");
                        stringBuffer.append("property");
                        stringBuffer.append(" ");
                        stringBuffer.append(string2);
                    }
                    stringBuffer.append(" =");
                    stringBuffer.append(this.valTxt.getText());
                    DebugResponse debugResponse = DebuggerInvoker.processCommand((String)stringBuffer.toString());
                    if (debugResponse.getReturnCode() != 0) {
                        MessageBox messageBox = new MessageBox(this.getShell(), 33);
                        messageBox.setText(this.getShell().getText());
                        messageBox.setMessage(debugResponse.getMessage());
                        messageBox.open();
                        return;
                    }
                }
                stringBuffer = new StringBuffer();
                stringBuffer.append("display");
                stringBuffer.append(" ");
                if (this.asHex) {
                    stringBuffer.append("-x");
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string);
                string2 = this.propTxt.getText();
                if (string2.length() > 0) {
                    stringBuffer.append(" ");
                    stringBuffer.append("property");
                    stringBuffer.append(" ");
                    stringBuffer.append(string2);
                }
                this.commandString = stringBuffer.toString();
            }
        } else {
            this.commandString = null;
        }
        super.okPressed();
    }

    public String getCommandString() {
        return this.commandString;
    }

    static /* synthetic */ Button access$000(DisplayVariableDialog displayVariableDialog) {
        return displayVariableDialog.envBtn;
    }

    static /* synthetic */ Label access$100(DisplayVariableDialog displayVariableDialog) {
        return displayVariableDialog.propLbl;
    }

    static /* synthetic */ Text access$200(DisplayVariableDialog displayVariableDialog) {
        return displayVariableDialog.propTxt;
    }

    static /* synthetic */ Button access$300(DisplayVariableDialog displayVariableDialog) {
        return displayVariableDialog.setValBtn;
    }

    static /* synthetic */ Text access$400(DisplayVariableDialog displayVariableDialog) {
        return displayVariableDialog.valTxt;
    }
}

