/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.debug.IscobolWatchpoint;
import com.iscobol.plugins.editor.dialogs.MonitorDialog;
import com.iscobol.plugins.editor.util.IsFragment;
import com.iscobol.plugins.editor.util.PluginUtilities;
import com.iscobol.plugins.editor.util.VarDecl;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MonitorDialog
extends Dialog {
    public static final String rcsid = "$Id: MonitorDialog.java,v 1.13 2008/10/02 11:48:13 gianni Exp $";
    private Text varTxt;
    private Text propTxt;
    private Text valTxt;
    private Button enBtn;
    private Button hexBtn;
    private Button envBtn;
    private Combo whenCmb;
    private String title;
    private IscobolWatchpoint watchpoint;
    private String defVar;
    private String defProp;
    private boolean modified;
    private boolean envVar;

    public MonitorDialog(Shell shell, String string, IscobolWatchpoint iscobolWatchpoint, String string2, String string3, boolean bl) {
        super(shell);
        this.title = string;
        this.watchpoint = iscobolWatchpoint;
        this.defVar = string2;
        this.defProp = string3;
        this.envVar = bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        1 var6_5 = new /* Unavailable Anonymous Inner Class!! */;
        this.envBtn = new Button((Composite)group, 32);
        this.envBtn.setText(IsresourceBundle.getString((String)"envname_lbl"));
        this.envBtn.addSelectionListener((SelectionListener)var6_5);
        this.envBtn.setSelection(this.envVar);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.envBtn.setLayoutData((Object)gridData);
        this.hexBtn = new Button((Composite)group, 32);
        this.hexBtn.addSelectionListener((SelectionListener)var6_5);
        this.hexBtn.setText(IsresourceBundle.getString((String)"hexadecimal_lbl"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.hexBtn.setLayoutData((Object)gridData);
        this.enBtn = new Button((Composite)group, 32);
        this.enBtn.setText(IsresourceBundle.getString((String)"enabled_lbl"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.enBtn.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group, 0);
        label.setText(IsresourceBundle.getString((String)"varname_lbl"));
        this.varTxt = new Text((Composite)group, 2048);
        gridData = new GridData();
        gridData.widthHint = 220;
        this.varTxt.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText(IsresourceBundle.getString((String)"propname_lbl"));
        this.propTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.propTxt.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText(IsresourceBundle.getString((String)"notify_when_lbl"));
        this.whenCmb = new Combo((Composite)group, 12);
        this.whenCmb.add("changed");
        this.whenCmb.add("=");
        this.whenCmb.add("!=");
        this.whenCmb.add(">");
        this.whenCmb.add("<");
        this.whenCmb.add(">=");
        this.whenCmb.add("<=");
        this.whenCmb.setData("changed", (Object)"ALWAYS");
        this.whenCmb.select(0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.whenCmb.setLayoutData((Object)gridData);
        label = new Label((Composite)group, 0);
        label.setText(IsresourceBundle.getString((String)"value_lbl"));
        this.valTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.valTxt.setLayoutData((Object)gridData);
        if (this.watchpoint != null) {
            String string;
            String string2;
            this.propTxt.setEditable(false);
            this.varTxt.setEditable(false);
            this.envBtn.setEnabled(false);
            String string3 = this.watchpoint.getEnvName();
            String string4 = string2 = string3 != null ? string3 : this.watchpoint.getVariableName();
            if (string2.length() > 0) {
                this.varTxt.setText(string2);
                this.varTxt.selectAll();
            }
            try {
                this.enBtn.setSelection(this.watchpoint.isEnabled());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (string3 != null || this.watchpoint.isHexadecimal()) {
                if (string3 != null) {
                    this.envBtn.setSelection(true);
                }
                if (this.watchpoint.isHexadecimal()) {
                    this.hexBtn.setSelection(true);
                }
            }
            if (this.watchpoint.getPropertyName() != null) {
                this.propTxt.setText(this.watchpoint.getPropertyName());
            }
            if ((string = this.watchpoint.getConditionType()) != null) {
                this.select(string);
                String string5 = this.watchpoint.getConditionValue();
                if (string5 != null) {
                    this.valTxt.setText(string5);
                }
            }
        } else {
            if (this.defVar != null) {
                this.varTxt.setText(this.defVar);
                this.enBtn.setSelection(true);
                this.varTxt.setEditable(false);
                if (this.defProp != null) {
                    this.propTxt.setText(this.defProp);
                }
            } else {
                this.enBtn.setSelection(true);
            }
            this.propTxt.setEnabled(!this.envBtn.getSelection());
        }
        return composite2;
    }

    private void select(String string) {
        String[] stringArray = this.whenCmb.getItems();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            this.whenCmb.select(i);
            break;
        }
    }

    protected void okPressed() {
        if (this.watchpoint != null) {
            try {
                if (this.enBtn.getSelection() != this.watchpoint.isEnabled()) {
                    this.setModified();
                    this.watchpoint.setEnabled(this.enBtn.getSelection());
                }
                if (this.hexBtn.getSelection() != this.watchpoint.isHexadecimal()) {
                    this.setModified();
                    this.watchpoint.setHexadecimal(this.hexBtn.getSelection());
                }
                if (!this.whenCmb.getText().equals(this.watchpoint.getConditionType("always"))) {
                    this.setModified();
                    String string = (String)this.whenCmb.getData(this.whenCmb.getText());
                    this.watchpoint.setConditionType(string != null ? string : this.whenCmb.getText());
                }
                if (!this.valTxt.getText().equals(this.watchpoint.getConditionValue(""))) {
                    this.setModified();
                    this.watchpoint.setConditionValue(this.valTxt.getText());
                }
                if (this.modified) {
                    this.watchpoint.getMarker().setAttribute("SKIP_EVENT", false);
                }
            }
            catch (CoreException coreException) {}
        } else {
            String string = this.varTxt.getText();
            if (string.length() > 0) {
                String string2 = string;
                String string3 = this.envBtn.getSelection() ? string : null;
                string = this.propTxt.getText();
                String string4 = string.length() > 0 ? string : null;
                String string5 = this.whenCmb.getSelectionIndex() > 0 ? this.whenCmb.getItem(this.whenCmb.getSelectionIndex()) : null;
                String string6 = string5 != null ? this.valTxt.getText() : null;
                IscobolEditor iscobolEditor = PluginUtilities.getActiveIscobolEditor();
                int n = -1;
                IStorage iStorage = null;
                if (string3 == null) {
                    try {
                        VarDecl varDecl;
                        DisplayCommand displayCommand = (DisplayCommand)DebuggerInvoker.parseCommand((int)5, (DebugTM)new DebugTM(string2, " ,;(:=)+*\"<>", new DebugCommand[0]));
                        VarName varName = displayCommand.getVarName();
                        IsFragment isFragment = iscobolEditor.getProgramFragment();
                        if (isFragment != null && (varDecl = isFragment.getVarDecl(varName.getName())) != null) {
                            VarDecl[] varDeclArray = varDecl.getDuplicatesVars();
                            if (varDeclArray.length == 1) {
                                n = varDeclArray[0].getStartLine();
                            } else {
                                for (int i = 0; i < varDeclArray.length && n < 0; ++i) {
                                    boolean bl = true;
                                    IsFragment isFragment2 = varDeclArray[i].getParent();
                                    for (int j = 0; j < varName.getNAncestors() && bl; ++j) {
                                        if (isFragment2 == null || !isFragment2.getName().equalsIgnoreCase(varName.getAncestor(j))) {
                                            bl = false;
                                            continue;
                                        }
                                        isFragment2 = isFragment2.getParent();
                                    }
                                    if (!bl) continue;
                                    n = isFragment2.getStartLine();
                                }
                            }
                        }
                    }
                    catch (DebuggerException debuggerException) {
                        // empty catch block
                    }
                    if (n >= 0) {
                        iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IResource.class);
                        if (iStorage == null) {
                            iStorage = (IStorage)iscobolEditor.getEditorInput().getAdapter(IStorage.class);
                        }
                        try {
                            this.watchpoint = new IscobolWatchpoint(string3, string4, string2, this.hexBtn.getSelection(), this.enBtn.getSelection(), string5, string6, iStorage, n + 1, iscobolEditor);
                        }
                        catch (CoreException coreException) {}
                    } else {
                        PluginUtilities.logError((String)IsresourceBundle.getString((String)"data_item_not_found_msg"));
                    }
                } else {
                    try {
                        this.watchpoint = new IscobolWatchpoint(string3, null, null, false, true, string5, string6, iStorage, 1, iscobolEditor);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        }
        super.okPressed();
    }

    private void setModified() throws CoreException {
        if (!this.modified) {
            this.watchpoint.getMarker().setAttribute("SKIP_EVENT", true);
        }
        this.modified = true;
    }

    public IscobolWatchpoint getWatchpoint() {
        return this.watchpoint;
    }

    public boolean isModified() {
        return this.modified;
    }

    static /* synthetic */ Button access$000(MonitorDialog monitorDialog) {
        return monitorDialog.envBtn;
    }

    static /* synthetic */ Button access$100(MonitorDialog monitorDialog) {
        return monitorDialog.hexBtn;
    }

    static /* synthetic */ Text access$200(MonitorDialog monitorDialog) {
        return monitorDialog.propTxt;
    }
}

