/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.dialogs;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class WSDL2WrkDialog
extends Dialog {
    private Button v11Btn;
    private Text workspaceInputTxt;
    private Text fileSystemInputTxt;
    private Text remoteUrlInputTxt;
    private Text fileSystemOutputTxt;
    private Text workspaceOutputTxt;
    private Button workspaceInputBtn;
    private Button fileSystemInputBtn;
    private Button remoteUrlInputBtn;
    private Button workspaceOutputBtn;
    private Button fileSystemOutputBtn;
    private Button workspaceInputBrowseBtn;
    private Button fileSystemInputBrowseBtn;
    private Button workspaceOutputBrowseBtn;
    private Button fileSystemOutputBrowseBtn;
    private String input;
    private String output;
    private boolean v11;

    public WSDL2WrkDialog(Shell shell) {
        super(shell);
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean getV11Version() {
        return this.v11;
    }

    public void okPressed() {
        boolean bl = true;
        bl = this.workspaceInputBtn.getSelection() ? (bl &= this.validateWorkspaceInput()) : (this.fileSystemInputBtn.getSelection() ? (bl &= this.validateFileSystemInput()) : (bl &= this.validateRemoteUrlInput()));
        bl = this.workspaceOutputBtn.getSelection() ? (bl &= this.validateWorkspaceOutput()) : (bl &= this.validateFileSystemOutput());
        if (bl) {
            this.v11 = this.v11Btn.getSelection();
            this.input = this.workspaceInputBtn.getSelection() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.workspaceInputTxt.getText())).getLocation().toString() : (this.fileSystemInputBtn.getSelection() ? this.fileSystemInputTxt.getText() : this.remoteUrlInputTxt.getText());
            this.output = this.workspaceOutputBtn.getSelection() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.workspaceOutputTxt.getText())).getLocation().toString() : this.fileSystemOutputTxt.getText();
            super.okPressed();
        }
    }

    private void showErrorMessage(String string) {
        MessageBox messageBox = new MessageBox(this.getShell(), 33);
        messageBox.setText("Error");
        messageBox.setMessage(string);
        messageBox.open();
    }

    private boolean validateWorkspaceInput() {
        if (this.workspaceInputTxt.getText().length() > 0) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.workspaceInputTxt.getText()));
            if (iFile.exists()) {
                return true;
            }
            this.showErrorMessage("Invalid Workspace Input");
            return false;
        }
        this.showErrorMessage("Set Workspace Input");
        return false;
    }

    private boolean validateFileSystemInput() {
        if (this.fileSystemInputTxt.getText().length() > 0) {
            File file = new File(this.fileSystemInputTxt.getText());
            if (file.exists() && !file.isDirectory() && file.getName().endsWith(".wsdl")) {
                return true;
            }
            this.showErrorMessage("Invalid Filesystem Input");
            return false;
        }
        this.showErrorMessage("Set Filesystem Input");
        return false;
    }

    private boolean validateRemoteUrlInput() {
        if (this.remoteUrlInputTxt.getText().length() > 0) {
            try {
                new URL(this.remoteUrlInputTxt.getText());
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                this.showErrorMessage("Invalid Remote URL Input");
                return false;
            }
        }
        this.showErrorMessage("Set Remote URL Input");
        return false;
    }

    private boolean validateFileSystemOutput() {
        if (this.fileSystemOutputTxt.getText().length() > 0) {
            File file = new File(this.fileSystemOutputTxt.getText());
            if (file.getParentFile() != null) {
                return true;
            }
            this.showErrorMessage("Invalid Filesystem Output");
            return false;
        }
        this.showErrorMessage("Set Filesystem Output");
        return false;
    }

    private boolean validateWorkspaceOutput() {
        if (this.workspaceOutputTxt.getText().length() > 0) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.workspaceOutputTxt.getText()));
            if (iFile.getParent() != null && iFile.getParent().exists()) {
                return true;
            }
            this.showErrorMessage("Invalid Workspace Output");
            return false;
        }
        this.showErrorMessage("Set Workspace Output");
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("WSDL2Wrk Utility");
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        Button button = super.createButton(composite, n, string, bl);
        if (n == 0) {
            button.setText("Run");
        }
        return button;
    }

    protected Control createDialogArea(Composite composite) {
        IFile iFile;
        IStructuredSelection iStructuredSelection;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.v11Btn = new Button(composite2, 32);
        this.v11Btn.setText("Use WSDL version 1.1");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        this.v11Btn.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setText("Input");
        gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        this.workspaceInputBtn = new Button((Composite)group, 16);
        this.workspaceInputBtn.setText("Workspace:");
        this.workspaceInputBtn.setSelection(true);
        this.workspaceInputTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.workspaceInputTxt.setLayoutData((Object)gridData);
        this.workspaceInputBrowseBtn = new Button((Composite)group, 8);
        this.workspaceInputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemInputBtn = new Button((Composite)group, 16);
        this.fileSystemInputBtn.setText("Filesystem:");
        this.fileSystemInputTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.fileSystemInputTxt.setLayoutData((Object)gridData);
        this.fileSystemInputTxt.setEnabled(false);
        this.fileSystemInputBrowseBtn = new Button((Composite)group, 8);
        this.fileSystemInputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemInputBrowseBtn.setEnabled(false);
        this.remoteUrlInputBtn = new Button((Composite)group, 16);
        this.remoteUrlInputBtn.setText("Remote URL:");
        this.remoteUrlInputTxt = new Text((Composite)group, 2048);
        this.remoteUrlInputTxt.setEnabled(false);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.remoteUrlInputTxt.setLayoutData((Object)gridData);
        new Label((Composite)group, 0);
        Group group2 = new Group(composite2, 0);
        group2.setText("Output");
        gridData = new GridData(768);
        group2.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group2.setLayout((Layout)gridLayout);
        this.workspaceOutputBtn = new Button((Composite)group2, 16);
        this.workspaceOutputBtn.setText("Workspace:");
        this.workspaceOutputBtn.setSelection(true);
        this.workspaceOutputTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.workspaceOutputTxt.setLayoutData((Object)gridData);
        this.workspaceOutputBrowseBtn = new Button((Composite)group2, 8);
        this.workspaceOutputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemOutputBtn = new Button((Composite)group2, 16);
        this.fileSystemOutputBtn.setText("Filesystem:");
        this.fileSystemOutputTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 500;
        this.fileSystemOutputTxt.setLayoutData((Object)gridData);
        this.fileSystemOutputTxt.setEnabled(false);
        this.fileSystemOutputBrowseBtn = new Button((Composite)group2, 8);
        this.fileSystemOutputBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.fileSystemOutputBrowseBtn.setEnabled(false);
        IFile iFile2 = null;
        ISelection iSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof IFile && (iFile = (IFile)iStructuredSelection.getFirstElement()).getFileExtension().equals("wsdl")) {
            iFile2 = iFile;
        }
        if (iFile2 != null) {
            this.setWorkspaceInputFile(iFile2);
        }
        this.workspaceInputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemInputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.remoteUrlInputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.workspaceOutputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemOutputBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.workspaceInputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemInputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.workspaceOutputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fileSystemOutputBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void setWorkspaceInputFile(IFile iFile) {
        this.workspaceInputTxt.setText(iFile.getFullPath().toString());
        try {
            if (iFile.getProject() != null && iFile.getProject().hasNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature")) {
                String string = PluginUtilities.getCurrentSettingMode((IResource)iFile.getProject());
                IContainer[] iContainerArray = PluginUtilities.getCopyFolders((IProject)iFile.getProject(), (String)string);
                if (iContainerArray != null && iContainerArray.length > 0) {
                    IFile iFile2 = iContainerArray[0].getFile((IPath)new Path(iFile.getName().substring(0, iFile.getName().length() - 5) + ".cpy"));
                    this.workspaceOutputTxt.setText(iFile2.getFullPath().toString());
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    static /* synthetic */ Text access$000(WSDL2WrkDialog wSDL2WrkDialog) {
        return wSDL2WrkDialog.workspaceInputTxt;
    }

    static /* synthetic */ Button access$100(WSDL2WrkDialog wSDL2WrkDialog) {
        return wSDL2WrkDialog.workspaceInputBrowseBtn;
    }

    static /* synthetic */ Text access$200(WSDL2WrkDialog wSDL2WrkDialog) {
        return wSDL2WrkDialog.fileSystemInputTxt;
    }

    static /* synthetic */ Button access$300(WSDL2WrkDialog wSDL2WrkDialog) {
        return wSDL2WrkDialog.fileSystemInputBrowseBtn;
    }

    static /* synthetic */ Text access$400(WSDL2WrkDialog wSDL2WrkDialog) {
        return wSDL2WrkDialog.remoteUrlInputTxt;
    }

    static /* synthetic */ Text access$500(WSDL2WrkDialog wSDL2WrkDialog) {
        return wSDL2WrkDialog.workspaceOutputTxt;
    }

    static /* synthetic */ Button access$600(WSDL2WrkDialog wSDL2WrkDialog) {
        return wSDL2WrkDialog.workspaceOutputBrowseBtn;
    }

    static /* synthetic */ Text access$700(WSDL2WrkDialog wSDL2WrkDialog) {
        return wSDL2WrkDialog.fileSystemOutputTxt;
    }

    static /* synthetic */ Button access$800(WSDL2WrkDialog wSDL2WrkDialog) {
        return wSDL2WrkDialog.fileSystemOutputBrowseBtn;
    }

    static /* synthetic */ void access$900(WSDL2WrkDialog wSDL2WrkDialog, IFile iFile) {
        wSDL2WrkDialog.setWorkspaceInputFile(iFile);
    }
}

