/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.launch;

import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.dialogs.RunGroup;
import com.iscobol.plugins.editor.launch.ClasspathTab;
import com.iscobol.plugins.editor.launch.EnvironmentTab;
import com.iscobol.plugins.editor.launch.IscobolLaunchConfigurationTab;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RunTab
extends IscobolLaunchConfigurationTab {
    public static final String rcsid = "$Id: RunTab.java,v 1.5 2009/03/09 11:17:22 gianni Exp $";
    private Combo projectCmb;
    private Combo prognameCmb;
    private IProject[] projects;
    private ModifyListener mlistener = new /* Unavailable Anonymous Inner Class!! */;
    private RunGroup runGroup = new RunGroup();
    private ClasspathTab classpathTab;
    private EnvironmentTab envTab;

    public RunTab(ClasspathTab classpathTab, EnvironmentTab environmentTab) {
        this.classpathTab = classpathTab;
        this.envTab = environmentTab;
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute("projectname", "");
            int n = this.projectCmb.indexOf(string);
            if (n >= 0) {
                this.projectCmb.select(n);
                this.projectCmbSelchanged(true);
            } else {
                this.projectCmb.setText(string);
            }
            this.prognameCmb.setText(iLaunchConfiguration.getAttribute("progname", ""));
            this.runGroup.init(iLaunchConfiguration.getAttribute("systemprops", ""), iLaunchConfiguration.getAttribute("arguments", ""), iLaunchConfiguration.getAttribute("workdir", ""), null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public String getMessage() {
        return IsresourceBundle.getString((String)"run_prog_msg");
    }

    protected Control createControlImpl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(IsresourceBundle.getString((String)"project_lbl") + ":");
        this.projectCmb = new Combo(composite2, 0);
        GridData gridData = new GridData(768);
        this.projectCmb.setLayoutData((Object)gridData);
        this.projectCmb.addModifyListener(this.mlistener);
        this.projectCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        Vector<IProject> vector = new Vector<IProject>();
        String string = "com.iscobol.plugins.editor.IscobolEditor.IscobolNature";
        try {
            int n;
            for (n = 0; n < this.projects.length; ++n) {
                if (!this.projects[n].isOpen() || this.projects[n].getNature(string) == null) continue;
                this.projectCmb.add(this.projects[n].getName());
                vector.addElement(this.projects[n]);
            }
            n = vector.size();
            if (n < this.projects.length) {
                this.projects = new IProject[n];
                vector.toArray(this.projects);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        Label label2 = new Label(composite2, 0);
        label2.setText(IsresourceBundle.getString((String)"progname_lbl") + ":");
        this.prognameCmb = new Combo(composite2, 0);
        gridData = new GridData(768);
        this.prognameCmb.setLayoutData((Object)gridData);
        this.prognameCmb.addModifyListener(this.mlistener);
        this.prognameCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.runGroup.setPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.runGroup.createControl(composite, composite2);
        return composite2;
    }

    private void projectCmbSelchanged(boolean bl) {
        String string;
        int n = this.projectCmb.getSelectionIndex();
        IProject iProject = this.projects[n];
        if (!bl) {
            string = PluginUtilities.getCurrentSettingMode((IResource)iProject);
            String string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)"iscobol.prog.sysprops");
            String string3 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)"iscobol.prog.args");
            String string4 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)"iscobol.prog.workdir");
            this.runGroup.init(string2, string3, string4, iProject);
            String string5 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)"iscobol.prog.cp");
            this.classpathTab.getClasspathGroup().init(iProject, string5);
            this.classpathTab.performApply(this.getWorkingCopy());
            LinkedList<String> linkedList = new LinkedList<String>();
            boolean bl2 = true;
            String string6 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)"iscobol.prog.envvarcount");
            int n2 = 0;
            if (string6 != null) {
                try {
                    n2 = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    linkedList.add(PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)("iscobol.prog.envvars" + i)));
                }
                String string7 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)string, (String)"iscobol.prog.appenv");
                if (string7 != null && string7.equals("___iscobol.option.false")) {
                    bl2 = false;
                }
            }
            this.envTab.getEnvironmentGroup().init(linkedList, bl2);
            this.envTab.performApply(this.getWorkingCopy());
        }
        this.prognameCmb.removeAll();
        try {
            string = PluginUtilities.getPersistentProperty((IResource)this.projects[n], (String)PluginUtilities.getCurrentSettingMode((IResource)this.projects[n]), (String)"-od=");
            if (string == null || string.equals("___iscobol.option.false")) {
                string = "";
            }
            this.loadPrognameCombo(this.projects[n], string);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void loadPrognameCombo(IProject iProject, String string) throws CoreException {
        String string2 = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"sourcedir");
        IContainer iContainer = PluginUtilities.getSourceFolder((IProject)iProject, (String)string2);
        this.loadPrognameCombo(iContainer, string);
    }

    private void loadPrognameCombo(IContainer iContainer, String string) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        block4: for (int i = 0; i < iResourceArray.length; ++i) {
            switch (iResourceArray[i].getType()) {
                case 1: {
                    String string2 = PluginUtilities.getResourcePersistentProperty((IResource)iResourceArray[i], (String)"classFile");
                    if (string2 == null) continue block4;
                    string2 = string2.substring(0, string2.length() - 6).replace('/', '.');
                    String string3 = PluginUtilities.getCurrentSettingMode((IResource)iResourceArray[i]);
                    String string4 = null;
                    if (string3 != null) {
                        string4 = PluginUtilities.getPersistentProperty((IResource)iResourceArray[i], (String)string3, (String)"-od=");
                    }
                    if (string4 == null || string4.equals("___iscobol.option.false")) {
                        string4 = string;
                    }
                    this.prognameCmb.add(string2);
                    string4 = PluginUtilities.getAbsolutePath((IProject)iContainer.getProject(), (String)string4);
                    this.prognameCmb.setData(string2, (Object)string4);
                    continue block4;
                }
                case 2: 
                case 4: {
                    this.loadPrognameCombo((IContainer)iResourceArray[i], string);
                }
            }
        }
    }

    protected void performApplyImpl(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.prognameCmb != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("projectname", this.projectCmb.getText());
            if (this.prognameCmb.getText().length() > 0) {
                iLaunchConfigurationWorkingCopy.setAttribute("progname", this.prognameCmb.getText());
                Object object = this.prognameCmb.getData(this.prognameCmb.getText());
                if (object != null) {
                    iLaunchConfigurationWorkingCopy.setAttribute("outdir", object.toString());
                }
            }
            iLaunchConfigurationWorkingCopy.setAttribute("systemprops", this.runGroup.getSystemProperties());
            iLaunchConfigurationWorkingCopy.setAttribute("arguments", this.runGroup.getArguments());
            iLaunchConfigurationWorkingCopy.setAttribute("workdir", this.runGroup.getWorkingDirectory());
            iLaunchConfigurationWorkingCopy.setAttribute("process_factory_id", "com.iscobol.plugins.processFactory");
        }
    }

    public String getName() {
        return IsresourceBundle.getString((String)"run_lbl");
    }

    static /* synthetic */ void access$000(RunTab runTab) {
        runTab.updateLaunchConfigurationDialog();
    }

    static /* synthetic */ void access$100(RunTab runTab, boolean bl) {
        runTab.projectCmbSelchanged(bl);
    }

    static /* synthetic */ void access$200(RunTab runTab) {
        runTab.updateLaunchConfigurationDialog();
    }

    static /* synthetic */ void access$300(RunTab runTab) {
        runTab.updateLaunchConfigurationDialog();
    }

    static /* synthetic */ void access$400(RunTab runTab) {
        runTab.updateLaunchConfigurationDialog();
    }
}

