/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.launch.externaltools;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.launch.externaltools.ExternalToolManager;
import com.iscobol.plugins.editor.launch.externaltools.IscobolToolsLaunchConfigurationDelegate;
import com.iscobol.plugins.editor.util.PluginUtilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;

public class AppServerManager
extends ExternalToolManager {
    private ILaunch appServerLaunch;

    public AppServerManager() {
        super("iscobol.appserver.classpath", "iscobol.appserver.env", "iscobol.appserver.env.count", "iscobol.appserver.env.append", "iscobol.appserver.jvmargs", "iscobol.appserver.workdir");
    }

    public void start() {
        if (this.appServerLaunch != null && !this.appServerLaunch.isTerminated()) {
            PluginUtilities.logError((String)IsresourceBundle.getString((String)"as_already_started_msg"));
            return;
        }
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        try {
            ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("AppServerConfigurationType");
            ILaunchDelegate iLaunchDelegate = iLaunchConfigurationType.getDelegates(IscobolToolsLaunchConfigurationDelegate.modeSet)[0];
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, "isCOBOL Server");
            this.appServerLaunch = new Launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, "isCOBOL Server", null);
            iLaunchDelegate.getDelegate().launch((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, "externaltools", this.appServerLaunch, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void stop(boolean bl) {
        if (this.appServerLaunch == null || this.appServerLaunch.isTerminated()) {
            if (bl) {
                PluginUtilities.logError((String)IsresourceBundle.getString((String)"as_not_started_msg"));
            }
            return;
        }
        try {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.appServerLaunch);
            this.appServerLaunch.terminate();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        this.appServerLaunch = null;
    }

    public void restart() {
        if (this.appServerLaunch != null && !this.appServerLaunch.isTerminated()) {
            this.stop();
        }
        this.start();
    }

    public int getPortNumber() {
        return IscobolEditorPlugin.getIntFromStore((String)"iscobol.appaserver.portnumber");
    }

    public void setPortNumber(int n) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.appaserver.portnumber", n);
    }

    public String getHostname() {
        return IscobolEditorPlugin.getStringFromStore((String)"iscobol.appserver.hostname");
    }

    public void setHostname(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.appserver.hostname", string);
    }

    public boolean getReuseAddress() {
        return IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.appserver.reuseaddr");
    }

    public void setReuseAddress(boolean bl) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.appserver.reuseaddr", bl);
    }

    public boolean getEnableLogging() {
        return IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.appserver.log.enabled");
    }

    public void setEnableLogging(boolean bl) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.appserver.log.enabled", bl);
    }

    public String getLogFile() {
        return IscobolEditorPlugin.getStringFromStore((String)"iscobol.appserver.log.file");
    }

    public void setLogFile(String string) {
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue("iscobol.appserver.log.file", string);
    }
}

