/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.launch.externaltools;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.launch.externaltools.AppServerManager;
import com.iscobol.plugins.editor.launch.externaltools.CPItem;
import com.iscobol.plugins.editor.launch.externaltools.CpkManager;
import com.iscobol.plugins.editor.launch.externaltools.EnvItem;
import com.iscobol.plugins.editor.launch.externaltools.ExternalToolManager;
import com.iscobol.plugins.editor.launch.externaltools.GifeManager;
import com.iscobol.plugins.editor.launch.externaltools.IsMigrateManager;
import com.iscobol.plugins.editor.launch.externaltools.Jdbc2FdManager;
import com.iscobol.plugins.editor.launch.externaltools.LoadBalancerManager;
import com.iscobol.plugins.editor.launch.externaltools.RemoteCompilerManager;
import com.iscobol.plugins.editor.launch.externaltools.WSDL2WrkManager;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class ExternalToolManager {
    private static final Map<Class, Item> managers;
    private final String classpathPrefKey;
    private final String envPrefKey;
    private final String envCountPrefKey;
    private final String envAppendPrefKey;
    private final String jvmArgsPrefKey;
    private final String wrkDirPrefKey;

    public ExternalToolManager(String string, String string2, String string3, String string4, String string5, String string6) {
        this.classpathPrefKey = string;
        this.envPrefKey = string2;
        this.envCountPrefKey = string3;
        this.envAppendPrefKey = string4;
        this.jvmArgsPrefKey = string5;
        this.wrkDirPrefKey = string6;
    }

    public static <T extends ExternalToolManager> T getInstance(Class<T> clazz) {
        Item item = (Item)managers.get(clazz);
        return (T)(item != null ? item.manager : null);
    }

    public static void stopAllManagers() {
        for (Item item : managers.values()) {
            item.manager.stop(false);
        }
    }

    public abstract void start();

    public abstract void stop(boolean var1);

    public final void stop() {
        this.stop(true);
    }

    public abstract void restart();

    public CPItem[] getClasspath() {
        if (this.classpathPrefKey == null) {
            return new CPItem[0];
        }
        String string = IscobolEditorPlugin.getStringFromStore((String)this.classpathPrefKey);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        CPItem[] cPItemArray = new CPItem[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string2.substring(0, 1));
            boolean bl = true;
            string2 = string2.substring(1);
            IProject iProject = null;
            switch (n2) {
                case 1: {
                    iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string2);
                    bl = iProject != null && iProject.exists();
                    break;
                }
                case 2: {
                    iProject = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(string2));
                    bl = iProject != null && iProject.exists();
                    break;
                }
                case 3: {
                    iProject = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string2));
                    bl = iProject != null && iProject.exists();
                    break;
                }
                case 4: {
                    File file = new File(string2);
                    bl = file.exists() && file.isDirectory();
                    break;
                }
                case 5: {
                    File file = new File(string2);
                    bl = file.exists() && file.isFile();
                }
            }
            cPItemArray[n] = new CPItem(string2, bl, n2);
            if (cPItemArray[n].exists) {
                cPItemArray[n].resource = iProject;
            }
            ++n;
        }
        return cPItemArray;
    }

    public void setClasspath(CPItem[] cPItemArray) {
        if (this.classpathPrefKey == null) {
            return;
        }
        IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cPItemArray.length; ++i) {
            stringBuffer.append(cPItemArray[i].type);
            stringBuffer.append(cPItemArray[i].path);
            if (i >= cPItemArray.length - 1) continue;
            stringBuffer.append(File.pathSeparator);
        }
        iPreferenceStore.setValue(this.classpathPrefKey, stringBuffer.toString());
    }

    public void setEnvironment(EnvItem[] envItemArray) {
        int n;
        if (this.envPrefKey == null || this.envCountPrefKey == null) {
            return;
        }
        IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
        int n2 = IscobolEditorPlugin.getIntFromStore((String)this.envCountPrefKey);
        for (n = 0; n < n2; ++n) {
            iPreferenceStore.setToDefault(this.envPrefKey + n2);
        }
        if (envItemArray.length == 0) {
            iPreferenceStore.setToDefault(this.envCountPrefKey);
        } else {
            iPreferenceStore.setValue(this.envCountPrefKey, envItemArray.length);
            for (n = 0; n < envItemArray.length; ++n) {
                iPreferenceStore.setValue(this.envPrefKey + n, envItemArray[n].name + "=" + envItemArray[n].value);
            }
        }
    }

    public EnvItem[] getEnvironment() {
        if (this.envPrefKey == null || this.envCountPrefKey == null) {
            return new EnvItem[0];
        }
        IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
        int n = IscobolEditorPlugin.getIntFromStore((String)this.envCountPrefKey);
        EnvItem[] envItemArray = new EnvItem[n];
        for (int i = 0; i < n; ++i) {
            String string = iPreferenceStore.getString(this.envPrefKey + i);
            int n2 = string.indexOf(61);
            String string2 = string.substring(0, n2);
            String string3 = "";
            if (n2 < string.length() - 1) {
                string3 = string.substring(n2 + 1);
            }
            envItemArray[i] = new EnvItem(string2, string3);
        }
        return envItemArray;
    }

    public boolean getAppendEnvironment() {
        if (this.envAppendPrefKey == null) {
            return false;
        }
        return IscobolEditorPlugin.getBooleanFromStore((String)this.envAppendPrefKey);
    }

    public void setAppendEnvironment(boolean bl) {
        if (this.envAppendPrefKey == null) {
            return;
        }
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue(this.envAppendPrefKey, bl);
    }

    public String getWorkingDirectory() {
        if (this.wrkDirPrefKey == null) {
            return null;
        }
        return IscobolEditorPlugin.getStringFromStore((String)this.wrkDirPrefKey);
    }

    public void setWorkingDirectory(String string) {
        if (this.wrkDirPrefKey == null) {
            return;
        }
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue(this.wrkDirPrefKey, string);
    }

    public String getJVMArguments() {
        if (this.jvmArgsPrefKey == null) {
            return null;
        }
        return IscobolEditorPlugin.getStringFromStore((String)this.jvmArgsPrefKey);
    }

    public void setJVMArguments(String string) {
        if (this.jvmArgsPrefKey == null) {
            return;
        }
        IscobolEditorPlugin.getDefault().getPreferenceStore().setValue(this.jvmArgsPrefKey, string);
    }

    static {
        HashMap<Class, Item> hashMap = new HashMap<Class, Item>();
        hashMap.put(AppServerManager.class, new Item((ExternalToolManager)new AppServerManager()));
        hashMap.put(RemoteCompilerManager.class, new Item((ExternalToolManager)new RemoteCompilerManager()));
        hashMap.put(LoadBalancerManager.class, new Item((ExternalToolManager)new LoadBalancerManager()));
        hashMap.put(GifeManager.class, new Item((ExternalToolManager)new GifeManager()));
        hashMap.put(CpkManager.class, new Item((ExternalToolManager)new CpkManager()));
        hashMap.put(Jdbc2FdManager.class, new Item((ExternalToolManager)new Jdbc2FdManager()));
        hashMap.put(IsMigrateManager.class, new Item((ExternalToolManager)new IsMigrateManager()));
        hashMap.put(WSDL2WrkManager.class, new Item((ExternalToolManager)new WSDL2WrkManager()));
        managers = Collections.unmodifiableMap(hashMap);
    }
}

