/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.preferences;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.preferences.IscobolPreferenceInitializer;
import com.iscobol.plugins.editor.util.JavacDetector;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.net.URL;
import java.util.Dictionary;
import java.util.prefs.Preferences;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.framework.Bundle;

public class IscobolPreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final String rcsid = "$Id: IscobolPreferenceInitializer.java,v 1.5 2008/02/08 16:32:12 gianni Exp $";
    public static final int ISCOBOL_APPLICATION = 1;
    public static final int WD2_APPLICATION = 2;
    public static final String VIEW_ONLINE_DOCUMENTATION = "iscobol.viewonlinedoc";
    public static final String LOCAL_DOCUMENTATION_LOCATION = "iscobol.localdocloc";
    public static final String LAST_EXPORT_DEST_FOLDER = "iscobol.export.lastfolder";
    public static final String LAST_EXPORT_ARCHIVE_FILE = "iscobol.export.lastarchivefile";
    public static final String LAST_EXPORT_JVM_ARGS = "iscobol.export.lastjvmargs";
    public static final String LAST_EXPORT_MAIN_PROGRAM = "iscobol.export.lastprogram";
    public static final String LAST_EXPORT_PROGRAM_ARGS = "iscobol.export.lastprogargs";
    public static final String LAST_EXPORT_EXEC_NAME = "iscobol.export.execname";
    public static final String LAST_EXPORT_SOURCES = "iscobol.export.source";
    public static final String LAST_EXPORT_PATHS = "iscobol.export.paths";
    public static final String EXPORT_WITHOUT_ASKING = "iscobol.export.dontask";
    public static final String RUN_DEBUG_AS = "iscobol.rundebugas";
    public static final String USE_EXTERNAL_DEBUGGER = "iscobol.useextdebug";
    public static final String REMEMBER_TIP_OF_THE_DAY_DIALOG_BOUNDS = "iscobol.tipoftheday.rememberbounds";
    public static final String SHOW_AREA_DELIMITER_LINES = "iscobol.syntaxcoloring.showareadelimiterlines";
    public static final String AREA_DELIMITER_LINES_COLOR = "iscobol.syntaxcoloring.areadelimiterlinescolor";
    public static final String SHOW_TIP_OF_THE_DAY = "iscobol.tipoftheday.show";
    public static final String MEMBER_HIGHLIGHT_BACKGROUND = "com.iscobol.plugins.editor.memberHighlight.Background";
    public static final String EDITOR_TOOLTIP_PREFIX = "com.iscobol.plugins.editor.tooltip.";
    public static final String EDITOR_TOOLTIP_FONT = "com.iscobol.plugins.editor.tooltip.Font";
    public static final String EDITOR_TOOLTIP_BACKGROUND = "com.iscobol.plugins.editor.tooltip.Background";
    public static final String EDITOR_TOOLTIP_FOREGROUND = "com.iscobol.plugins.editor.tooltip.Foreground";
    public static final String SYSTEM_COPY_BOOKS = "iscobol.systemcopybooks";
    public static final String SHOW_TOOLTIP_ON_MOUSE_HOVER = "iscobol.showtooltipmousehover.enabled";
    public static final String SHOW_HORIZONTAL_RULER = "iscobol.showhruler";
    public static final String IS_FOLDING_ENABLED = "iscobol.folding.enabled";
    public static final String IS_RECONCILING_ENABLED = "iscobol.reconciling.enabled";
    public static final String IS_CONTENT_ASSIST_ENABLED = "iscobol.contentassist.enabled";
    public static final String OUTLINE_SORT_ENABLED = "iscobol.outlinesort.enabled";
    public static final String SHOW_VARIABLES_AS_HEX = "iscobol.variableview.showhex";
    public static final String LAST_LINK_DIRECTORY = "iscobol.LinkDirectory";
    public static final String JAVAC_COMPILER = "iscobol.compiler.javac";
    public static final String JAVAC_COMPILER_OPTIONS = "iscobol.compiler.javac.options";
    public static final String JAVA_SOURCE_ARCHIVE = "iscobol.contentassist.sourcearchive";
    public static final String SYN_COL_SEQ_NUMBER_BKG = "iscobol.syntaxcoloring.sequencenumber.background";
    public static final String SYN_COL_SEQ_NUMBER_FRG = "iscobol.syntaxcoloring.sequencenumber.foreground";
    public static final String SYN_COL_IND_AREA_BKG = "iscobol.syntaxcoloring.indicatorarea.background";
    public static final String SYN_COL_IND_AREA_FRG = "iscobol.syntaxcoloring.indicatorarea.foreground";
    public static final String SYN_COL_IDEN_AREA_BKG = "iscobol.syntaxcoloring.identificationarea.background";
    public static final String SYN_COL_IDEN_AREA_FRG = "iscobol.syntaxcoloring.identificationarea.foreground";
    public static final String SYN_COL_AREA_A_BKG = "iscobol.syntaxcoloring.areaa.background";
    public static final String SYN_COL_AREA_A_FRG = "iscobol.syntaxcoloring.areaa.foreground";
    public static final String SYN_COL_AREA_B_BKG = "iscobol.syntaxcoloring.areab.background";
    public static final String SYN_COL_AREA_B_FRG = "iscobol.syntaxcoloring.areab.foreground";
    public static final String SYN_COL_COMMENTS_FRG = "iscobol.syntaxcoloring.comments.foreground";
    public static final String SYN_COL_KEYWORDS_FRG = "iscobol.syntaxcoloring.keywords.foreground";
    public static final String SYN_COL_STRINGS_FRG = "iscobol.syntaxcoloring.strings.foreground";
    public static final String SYN_COL_NUMBERS_FRG = "iscobol.syntaxcoloring.numbers.foreground";
    public static final String SYN_COL_STATEMENTS_FRG = "iscobol.syntaxcoloring.statements.foreground";
    public static final String SYN_COL_LEVEL_NUMBER_FRG = "iscobol.syntaxcoloring.levelnumber.foreground";
    public static final String SYN_COL_FIG_CONST_FRG = "iscobol.syntaxcoloring.figurativeconst.foreground";
    public static final String SYN_COL_DBG_CURR_LINE_BKG = "iscobol.syntaxcoloring.debugcurrentline.background";
    public static final String SYN_COL_DBG_CURR_LINE_FRG = "iscobol.syntaxcoloring.debugcurrentline.foreground";
    public static final String SYNTAX_HIGHLIGHTING_SETTINGS_ENABLED = "iscobol.syntaxhighlighting.enabled";
    public static final String SOURCE_FORMAT_SETTINGS_ENABLED = "iscobol.sourceformat.enabled";
    public static final String PROMPT_COMPILATION_RESULT = "iscobol.promptcompresult";
    public static final String TAB_WIDTH = "iscobol.tabwidth";
    public static final String TAB_INSERT_SPACES = "iscobol.insertspaces";
    public static final String ANSI_TABS = "iscobol.tabs.ansi";
    public static final String TERMINAL_TABS = "iscobol.tabs.terminal";
    public static final String SHOW_EXP_OPT = "iscobol.show.xopt";
    public static final String SWITCH_BACK_IS_PERSP = "iscobol.switchback.ispersp";
    public static final String NEW_PROJECT_PREFIX = "iscobol.newproject.";
    public static final String MAX_HEX_DUMP_LENGTH = "iscobol.debug.maxhexdumplength";
    public static final String HEX_DUMP_START_OFFSET = "iscobol.debug.hexdumpstartoffset";
    public static final String MAX_ARRAY_LENGTH = "iscobol.debug.maxarraylength";
    public static final String START_ARRAY_INDEX = "iscobol.debug.startarrayindex";
    public static final String MAX_TEXT_LENGTH = "iscobol.debug.maxtextlength";
    public static final String AS_HOSTNAME = "iscobol.appserver.hostname";
    public static final String AS_PORT = "iscobol.appaserver.portnumber";
    public static final String AS_REUSE_ADDR = "iscobol.appserver.reuseaddr";
    public static final String AS_ENABLE_LOG = "iscobol.appserver.log.enabled";
    public static final String AS_LOG_FILE = "iscobol.appserver.log.file";
    public static final String AS_WRKDIR = "iscobol.appserver.workdir";
    public static final String AS_JVMARGS = "iscobol.appserver.jvmargs";
    public static final String AS_CLASSPATH = "iscobol.appserver.classpath";
    public static final String AS_ENV = "iscobol.appserver.env";
    public static final String AS_ENV_APPEND = "iscobol.appserver.env.append";
    public static final String AS_ENV_COUNT = "iscobol.appserver.env.count";
    public static final String GIFE_CLASSPATH = "iscobol.gife.classpath";
    public static final String JDBC2FD_CLASSPATH = "iscobol.jdbc2fd.classpath";
    public static final String ISMIGRATE_CLASSPATH = "iscobol.ismigrate.classpath";
    public static final String LB_PROP_FILE = "iscobol.balancer.propfile";
    public static final String LB_REUSE_ADDR = "iscobol.balancer.reuseaddr";
    public static final String LB_JVMARGS = "iscobol.balancer.jvmargs";
    public static final String REMOTECOMPILER_CONF_FILE = "iscobol.remotecompiler.conffile";
    public static final String SOURCE_DIRECTORY = "iscobol.newproject.sourcedir";
    public static final String SCREEN_DIRECTORY = "iscobol.newproject.screendir";
    public static final String RESOURCES_DIRECTORY = "iscobol.newproject.resourcesdir";
    public static final String FILE_LAYOUT_DIRECTORY = "iscobol.newproject.fddir";
    public static final String LOGS_DIRECTORY = "iscobol.newproject.logsdir";
    public static final String ERRS_DIRECTORY = "iscobol.newproject.errsdir";
    public static final String DATA_DIRECTORY = "iscobol.newproject.datadir";
    public static final String LIST_DIRECTORY = "iscobol.newproject.listdir";
    public static final String SCREEN_COPY_DIRECTORY = "iscobol.newproject.copydir";
    public static final String COPY_DIRECTORY = "iscobol.newproject._copydir";
    public static final String FDSL_COPY_DIRECTORY = "iscobol.newproject.fdsldir";
    public static final String OUTPUT_DIRECTORY = "iscobol.newproject.outdir";
    public static final String HTML_ANDROID_DIRECTORY = "iscobol.newproject.htmlandroiddir";
    public static final String ISCOBOL_PROPERTIES_FILE = "iscobol.newproject.ispropsfile";
    public static final String RUNTIME_SYSTEM_PROPERTIES = "iscobol.newproject.runtimesysprops";
    public static final String CURRENT_MODE = "iscobol.newproject.currentmode";
    public static final String EASYDB_EXECUTABLE = "iscobol.easydb.exec";
    public static final String EASYDB_TEMPLATES_DIR = "easydb.-ld";
    public static final String LAST_SOURCE_IMPORT_DIRECTORY = "iscobol.sourceImportDirectory";
    public static final String SOURCE_IMPORT_EXTENSIONS = "iscobol.sourceImportExtensions";
    private static final Preferences preferences;
    public static final String IMPORT_SETTINGS_KEY = "iscobol.preferences.importsettings";
    public static final String EXPORT_SETTINGS_KEY = "iscobol.preferences.exportsettings";
    public static final String NUMBER_SAVED_SETTINGS_KEY = "iscobol.preferences.numsavedsettings";
    public static final String SAVED_SETTINGS_KEY = "iscobol.preferences.savedsettings";
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int PROMPT = 2;
    public static final int RECONCILE_ALWAYS = 0;
    public static final int RECONCILE_WHEN_OPEN_FILE = 1;
    public static final int RECONCILE_NEVER = 2;
    private static final DefOptions releaseOptions;
    private static final DefOptions debugOptions;
    private static final DefOptions[] defOptions;

    private String[] getEasyDBPaths() {
        String string = "";
        String string2 = "";
        try {
            Dictionary dictionary;
            String string3;
            Bundle bundle = PluginUtilities.getIscobolNativeLibraryPlugin();
            if (bundle != null && (string3 = (String)(dictionary = bundle.getHeaders()).get("EasyDB-Executable")) != null) {
                URL uRL = FileLocator.toFileURL((URL)bundle.getEntry("/"));
                String string4 = uRL.getPath();
                if (Platform.getOS().equals("win32")) {
                    string4 = string4.substring(1);
                }
                string4 = new File(string4).getAbsolutePath();
                string = string4 + File.separator + string3;
                string4 = new File(PluginUtilities.getPluginInstallLocation((String)"com.iscobol.plugins.libraries")).getAbsolutePath();
                string2 = string4 + File.separator + "easydb" + File.separator + "template";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[]{string, string2};
    }

    public void initializeDefaultPreferences() {
        String[] stringArray;
        int n;
        IPreferenceStore iPreferenceStore = IscobolEditorPlugin.getDefault().getPreferenceStore();
        String[] stringArray2 = IscobolEditorPlugin.getDefault().getCommandLineArgs();
        String string = null;
        boolean bl = true;
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                if (stringArray2[n].startsWith("-JavacCompiler=")) {
                    string = stringArray2[n].substring("-JavacCompiler=".length());
                    continue;
                }
                if (stringArray2[n].startsWith("-JavacCompilerOptions=")) {
                    iPreferenceStore.setValue(JAVAC_COMPILER_OPTIONS, stringArray2[n].substring("-JavacCompilerOptions=".length()));
                    continue;
                }
                if (!stringArray2[n].startsWith("-LocalDocLocation=")) continue;
                bl = false;
                iPreferenceStore.setValue(LOCAL_DOCUMENTATION_LOCATION, stringArray2[n].substring("-LocalDocLocation=".length()));
            }
        }
        if (string == null) {
            JavacDetector javacDetector = new JavacDetector();
            string = javacDetector.getJavaCompilerPath();
        }
        if (string != null) {
            iPreferenceStore.setDefault(JAVAC_COMPILER, string);
            File file = new File(string);
            if (file.exists() && new File((String)(stringArray = file.getParentFile().getParentFile().getAbsolutePath() + File.separator + "src.zip")).exists()) {
                iPreferenceStore.setValue(JAVA_SOURCE_ARCHIVE, (String)stringArray);
            }
        }
        n = 1;
        if (Platform.getBundle((String)"com.iscobol.plugins.webdirectlauncher") != null) {
            n += 2;
        }
        iPreferenceStore.setDefault(EXPORT_WITHOUT_ASKING, 1);
        iPreferenceStore.setDefault(RUN_DEBUG_AS, n);
        iPreferenceStore.setDefault(REMOTECOMPILER_CONF_FILE, System.getProperty("user.home") + File.separator + "remoteCompiler.xml");
        iPreferenceStore.setDefault(LB_PROP_FILE, System.getProperty("user.home") + File.separator + "isbalancer.properties");
        iPreferenceStore.setDefault(AS_HOSTNAME, "localhost");
        iPreferenceStore.setDefault(AS_PORT, 10999);
        iPreferenceStore.setDefault(AS_ENV_APPEND, true);
        iPreferenceStore.setDefault(REMEMBER_TIP_OF_THE_DAY_DIALOG_BOUNDS, true);
        iPreferenceStore.setDefault(SHOW_TIP_OF_THE_DAY, true);
        iPreferenceStore.setDefault(IS_FOLDING_ENABLED, true);
        iPreferenceStore.setDefault(IS_RECONCILING_ENABLED, 0);
        iPreferenceStore.setDefault(IS_CONTENT_ASSIST_ENABLED, true);
        iPreferenceStore.setDefault(SHOW_TOOLTIP_ON_MOUSE_HOVER, true);
        iPreferenceStore.setDefault(OUTLINE_SORT_ENABLED, true);
        iPreferenceStore.setDefault(PROMPT_COMPILATION_RESULT, true);
        iPreferenceStore.setDefault(SYNTAX_HIGHLIGHTING_SETTINGS_ENABLED, true);
        iPreferenceStore.setDefault(SOURCE_FORMAT_SETTINGS_ENABLED, true);
        iPreferenceStore.setDefault(TAB_WIDTH, 2);
        iPreferenceStore.setDefault(TAB_INSERT_SPACES, true);
        iPreferenceStore.setDefault(ANSI_TABS, "7,8,12,14,16,18,20,22,24,26,28,30,34,38,42,46,50,54,58,62,66,70,73");
        iPreferenceStore.setDefault(TERMINAL_TABS, "");
        iPreferenceStore.setDefault(SHOW_AREA_DELIMITER_LINES, true);
        iPreferenceStore.setDefault(VIEW_ONLINE_DOCUMENTATION, bl);
        iPreferenceStore.setDefault(SWITCH_BACK_IS_PERSP, 0);
        iPreferenceStore.setDefault(SOURCE_DIRECTORY, "source");
        iPreferenceStore.setDefault(SCREEN_DIRECTORY, "screen");
        iPreferenceStore.setDefault(RESOURCES_DIRECTORY, "resources");
        iPreferenceStore.setDefault(FILE_LAYOUT_DIRECTORY, "fd");
        iPreferenceStore.setDefault(LOGS_DIRECTORY, "logs");
        iPreferenceStore.setDefault(ERRS_DIRECTORY, "errs");
        iPreferenceStore.setDefault(LIST_DIRECTORY, "list");
        iPreferenceStore.setDefault(DATA_DIRECTORY, "data");
        iPreferenceStore.setDefault(SCREEN_COPY_DIRECTORY, "screenpgm");
        iPreferenceStore.setDefault(COPY_DIRECTORY, "cpy");
        iPreferenceStore.setDefault(FDSL_COPY_DIRECTORY, "fdsl");
        iPreferenceStore.setDefault(OUTPUT_DIRECTORY, "output");
        iPreferenceStore.setDefault(HTML_ANDROID_DIRECTORY, "html");
        iPreferenceStore.setDefault(RUNTIME_SYSTEM_PROPERTIES, "-XX:ErrorFile=../logs/java_error%p.log");
        iPreferenceStore.setDefault(ISCOBOL_PROPERTIES_FILE, "iscobol.file.prefix=../data" + System.getProperty("line.separator", "\n") + "iscobol.logfile=../logs/iscobol.log");
        iPreferenceStore.setDefault(CURRENT_MODE, "Debug");
        iPreferenceStore.setDefault(MAX_HEX_DUMP_LENGTH, 256);
        iPreferenceStore.setDefault(HEX_DUMP_START_OFFSET, 1);
        iPreferenceStore.setDefault(MAX_ARRAY_LENGTH, 25);
        iPreferenceStore.setDefault(START_ARRAY_INDEX, 1);
        iPreferenceStore.setDefault(MAX_TEXT_LENGTH, 512);
        iPreferenceStore.setDefault("easydb.Generic", "___iscobol.option.true");
        iPreferenceStore.setDefault(SYSTEM_COPY_BOOKS, "ALL");
        stringArray = this.getEasyDBPaths();
        iPreferenceStore.setDefault(EASYDB_EXECUTABLE, stringArray[0]);
        iPreferenceStore.setDefault(EASYDB_TEMPLATES_DIR, stringArray[1]);
        iPreferenceStore.setDefault(SOURCE_IMPORT_EXTENSIONS, "cbl,cl2,cob");
        iPreferenceStore.setDefault(SHOW_HORIZONTAL_RULER, true);
        EditorsUI.getPreferenceStore().setDefault("lineNumberRuler", true);
        for (int i = 0; i < defOptions.length; ++i) {
            for (int j = 0; j < IscobolPreferenceInitializer.defOptions[i].options.length; ++j) {
                iPreferenceStore.setDefault(NEW_PROJECT_PREFIX + IscobolPreferenceInitializer.defOptions[i].mode + "." + IscobolPreferenceInitializer.defOptions[i].options[j][0], IscobolPreferenceInitializer.defOptions[i].options[j][1]);
            }
        }
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)AREA_DELIMITER_LINES_COLOR, (RGB)new RGB(176, 180, 185));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_SEQ_NUMBER_BKG, (RGB)new RGB(255, 255, 213));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_SEQ_NUMBER_FRG, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_IND_AREA_BKG, (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_IND_AREA_FRG, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_IDEN_AREA_BKG, (RGB)new RGB(239, 239, 239));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_IDEN_AREA_FRG, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_AREA_A_BKG, (RGB)new RGB(192, 213, 214));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_AREA_A_FRG, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_AREA_B_BKG, (RGB)new RGB(210, 223, 211));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_AREA_B_FRG, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_COMMENTS_FRG, (RGB)new RGB(128, 128, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_KEYWORDS_FRG, (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_STRINGS_FRG, (RGB)new RGB(0, 128, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_NUMBERS_FRG, (RGB)new RGB(204, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_STATEMENTS_FRG, (RGB)new RGB(255, 0, 153));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_LEVEL_NUMBER_FRG, (RGB)new RGB(204, 0, 204));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_FIG_CONST_FRG, (RGB)new RGB(204, 102, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_DBG_CURR_LINE_BKG, (RGB)new RGB(255, 255, 0));
        PreferenceConverter.setDefault((IPreferenceStore)iPreferenceStore, (String)SYN_COL_DBG_CURR_LINE_FRG, (RGB)new RGB(0, 0, 0));
    }

    public static int getValueFromPreferences(String string, int n) {
        return preferences.getInt(string, n);
    }

    public static String getValueFromPreferences(String string, String string2) {
        return preferences.get(string, string2);
    }

    public static void setValueToPreferences(String string, int n) {
        preferences.putInt(string, n);
    }

    public static void setValueToPreferences(String string, String string2) {
        preferences.put(string, string2);
    }

    static {
        File file = new File(IscobolPreferenceInitializer.class.getProtectionDomain().getCodeSource().getLocation().getFile()).getParentFile();
        preferences = Preferences.userNodeForPackage(IscobolPreferenceInitializer.class).node(file.getAbsolutePath().replace(File.separatorChar, '/'));
        releaseOptions = new DefOptions("Release", (String[][])new String[][]{{"-sp=", "cpy" + File.pathSeparator + "screenpgm" + File.pathSeparator + "fdsl"}, {"-od=", "output"}, {"-lo=", "list"}, {"-eo=", "errs"}, {"-esme=", "100"}, {"-smat", "___iscobol.option.true"}, {"iscobol.prog.sysprops", "-XX:ErrorFile=../logs/java_error%p.log"}, {"iscobol.prog.workdir", "output"}});
        debugOptions = new DefOptions("Debug", releaseOptions, (String[][])new String[][]{{"-d", "___iscobol.option.true"}, {"-dx", "___iscobol.option.true"}});
        defOptions = new DefOptions[]{releaseOptions, debugOptions};
    }
}

