/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.preferences;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.lafs.LookAndFeelDescriptor;
import com.iscobol.plugins.editor.lafs.LookAndFeelManager;
import java.util.Arrays;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LookAndFeelPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Tree lafTree;
    private Button addBtn;
    private Button removeBtn;
    private LookAndFeelDescriptor lastValue;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Availables Look and Feels:");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.lafTree = new Tree(composite2, 67618);
        this.lafTree.setHeaderVisible(true);
        this.lafTree.setLinesVisible(true);
        this.lafTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        TreeColumn treeColumn = new TreeColumn(this.lafTree, 0);
        treeColumn.setWidth(150);
        treeColumn.setText("Name");
        treeColumn = new TreeColumn(this.lafTree, 0);
        treeColumn.setWidth(150);
        treeColumn.setText("Class");
        treeColumn = new TreeColumn(this.lafTree, 0);
        treeColumn.setWidth(250);
        treeColumn.setText("Location");
        gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.widthHint = 500;
        this.lafTree.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        composite3.setLayoutData((Object)gridData);
        this.addBtn = new Button(composite3, 8);
        this.addBtn.setText("Add");
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.widthHint = 70;
        this.addBtn.setLayoutData((Object)gridData);
        this.removeBtn = new Button(composite3, 8);
        this.removeBtn.setText("Remove");
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.setEnabled(false);
        gridData = new GridData();
        gridData.widthHint = 70;
        this.removeBtn.setLayoutData((Object)gridData);
        this.loadTree();
        return composite2;
    }

    private void loadTree() {
        this.lafTree.removeAll();
        String string = UIManager.getLookAndFeel() != null ? UIManager.getLookAndFeel().getClass().getName() : "";
        LookAndFeelManager lookAndFeelManager = LookAndFeelManager.getInstance();
        LookAndFeelDescriptor[] lookAndFeelDescriptorArray = lookAndFeelManager.getLookAndFeels();
        Arrays.sort(lookAndFeelDescriptorArray, new /* Unavailable Anonymous Inner Class!! */);
        for (int i = 0; i < lookAndFeelDescriptorArray.length; ++i) {
            TreeItem treeItem = new TreeItem(this.lafTree, 0);
            treeItem.setText(0, lookAndFeelDescriptorArray[i].getName());
            treeItem.setText(1, lookAndFeelDescriptorArray[i].getClassName());
            treeItem.setText(2, lookAndFeelDescriptorArray[i].getLibraryName() != null ? lookAndFeelDescriptorArray[i].getLibraryName() : "None");
            treeItem.setData((Object)lookAndFeelDescriptorArray[i]);
            if (lookAndFeelDescriptorArray[i].getLibraryName() == null) {
                treeItem.setForeground(this.lafTree.getDisplay().getSystemColor(9));
            }
            if (!lookAndFeelDescriptorArray[i].getClassName().equals(string)) continue;
            treeItem.setChecked(true);
        }
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(IscobolEditorPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.applySettings();
        return super.performOk();
    }

    protected void performDefaults() {
        String string = UIManager.getSystemLookAndFeelClassName();
        TreeItem[] treeItemArray = this.lafTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            LookAndFeelDescriptor lookAndFeelDescriptor = (LookAndFeelDescriptor)treeItemArray[i].getData();
            treeItemArray[i].setChecked(lookAndFeelDescriptor.getClassName().equals(string));
        }
        this.applySettings();
        super.performDefaults();
    }

    public boolean isValid() {
        return super.isValid();
    }

    private void applySettings() {
        TreeItem[] treeItemArray = this.lafTree.getItems();
        LookAndFeelDescriptor lookAndFeelDescriptor = null;
        for (int i = 0; i < treeItemArray.length && lookAndFeelDescriptor == null; ++i) {
            if (!treeItemArray[i].getChecked()) continue;
            lookAndFeelDescriptor = (LookAndFeelDescriptor)treeItemArray[i].getData();
        }
        if (!(lookAndFeelDescriptor == null || this.lastValue != null && this.lastValue.equals(lookAndFeelDescriptor))) {
            LookAndFeel lookAndFeel;
            LookAndFeelManager lookAndFeelManager = LookAndFeelManager.getInstance();
            LookAndFeelDescriptor lookAndFeelDescriptor2 = lookAndFeelManager.getCurrentLookAndFeel();
            lookAndFeelManager.setCurrentLookAndFeel(lookAndFeelDescriptor);
            LookAndFeel lookAndFeel2 = lookAndFeel = !lookAndFeelDescriptor.isStandardLookAndFeel() ? lookAndFeelManager.getLAF(lookAndFeelDescriptor) : null;
            if (!LookAndFeelManager.changeLookAndFeel((LookAndFeel)lookAndFeel, (String)lookAndFeelDescriptor.getClassName())) {
                lookAndFeelManager.setCurrentLookAndFeel(lookAndFeelDescriptor2);
            }
            lookAndFeelManager.save();
            lookAndFeelManager.firePropertyChange(lookAndFeelDescriptor2, lookAndFeelDescriptor);
            this.lastValue = lookAndFeelDescriptor;
        }
    }

    static /* synthetic */ Tree access$100(LookAndFeelPreferencePage lookAndFeelPreferencePage) {
        return lookAndFeelPreferencePage.lafTree;
    }

    static /* synthetic */ Button access$200(LookAndFeelPreferencePage lookAndFeelPreferencePage) {
        return lookAndFeelPreferencePage.removeBtn;
    }

    static /* synthetic */ void access$300(LookAndFeelPreferencePage lookAndFeelPreferencePage) {
        lookAndFeelPreferencePage.loadTree();
    }
}

