/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.preferences;

import com.iscobol.compiler.remote.server.PreProcessor;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.preferences.RemoteCompilerPreferencePage;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RemoteCompilerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List ppList;
    private Text portTxt;
    private Text hostTxt;
    private Text outFolderTxt;
    private Text deplFolderTxt;
    private Button cleanWhenExitBtn;
    private StackLayout stackLayout;
    private Composite ppTabContainer;
    private Text rcFileTxt;
    private Button rcFileBrowseBtn;
    private Button outFolderBrowseBtn;
    private Button deplFolderBrowseBtn;
    private Button addPPBtn;
    private Button removePPBtn;
    private Button renamePPBtn;

    private int indexOfPP(String string) {
        for (int i = 0; i < this.ppList.getItemCount(); ++i) {
            if (!string.equalsIgnoreCase(this.ppList.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    private String validatePPName(String string) {
        return this.validatePPName(string, -1);
    }

    private String validatePPName(String string, int n) {
        if (string.length() == 0) {
            return "";
        }
        int n2 = this.indexOfPP(string);
        if (n2 >= 0 && n2 != n) {
            return IsresourceBundle.getString((String)"pp_already_exists_msg");
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return IsresourceBundle.getString((String)"invalid_pp_name_msg");
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return IsresourceBundle.getString((String)"invalid_pp_name_msg");
        }
        return null;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText(IsresourceBundle.getString((String)"rc_conffile_lbl"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        this.rcFileTxt = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.rcFileTxt.setLayoutData((Object)gridData);
        this.rcFileTxt.setEditable(false);
        this.rcFileBrowseBtn = new Button((Composite)group, 8);
        this.rcFileBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.rcFileBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        Group group2 = new Group(composite3, 0);
        group2.setText("Server");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        group2.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group2, 0);
        label.setText(IsresourceBundle.getString((String)"hostname_lbl") + ":");
        this.hostTxt = new Text((Composite)group2, 2048);
        gridData = new GridData();
        gridData.widthHint = 200;
        this.hostTxt.setLayoutData((Object)gridData);
        this.hostTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        label = new Label((Composite)group2, 0);
        label.setText(IsresourceBundle.getString((String)"portnumber_lbl") + ":");
        this.portTxt = new Text((Composite)group2, 133120);
        gridData = new GridData();
        gridData.widthHint = 50;
        this.portTxt.setLayoutData((Object)gridData);
        this.portTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        Group group3 = new Group(composite3, 0);
        group3.setText(IsresourceBundle.getString((String)"outfolder_lbl"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group3.setLayout((Layout)gridLayout);
        group3.setLayoutData((Object)new GridData(768));
        this.outFolderTxt = new Text((Composite)group3, 2048);
        this.outFolderTxt.setLayoutData((Object)new GridData(768));
        this.outFolderBrowseBtn = new Button((Composite)group3, 8);
        this.outFolderBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.outFolderBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cleanWhenExitBtn = new Button((Composite)group3, 32);
        this.cleanWhenExitBtn.setText(IsresourceBundle.getString((String)"cleanoutfolderwhenexit_lbl"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.cleanWhenExitBtn.setLayoutData((Object)gridData);
        Group group4 = new Group(composite3, 0);
        group4.setText(IsresourceBundle.getString((String)"deplfolder_lbl"));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group4.setLayout((Layout)gridLayout);
        group4.setLayoutData((Object)new GridData(768));
        this.deplFolderTxt = new Text((Composite)group4, 2048);
        this.deplFolderTxt.setLayoutData((Object)new GridData(768));
        this.deplFolderBrowseBtn = new Button((Composite)group4, 8);
        this.deplFolderBrowseBtn.setText(IsresourceBundle.getString((String)"browse_lbl"));
        this.deplFolderBrowseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite composite4 = new Composite(composite2, 0);
        gridData = new GridData(1808);
        composite4.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        Group group5 = new Group(composite4, 0);
        group5.setText("PreProcessors");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group5.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        group5.setLayoutData((Object)gridData);
        this.ppList = new List((Composite)group5, 2052);
        gridData = new GridData(1808);
        gridData.widthHint = 200;
        this.ppList.setLayoutData((Object)gridData);
        Composite composite5 = new Composite((Composite)group5, 0);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        composite5.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.fill = true;
        composite5.setLayout((Layout)rowLayout);
        this.addPPBtn = new Button(composite5, 8);
        this.addPPBtn.setText("New");
        this.addPPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.renamePPBtn = new Button(composite5, 8);
        this.renamePPBtn.setText("Rename");
        this.renamePPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removePPBtn = new Button(composite5, 8);
        this.removePPBtn.setText("Remove");
        this.removePPBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.ppTabContainer = new Composite(composite4, 0);
        gridData = new GridData(1808);
        this.ppTabContainer.setLayoutData((Object)gridData);
        this.stackLayout = new StackLayout();
        this.ppTabContainer.setLayout((Layout)this.stackLayout);
        this.ppList.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.load();
        this.validatePage();
        return composite2;
    }

    private void validatePage() {
        String[] stringArray = this.validatePage0();
        if (stringArray[0] != null) {
            this.setErrorMessage(null);
            this.setMessage(stringArray[0], 2);
        } else if (stringArray[1] != null) {
            this.setMessage(null);
            this.setErrorMessage(stringArray[1]);
        } else {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        this.setValid(stringArray[1] == null);
    }

    private String[] validatePage0() {
        String[] stringArray = new String[2];
        String string = this.validatePPExecNames();
        if (string != null) {
            stringArray[1] = string;
        } else {
            string = this.validateHostName();
            if (string != null) {
                stringArray[1] = string;
            } else {
                string = this.validatePortNumber();
                if (string != null) {
                    stringArray[1] = string;
                } else {
                    string = this.validateRCFile();
                    if (string != null) {
                        stringArray[0] = string;
                    }
                }
            }
        }
        return stringArray;
    }

    private String validatePortNumber() {
        if (this.portTxt.getText().length() > 0 && !PluginUtilities.validatePortNumber((String)this.portTxt.getText())) {
            return IsresourceBundle.getString((String)"invalid_port_msg");
        }
        return null;
    }

    private String validateHostName() {
        if (this.hostTxt.getText().length() > 0 && !PluginUtilities.validateHostName((String)this.hostTxt.getText())) {
            return IsresourceBundle.getString((String)"invalid_host_msg");
        }
        return null;
    }

    private String validateRCFile() {
        File file = new File(this.rcFileTxt.getText());
        if (!(file.exists() || file.getParentFile() != null && file.getParentFile().exists())) {
            return IsresourceBundle.getString((String)"set_valid_rc_conf_file_msg");
        }
        return null;
    }

    private String validatePPExecNames() {
        for (int i = 0; i < this.ppList.getItemCount(); ++i) {
            PPTabGroup pPTabGroup = (PPTabGroup)this.ppTabContainer.getData(this.ppList.getItem(i));
            String string = pPTabGroup.validate();
            if (string == null) continue;
            return pPTabGroup.nameTxt.getText() + " PreProcessor: " + string;
        }
        return null;
    }

    private void ppListSelchange(int n) {
        String string = this.ppList.getItem(n);
        PPTabGroup pPTabGroup = (PPTabGroup)this.ppTabContainer.getData(string);
        this.stackLayout.topControl = pPTabGroup.tab;
        pPTabGroup.tab.setSelection(0);
        this.ppTabContainer.layout();
    }

    private void load() {
        this.load(this.getPreferenceStore().contains("iscobol.remotecompiler.conffile") ? this.getPreferenceStore().getString("iscobol.remotecompiler.conffile") : this.getPreferenceStore().getDefaultString("iscobol.remotecompiler.conffile"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String string) {
        File file = new File(string);
        this.rcFileTxt.setText(string);
        Control[] controlArray = this.ppTabContainer.getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            controlArray[i].dispose();
        }
        this.ppList.removeAll();
        this.portTxt.setText("");
        this.outFolderTxt.setText("");
        this.deplFolderTxt.setText("");
        this.hostTxt.setText("");
        this.cleanWhenExitBtn.setSelection(true);
        if (file.exists()) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = null;
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader(new FileInputStream(file));
                Document document = documentBuilder.parse(new InputSource(inputStreamReader));
                Element element = document.getDocumentElement();
                RemoteCompiler remoteCompiler = new RemoteCompiler(element);
                this.portTxt.setText("" + remoteCompiler.getPortNumber());
                if (remoteCompiler.getHostName() != null) {
                    this.hostTxt.setText(remoteCompiler.getHostName());
                }
                if (remoteCompiler.getOutputFolder() != null) {
                    this.outFolderTxt.setText(remoteCompiler.getOutputFolder());
                }
                if (remoteCompiler.getDeploymentFolder() != null) {
                    this.deplFolderTxt.setText(remoteCompiler.getDeploymentFolder());
                }
                this.cleanWhenExitBtn.setSelection(remoteCompiler.getCleanOutputFolderWhenExit());
                PreProcessor[] preProcessorArray = remoteCompiler.getPreProcessors();
                if (preProcessorArray.length > 0) {
                    for (int i = 0; i < preProcessorArray.length; ++i) {
                        if (this.indexOfPP(preProcessorArray[i].getName()) >= 0) continue;
                        this.ppList.add(preProcessorArray[i].getName());
                        PPTabGroup pPTabGroup = new PPTabGroup(this, null);
                        pPTabGroup.createControl(this.ppTabContainer, preProcessorArray[i], null);
                        this.ppTabContainer.setData(preProcessorArray[i].getName(), (Object)pPTabGroup);
                    }
                    this.ppList.setSelection(0);
                    this.ppListSelchange(0);
                }
                this.createEmptyTabGroup();
            }
            catch (Exception exception) {
                PluginUtilities.logError((String)exception.getMessage());
            }
            finally {
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            this.createEmptyTabGroup();
        }
        this.validatePage();
    }

    private void createEmptyTabGroup() {
        PPTabGroup pPTabGroup = new PPTabGroup(this, null);
        Composite composite = new Composite(this.ppTabContainer, 0);
        composite.setLayout((Layout)new FillLayout());
        pPTabGroup.createControl(composite, null, null);
        this.stackLayout.topControl = composite;
        this.ppTabContainer.layout();
        pPTabGroup.tab.setVisible(false);
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(IscobolEditorPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("iscobol.remotecompiler.conffile", this.rcFileTxt.getText());
        try {
            this.writeXmlFile(this.rcFileTxt.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.performOk();
    }

    private void writeXmlFile(String string) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("remoteCompiler");
        document.appendChild(element);
        if (this.portTxt.getText().length() > 0) {
            element.setAttribute("portNumber", this.portTxt.getText());
        }
        if (this.hostTxt.getText().length() > 0) {
            element.setAttribute("hostName", this.hostTxt.getText());
        }
        if (this.outFolderTxt.getText().length() > 0) {
            element.setAttribute("outputFolder", this.outFolderTxt.getText());
        }
        if (this.deplFolderTxt.getText().length() > 0) {
            element.setAttribute("deploymentFolder", this.deplFolderTxt.getText());
        }
        element.setAttribute("cleanOutputFolderWhenExit", Boolean.toString(this.cleanWhenExitBtn.getSelection()));
        for (int i = 0; i < this.ppList.getItemCount(); ++i) {
            Object object6;
            object5 = this.ppList.getItem(i);
            object4 = (PPTabGroup)this.ppTabContainer.getData((String)object5);
            object3 = document.createElement("preProcessor");
            element.appendChild((Node)object3);
            object3.setAttribute("name", ((PPTabGroup)object4).nameTxt.getText());
            object3.setAttribute("executable", ((PPTabGroup)object4).executableTxt.getText());
            if (((PPTabGroup)object4).outExtTxt.getText().length() > 0) {
                object3.setAttribute("outputFileExt", ((PPTabGroup)object4).outExtTxt.getText());
            }
            if (((PPTabGroup)object4).lstExtTxt.getText().length() > 0) {
                object3.setAttribute("listFileExt", ((PPTabGroup)object4).lstExtTxt.getText());
            }
            if (((PPTabGroup)object4).errExtTxt.getText().length() > 0) {
                object3.setAttribute("errorFileExt", ((PPTabGroup)object4).errExtTxt.getText());
            }
            object2 = document.createElement("optionList");
            object3.appendChild((Node)object2);
            for (int j = 0; j < ((PPTabGroup)object4).optTbl.getItemCount(); ++j) {
                Element element2 = document.createElement("option");
                object2.appendChild(element2);
                object6 = ((PPTabGroup)object4).optTbl.getItem(j);
                if (object6.getText(1).length() > 0) {
                    element2.setAttribute("if", object6.getText(1));
                }
                element2.appendChild(document.createTextNode(object6.getText(0)));
            }
            object = document.createElement("environment");
            object3.appendChild((Node)object);
            object.setAttribute("append", Boolean.toString(((PPTabGroup)object4).appendEnvBtn.getSelection()));
            for (int j = 0; j < ((PPTabGroup)object4).varTbl.getItemCount(); ++j) {
                object6 = document.createElement("variable");
                object.appendChild((Node)object6);
                TableItem tableItem = ((PPTabGroup)object4).varTbl.getItem(j);
                object6.setAttribute("name", tableItem.getText(0));
                object6.setAttribute("value", tableItem.getText(1));
            }
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", new Integer(3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        object5 = transformerFactory.newTransformer();
        object4 = ((Transformer)object5).getOutputProperties();
        ((Properties)object4).setProperty("indent", "yes");
        ((Transformer)object5).setOutputProperties((Properties)object4);
        object3 = new DOMSource(document);
        object2 = new FileOutputStream(string);
        object = new StreamResult(new OutputStreamWriter((OutputStream)object2));
        ((Transformer)object5).transform((Source)object3, (Result)object);
        ((FileOutputStream)object2).close();
    }

    protected void performDefaults() {
        String string = this.getPreferenceStore().getDefaultString("iscobol.remotecompiler.conffile");
        this.load(string);
        super.performDefaults();
    }

    static /* synthetic */ void access$100(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        remoteCompilerPreferencePage.validatePage();
    }

    static /* synthetic */ Button access$200(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.rcFileBrowseBtn;
    }

    static /* synthetic */ void access$300(RemoteCompilerPreferencePage remoteCompilerPreferencePage, String string) {
        remoteCompilerPreferencePage.load(string);
    }

    static /* synthetic */ Text access$400(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.outFolderTxt;
    }

    static /* synthetic */ Text access$500(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.deplFolderTxt;
    }

    static /* synthetic */ Button access$600(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.addPPBtn;
    }

    static /* synthetic */ String access$700(RemoteCompilerPreferencePage remoteCompilerPreferencePage, String string) {
        return remoteCompilerPreferencePage.validatePPName(string);
    }

    static /* synthetic */ List access$800(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.ppList;
    }

    static /* synthetic */ Composite access$1000(RemoteCompilerPreferencePage remoteCompilerPreferencePage) {
        return remoteCompilerPreferencePage.ppTabContainer;
    }

    static /* synthetic */ void access$1100(RemoteCompilerPreferencePage remoteCompilerPreferencePage, int n) {
        remoteCompilerPreferencePage.ppListSelchange(n);
    }

    static /* synthetic */ String access$1200(RemoteCompilerPreferencePage remoteCompilerPreferencePage, String string, int n) {
        return remoteCompilerPreferencePage.validatePPName(string, n);
    }
}

