/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.preferences;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.preferences.RunDebugPreferencePage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RunDebugPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private RadioGroupFieldEditor switchBackPerspEditor;
    private Button useExternalDebugBtn;
    private Button useStandardDebugBtn;
    private int appFlags;
    private TreeItem iscobolItem;
    private TreeItem wd2Item;
    private Text maxHexDumpLengthTxt;
    private Text hexDumpStartTxt;
    private Text maxArrayLengthTxt;
    private Text arrayStartTxt;
    private Text maxTextLengthTxt;
    private boolean wd2PluginInstalled = Platform.getBundle((String)"com.iscobol.plugins.webdirectlauncher") != null;
    private boolean modifyListenerEnabled = true;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout());
        boolean bl = IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.useextdebug");
        this.useStandardDebugBtn = new Button((Composite)group, 16);
        this.useStandardDebugBtn.setText(IsresourceBundle.getString((String)"use_standard_debugger_lbl"));
        this.useExternalDebugBtn = new Button((Composite)group, 16);
        this.useExternalDebugBtn.setText(IsresourceBundle.getString((String)"use_external_debugger_lbl"));
        if (bl) {
            this.useExternalDebugBtn.setSelection(true);
        } else {
            this.useStandardDebugBtn.setSelection(true);
        }
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        String[][] stringArray = new String[][]{{"Yes", Integer.toString(0)}, {"No", Integer.toString(1)}, {"Prompt", Integer.toString(2)}};
        this.switchBackPerspEditor = new RadioGroupFieldEditor("iscobol.switchback.ispersp", IsresourceBundle.getString((String)"switch_back_lbl"), 3, stringArray, composite3, true);
        this.switchBackPerspEditor.setPage((DialogPage)this);
        this.switchBackPerspEditor.setPreferenceStore(this.getPreferenceStore());
        this.switchBackPerspEditor.load();
        this.appFlags = Integer.parseInt(IscobolEditorPlugin.getStringFromStore((String)"iscobol.rundebugas"));
        Group group2 = new Group(composite2, 0);
        group2.setText(IsresourceBundle.getString((String)"run_debug_as_lbl"));
        GridData gridData = new GridData(768);
        gridData.heightHint = 80;
        group2.setLayoutData((Object)gridData);
        group2.setLayout((Layout)new GridLayout());
        Tree tree = new Tree((Composite)group2, 2080);
        gridData = new GridData(1808);
        tree.setLayoutData((Object)gridData);
        this.iscobolItem = new TreeItem(tree, 0);
        this.iscobolItem.setText(IsresourceBundle.getString((String)"iscobol.application.name"));
        this.iscobolItem.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/iscobol16x16.png"));
        if (this.wd2PluginInstalled) {
            this.wd2Item = new TreeItem(tree, 0);
            this.wd2Item.setText(IsresourceBundle.getString((String)"iscobol.wd2application.name"));
            this.wd2Item.setImage(IscobolEditorPlugin.getDefault().getImageProvider().getImage("/wd2.png"));
        }
        Group group3 = new Group(composite2, 0);
        group3.setText("Details View Settings");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group3.setLayout((Layout)gridLayout);
        1 var12_12 = new /* Unavailable Anonymous Inner Class!! */;
        this.maxHexDumpLengthTxt = this.createTextField("iscobol.debug.maxhexdumplength", (ModifyListener)var12_12, "Max hex dump length for COBOL variables:", group3);
        this.hexDumpStartTxt = this.createTextField("iscobol.debug.hexdumpstartoffset", (ModifyListener)var12_12, "Starting offset into hex dump when max length is exceeded:", group3);
        this.maxArrayLengthTxt = this.createTextField("iscobol.debug.maxarraylength", (ModifyListener)var12_12, "Max array length for COBOL arrays:", group3);
        this.arrayStartTxt = this.createTextField("iscobol.debug.startarrayindex", (ModifyListener)var12_12, "Starting index into array when max length is exceeded:", group3);
        this.maxTextLengthTxt = this.createTextField("iscobol.debug.maxtextlength", (ModifyListener)var12_12, "Max text length for COBOL variables:", group3);
        this.updateItems();
        tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private Text createTextField(String string, ModifyListener modifyListener, String string2, Group group) {
        Label label = new Label((Composite)group, 0);
        label.setText(string2);
        Text text = new Text((Composite)group, 133120);
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        text.setLayoutData((Object)gridData);
        text.setText(IscobolEditorPlugin.getStringFromStore((String)string));
        text.addModifyListener(modifyListener);
        return text;
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(IscobolEditorPlugin.getDefault().getPreferenceStore());
    }

    private void validatePage() {
        String string = this.validatePage0();
        this.setErrorMessage(string);
        this.setValid(string == null);
        this.updateApplyButton();
    }

    private String validatePage0() {
        int n;
        this.appFlags = 0;
        if (this.iscobolItem.getChecked()) {
            ++this.appFlags;
        }
        if (this.wd2Item != null && this.wd2Item.getChecked()) {
            this.appFlags += 2;
        }
        if (!(this.iscobolItem.getChecked() || this.wd2Item != null && this.wd2Item.getChecked())) {
            return "Select an 'Run/Debug as' application";
        }
        try {
            n = Integer.parseInt(this.maxHexDumpLengthTxt.getText());
            if (n <= 0) {
                return "Max hex dump length must be > 0";
            }
            if (n > 1024) {
                return "Max hex dump length must be <= 1024";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid max hex dump length";
        }
        try {
            n = Integer.parseInt(this.hexDumpStartTxt.getText());
            if (n <= 0) {
                return "Start hex dump offset must be > 0";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid start hex dump offset";
        }
        try {
            n = Integer.parseInt(this.maxArrayLengthTxt.getText());
            if (n <= 0) {
                return "Max array length must be > 0";
            }
            if (n > 100) {
                return "Max array length must be <= 100";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid max array length";
        }
        try {
            n = Integer.parseInt(this.arrayStartTxt.getText());
            if (n <= 0) {
                return "Start array index must be > 0";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid start array length";
        }
        try {
            n = Integer.parseInt(this.maxTextLengthTxt.getText());
            if (n <= 0) {
                return "Max text length must be > 0";
            }
            if (n > 2048) {
                return "Max text length must be <= 2048";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Invalid max text length";
        }
        return null;
    }

    private void updateItems() {
        if ((this.appFlags & 1) == 1) {
            this.iscobolItem.setChecked(true);
        }
        if (this.wd2Item != null && (this.appFlags & 2) == 2) {
            this.wd2Item.setChecked(true);
        }
    }

    public boolean performOk() {
        this.switchBackPerspEditor.store();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        if (this.appFlags > 0) {
            this.getPreferenceStore().setValue("iscobol.rundebugas", this.appFlags);
        }
        iPreferenceStore.setValue("iscobol.debug.maxhexdumplength", this.maxHexDumpLengthTxt.getText());
        iPreferenceStore.setValue("iscobol.debug.hexdumpstartoffset", this.hexDumpStartTxt.getText());
        iPreferenceStore.setValue("iscobol.debug.maxarraylength", this.maxArrayLengthTxt.getText());
        iPreferenceStore.setValue("iscobol.debug.startarrayindex", this.arrayStartTxt.getText());
        iPreferenceStore.setValue("iscobol.debug.maxtextlength", this.maxTextLengthTxt.getText());
        iPreferenceStore.setValue("iscobol.useextdebug", this.useExternalDebugBtn.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        this.switchBackPerspEditor.loadDefault();
        this.appFlags = this.getPreferenceStore().getDefaultInt("iscobol.rundebugas");
        this.updateItems();
        this.modifyListenerEnabled = false;
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.useStandardDebugBtn.setSelection(true);
        this.useExternalDebugBtn.setSelection(false);
        this.maxHexDumpLengthTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.maxhexdumplength"));
        this.hexDumpStartTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.hexdumpstartoffset"));
        this.maxArrayLengthTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.maxarraylength"));
        this.arrayStartTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.startarrayindex"));
        this.maxTextLengthTxt.setText(iPreferenceStore.getDefaultString("iscobol.debug.maxtextlength"));
        this.validatePage();
        this.modifyListenerEnabled = true;
    }

    static /* synthetic */ boolean access$000(RunDebugPreferencePage runDebugPreferencePage) {
        return runDebugPreferencePage.modifyListenerEnabled;
    }

    static /* synthetic */ void access$100(RunDebugPreferencePage runDebugPreferencePage) {
        runDebugPreferencePage.validatePage();
    }
}

