/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.tipoftheday;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.IsresourceBundle;
import com.iscobol.plugins.editor.util.PluginUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TipOfTheDayDialog
extends MessageDialogWithToggle {
    private static final int CLOSE_ID = 257;
    private static final int NEXT_TIP_ID = 256;
    private String[] htmlFiles;
    private Random random = new Random();
    private Browser browser;
    private int fileIndex = -1;
    private IDialogSettings dialogSettings;
    public static final String SETTINGS_FILENAME = TipOfTheDayDialog.class.getName() + ".settings";

    public TipOfTheDayDialog(Shell shell, String[] stringArray, boolean bl) {
        super(shell, IsresourceBundle.getString((String)"tip_of_the_day_title"), null, "", 0, new String[]{IsresourceBundle.getString((String)"next_tip_lbl"), IsresourceBundle.getString((String)"close_lbl")}, 0, IsresourceBundle.getString((String)"show_tip_of_the_day_lbl"), bl);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.htmlFiles = stringArray;
    }

    public boolean close() {
        boolean bl = super.close();
        this.saveBounds();
        return bl;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        if (this.dialogSettings == null) {
            this.dialogSettings = new DialogSettings(this.getClass().getName());
            this.loadBounds();
        }
        return this.dialogSettings;
    }

    private void loadBounds() {
        if (!IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.tipoftheday.rememberbounds")) {
            return;
        }
        File file = PluginUtilities.getStateLocation();
        if (file != null) {
            try {
                this.dialogSettings.load(file.getAbsolutePath() + File.separator + SETTINGS_FILENAME);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void saveBounds() {
        if (!IscobolEditorPlugin.getBooleanFromStore((String)"iscobol.tipoftheday.rememberbounds")) {
            return;
        }
        File file = PluginUtilities.getStateLocation();
        if (file != null) {
            try {
                this.dialogSettings.save(file.getAbsolutePath() + File.separator + SETTINGS_FILENAME);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Point getInitialLocation(Point point) {
        return super.getInitialLocation(point);
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected void buttonPressed(int n) {
        switch (n) {
            default: {
                super.buttonPressed(n);
                break;
            }
            case 256: {
                this.showNextTip();
            }
        }
    }

    private void showNextTip() {
        String string = this.getUrl();
        this.browser.setUrl(string);
    }

    protected Control createMessageArea(Composite composite) {
        return null;
    }

    protected Control createCustomArea(Composite composite) {
        GridData gridData;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        if (composite.getLayout() instanceof GridLayout) {
            gridLayout = (GridLayout)composite.getLayout();
            gridLayout.marginTop = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            gridData = new GridData(1808);
            composite2.setLayoutData((Object)gridData);
        }
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData(1808);
        gridData.widthHint = 650;
        gridData.heightHint = 350;
        composite3.setLayoutData((Object)gridData);
        composite3.setLayout((Layout)new FillLayout());
        this.browser = new Browser(composite3, 2048);
        this.showNextTip();
        return composite2;
    }

    private String getUrl() {
        int n = this.fileIndex;
        while (this.fileIndex == n) {
            this.fileIndex = this.random.nextInt(this.htmlFiles.length);
        }
        return "file://" + this.htmlFiles[this.fileIndex];
    }
}

