/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.plugins.editor.util;

/*
 * Exception performing whole class analysis ignored.
 */
public class CobolFormatter {
    private static final int ANSI_LIMIT = 64;
    private static final String eol = System.getProperty("line.separator", "\n");
    private boolean ansiFormat;
    private boolean decPointComma;
    private int lineLimit = 250;

    public CobolFormatter() {
        this(true, false);
    }

    public CobolFormatter(boolean bl) {
        this(bl, false);
    }

    public CobolFormatter(boolean bl, boolean bl2) {
        this.ansiFormat = bl;
        this.decPointComma = bl2;
    }

    private String spaces(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private String formatLineTerminal(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() <= this.lineLimit) {
            return stringBuilder.append(string).append(eol).toString();
        }
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
        }
        if (n > this.lineLimit) {
            n -= this.lineLimit;
            string = string.substring(this.lineLimit);
        }
        while (string.length() > this.lineLimit) {
            int n2;
            char[] cArray = string.toCharArray();
            int[] nArray = this.lastStringOffsets(cArray, this.lineLimit);
            for (n2 = this.lineLimit; n2 >= n && (!this.isSeparator(string, n2) || n2 >= nArray[0] && n2 <= nArray[1]); --n2) {
            }
            if (n2 >= n) {
                stringBuilder.append(string.substring(0, n2 + 1)).append(eol);
                string = this.spaces(n) + string.substring(n2 + 1);
                continue;
            }
            for (n2 = this.lineLimit + 1; n2 < string.length() - 1 && (!this.isSeparator(string, n2) || n2 >= nArray[0] && n2 <= nArray[1]); ++n2) {
            }
            if (n2 < string.length() - 1) {
                stringBuilder.append(string.substring(0, n2 + 1)).append(eol);
                string = this.spaces(n) + string.substring(n2 + 1);
                continue;
            }
            stringBuilder.append(string);
            string = "";
        }
        if (string.length() > 0) {
            stringBuilder.append(string);
        }
        stringBuilder.append(eol);
        return stringBuilder.toString();
    }

    private int[] lastStringOffsets(char[] cArray, int n) {
        int n2 = 0;
        int[] nArray = new int[]{-1, -1};
        boolean bl = false;
        for (int i = 0; i < cArray.length && (i <= n || bl); ++i) {
            if (cArray[i] == '\"') {
                if (bl) {
                    if (n2 != 34) continue;
                    nArray[1] = i;
                    n2 = 0;
                    bl = false;
                    continue;
                }
                n2 = 34;
                nArray[0] = i;
                bl = true;
                continue;
            }
            if (cArray[i] != '\'') continue;
            if (bl) {
                if (n2 != 39) continue;
                nArray[1] = i;
                n2 = 0;
                bl = false;
                continue;
            }
            n2 = 39;
            nArray[0] = i;
            bl = true;
        }
        return nArray;
    }

    private String formatLineANSI(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() <= 64) {
            return stringBuilder.append("       ").append(string).append(eol).toString();
        }
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
        }
        if (n > 64) {
            n -= 64;
            string = string.substring(64);
        }
        boolean bl = false;
        while (string.length() > 64) {
            int n2;
            char[] cArray = string.toCharArray();
            int[] nArray = this.lastStringOffsets(cArray, 64);
            if (nArray[0] <= 64 && nArray[1] > 64) {
                stringBuilder.append("      ");
                if (bl) {
                    stringBuilder.append("-");
                } else {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string.substring(0, 65)).append(eol);
                bl = true;
                string = this.spaces(n) + cArray[nArray[0]] + string.substring(65);
                continue;
            }
            for (n2 = 64; n2 >= n && !this.isSeparator(cArray, n2); --n2) {
            }
            if (n2 >= n) {
                stringBuilder.append("      ");
                if (bl) {
                    stringBuilder.append("-");
                } else {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(string.substring(0, n2 + 1)).append(eol);
                string = this.spaces(n) + string.substring(n2 + 1);
                bl = false;
                continue;
            }
            stringBuilder.append("      ");
            if (bl) {
                stringBuilder.append("-");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string.substring(0, 65)).append(eol);
            bl = cArray.length > 65 && !this.isSeparator(cArray, 65);
            string = this.spaces(n) + string.substring(65);
        }
        if (string.length() > 0) {
            stringBuilder.append("      ");
            if (bl) {
                stringBuilder.append("-");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(eol);
        return stringBuilder.toString();
    }

    public static boolean isSeparator(char c) {
        return !Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != '@';
    }

    private boolean isDecimalSeparator(char c) {
        return c == '.' && !this.decPointComma || c == ',' && this.decPointComma;
    }

    private boolean isSeparator(String string, int n) {
        char c = string.charAt(n);
        if (!CobolFormatter.isSeparator((char)c)) {
            return false;
        }
        return !this.isDecimalSeparator(c) || n >= string.length() - 1 || !Character.isDigit(string.charAt(n + 1));
    }

    private boolean isSeparator(char[] cArray, int n) {
        char c = cArray[n];
        if (!CobolFormatter.isSeparator((char)c)) {
            return false;
        }
        return !this.isDecimalSeparator(c) || n >= cArray.length - 1 || !Character.isDigit(cArray[n + 1]);
    }

    public String formatComment(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.ansiFormat) {
            stringBuilder.append("      *");
        } else {
            stringBuilder.append("*>");
        }
        stringBuilder.append(string);
        stringBuilder.append(eol);
        return stringBuilder.toString();
    }

    public String formatLine(String string) {
        if (this.ansiFormat) {
            return this.formatLineANSI(string);
        }
        return this.formatLineTerminal(string);
    }

    public int getLineLimit() {
        return this.lineLimit;
    }

    public void setLineLimit(int n) {
        this.lineLimit = n;
        if (this.lineLimit <= 0 || this.lineLimit > 320) {
            this.lineLimit = 320;
        }
    }

    public boolean isAnsiFormat() {
        return this.ansiFormat;
    }

    public void setAnsiFormat(boolean bl) {
        this.ansiFormat = bl;
    }

    public boolean isDecPointComma() {
        return this.decPointComma;
    }

    public void setDecPointComma(boolean bl) {
        this.decPointComma = bl;
    }

    public static void main(String[] stringArray) {
        String string = "                                                                                    31 VAR PIC X(2)";
        CobolFormatter cobolFormatter = new CobolFormatter();
        System.out.println(cobolFormatter.formatLineTerminal(string));
    }
}

